<?php

namespace PHPMaker2021\school;

use Doctrine\DBAL\ParameterType;

/**
 * Page class
 */
class ConfCityAddopt extends ConfCity
{
    use MessagesTrait;

    // Page ID
    public $PageID = "addopt";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Table name
    public $TableName = 'conf_city';

    // Page object name
    public $PageObjName = "ConfCityAddopt";

    // Rendering View
    public $RenderingView = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl()
    {
        $url = ScriptName() . "?";
        if ($this->UseTokenInUrl) {
            $url .= "t=" . $this->TableVar . "&"; // Add page token
        }
        return $url;
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Validate page request
    protected function isPageRequest()
    {
        global $CurrentForm;
        if ($this->UseTokenInUrl) {
            if ($CurrentForm) {
                return ($this->TableVar == $CurrentForm->getValue("t"));
            }
            if (Get("t") !== null) {
                return ($this->TableVar == Get("t"));
            }
        }
        return true;
    }

    // Constructor
    public function __construct()
    {
        global $Language, $DashboardReport, $DebugTimer;
        global $UserTable;

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Parent constuctor
        parent::__construct();

        // Table object (conf_city)
        if (!isset($GLOBALS["conf_city"]) || get_class($GLOBALS["conf_city"]) == PROJECT_NAMESPACE . "conf_city") {
            $GLOBALS["conf_city"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl();

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'conf_city');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] = $GLOBALS["Conn"] ?? $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents($stream = null): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $ExportFileName, $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

         // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();

        // Export
        if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
            $content = $this->getContents();
            if ($ExportFileName == "") {
                $ExportFileName = $this->TableVar;
            }
            $class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
            if (class_exists($class)) {
                $doc = new $class(Container("conf_city"));
                $doc->Text = @$content;
                if ($this->isExport("email")) {
                    echo $this->exportEmail($doc->Text);
                } else {
                    $doc->export();
                }
                DeleteTempImages(); // Delete temp images
                return;
            }
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show error
                WriteJson(array_merge(["success" => false], $this->getMessages()));
            }
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup()
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;

        // Get lookup parameters
        $lookupType = Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal")) {
            $searchValue = Post("sv", "");
            $pageSize = Post("recperpage", 10);
            $offset = Post("start", 0);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = Param("q", "");
            $pageSize = Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
            $start = Param("start", -1);
            $start = is_numeric($start) ? (int)$start : -1;
            $page = Param("page", -1);
            $page = is_numeric($page) ? (int)$page : -1;
            $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        }
        $userSelect = Decrypt(Post("s", ""));
        $userFilter = Decrypt(Post("f", ""));
        $userOrderBy = Decrypt(Post("o", ""));
        $keys = Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        $lookup->toJson($this); // Use settings from current page
    }
    public $IsModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm;

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->id->Visible = false;
        $this->city->setVisibility();
        $this->uf->setVisibility();
        $this->ufId->setVisibility();
        $this->county->setVisibility();
        $this->longitude->setVisibility();
        $this->latitude->setVisibility();
        $this->hideFieldsForAddEdit();

        // Do not use lookup cache
        $this->setUseLookupCache(false);

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->uf);
        $this->setupLookupOptions($this->ufId);

        // Set up Breadcrumb
        //$this->setupBreadcrumb(); // Not used
        $this->loadRowValues(); // Load default values

        // Render row
        $this->RowType = ROWTYPE_ADD; // Render add type
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Pass table and field properties to client side
            $this->toClientVar(["tableCaption"], ["caption", "Visible", "Required", "IsInvalid", "Raw"]);

            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->id->CurrentValue = null;
        $this->id->OldValue = $this->id->CurrentValue;
        $this->city->CurrentValue = null;
        $this->city->OldValue = $this->city->CurrentValue;
        $this->uf->CurrentValue = null;
        $this->uf->OldValue = $this->uf->CurrentValue;
        $this->ufId->CurrentValue = null;
        $this->ufId->OldValue = $this->ufId->CurrentValue;
        $this->county->CurrentValue = null;
        $this->county->OldValue = $this->county->CurrentValue;
        $this->longitude->CurrentValue = null;
        $this->longitude->OldValue = $this->longitude->CurrentValue;
        $this->latitude->CurrentValue = null;
        $this->latitude->OldValue = $this->latitude->CurrentValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;

        // Check field name 'city' first before field var 'x_city'
        $val = $CurrentForm->hasValue("city") ? $CurrentForm->getValue("city") : $CurrentForm->getValue("x_city");
        if (!$this->city->IsDetailKey) {
            $this->city->setFormValue(ConvertFromUtf8($val));
        }

        // Check field name 'uf' first before field var 'x_uf'
        $val = $CurrentForm->hasValue("uf") ? $CurrentForm->getValue("uf") : $CurrentForm->getValue("x_uf");
        if (!$this->uf->IsDetailKey) {
            $this->uf->setFormValue(ConvertFromUtf8($val));
        }

        // Check field name 'ufId' first before field var 'x_ufId'
        $val = $CurrentForm->hasValue("ufId") ? $CurrentForm->getValue("ufId") : $CurrentForm->getValue("x_ufId");
        if (!$this->ufId->IsDetailKey) {
            $this->ufId->setFormValue(ConvertFromUtf8($val));
        }

        // Check field name 'county' first before field var 'x_county'
        $val = $CurrentForm->hasValue("county") ? $CurrentForm->getValue("county") : $CurrentForm->getValue("x_county");
        if (!$this->county->IsDetailKey) {
            $this->county->setFormValue(ConvertFromUtf8($val));
        }

        // Check field name 'longitude' first before field var 'x_longitude'
        $val = $CurrentForm->hasValue("longitude") ? $CurrentForm->getValue("longitude") : $CurrentForm->getValue("x_longitude");
        if (!$this->longitude->IsDetailKey) {
            $this->longitude->setFormValue(ConvertFromUtf8($val));
        }

        // Check field name 'latitude' first before field var 'x_latitude'
        $val = $CurrentForm->hasValue("latitude") ? $CurrentForm->getValue("latitude") : $CurrentForm->getValue("x_latitude");
        if (!$this->latitude->IsDetailKey) {
            $this->latitude->setFormValue(ConvertFromUtf8($val));
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->city->CurrentValue = ConvertToUtf8($this->city->FormValue);
        $this->uf->CurrentValue = ConvertToUtf8($this->uf->FormValue);
        $this->ufId->CurrentValue = ConvertToUtf8($this->ufId->FormValue);
        $this->county->CurrentValue = ConvertToUtf8($this->county->FormValue);
        $this->longitude->CurrentValue = ConvertToUtf8($this->longitude->FormValue);
        $this->latitude->CurrentValue = ConvertToUtf8($this->latitude->FormValue);
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssoc($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }

        // Call Row Selected event
        $this->rowSelected($row);
        if (!$rs) {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->city->setDbValue($row['city']);
        $this->uf->setDbValue($row['uf']);
        $this->ufId->setDbValue($row['ufId']);
        $this->county->setDbValue($row['county']);
        $this->longitude->setDbValue($row['longitude']);
        $this->latitude->setDbValue($row['latitude']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $this->loadDefaultValues();
        $row = [];
        $row['id'] = $this->id->CurrentValue;
        $row['city'] = $this->city->CurrentValue;
        $row['uf'] = $this->uf->CurrentValue;
        $row['ufId'] = $this->ufId->CurrentValue;
        $row['county'] = $this->county->CurrentValue;
        $row['longitude'] = $this->longitude->CurrentValue;
        $row['latitude'] = $this->latitude->CurrentValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Convert decimal values if posted back
        if ($this->longitude->FormValue == $this->longitude->CurrentValue && is_numeric(ConvertToFloatString($this->longitude->CurrentValue))) {
            $this->longitude->CurrentValue = ConvertToFloatString($this->longitude->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->latitude->FormValue == $this->latitude->CurrentValue && is_numeric(ConvertToFloatString($this->latitude->CurrentValue))) {
            $this->latitude->CurrentValue = ConvertToFloatString($this->latitude->CurrentValue);
        }

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // city

        // uf

        // ufId

        // county

        // longitude

        // latitude
        if ($this->RowType == ROWTYPE_VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewCustomAttributes = "";

            // city
            $this->city->ViewValue = $this->city->CurrentValue;
            $this->city->ViewCustomAttributes = "";

            // uf
            $this->uf->ViewValue = $this->uf->CurrentValue;
            $curVal = trim(strval($this->uf->CurrentValue));
            if ($curVal != "") {
                $this->uf->ViewValue = $this->uf->lookupCacheOption($curVal);
                if ($this->uf->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->uf->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->uf->Lookup->renderViewRow($rswrk[0]);
                        $this->uf->ViewValue = $this->uf->displayValue($arwrk);
                    } else {
                        $this->uf->ViewValue = $this->uf->CurrentValue;
                    }
                }
            } else {
                $this->uf->ViewValue = null;
            }
            $this->uf->ViewCustomAttributes = "";

            // ufId
            $this->ufId->ViewValue = $this->ufId->CurrentValue;
            $curVal = trim(strval($this->ufId->CurrentValue));
            if ($curVal != "") {
                $this->ufId->ViewValue = $this->ufId->lookupCacheOption($curVal);
                if ($this->ufId->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->ufId->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ufId->Lookup->renderViewRow($rswrk[0]);
                        $this->ufId->ViewValue = $this->ufId->displayValue($arwrk);
                    } else {
                        $this->ufId->ViewValue = $this->ufId->CurrentValue;
                    }
                }
            } else {
                $this->ufId->ViewValue = null;
            }
            $this->ufId->ViewCustomAttributes = "";

            // county
            $this->county->ViewValue = $this->county->CurrentValue;
            $this->county->ViewCustomAttributes = "";

            // longitude
            $this->longitude->ViewValue = $this->longitude->CurrentValue;
            $this->longitude->ViewValue = FormatNumber($this->longitude->ViewValue, 2, -2, -2, -2);
            $this->longitude->ViewCustomAttributes = "";

            // latitude
            $this->latitude->ViewValue = $this->latitude->CurrentValue;
            $this->latitude->ViewValue = FormatNumber($this->latitude->ViewValue, 2, -2, -2, -2);
            $this->latitude->ViewCustomAttributes = "";

            // city
            $this->city->LinkCustomAttributes = "";
            $this->city->HrefValue = "";
            $this->city->TooltipValue = "";

            // uf
            $this->uf->LinkCustomAttributes = "";
            $this->uf->HrefValue = "";
            $this->uf->TooltipValue = "";

            // ufId
            $this->ufId->LinkCustomAttributes = "";
            $this->ufId->HrefValue = "";
            $this->ufId->TooltipValue = "";

            // county
            $this->county->LinkCustomAttributes = "";
            $this->county->HrefValue = "";
            $this->county->TooltipValue = "";

            // longitude
            $this->longitude->LinkCustomAttributes = "";
            $this->longitude->HrefValue = "";
            $this->longitude->TooltipValue = "";

            // latitude
            $this->latitude->LinkCustomAttributes = "";
            $this->latitude->HrefValue = "";
            $this->latitude->TooltipValue = "";
        } elseif ($this->RowType == ROWTYPE_ADD) {
            // city
            $this->city->EditAttrs["class"] = "form-control";
            $this->city->EditCustomAttributes = "";
            if (!$this->city->Raw) {
                $this->city->CurrentValue = HtmlDecode($this->city->CurrentValue);
            }
            $this->city->EditValue = HtmlEncode($this->city->CurrentValue);
            $this->city->PlaceHolder = RemoveHtml($this->city->caption());

            // uf
            $this->uf->EditAttrs["class"] = "form-control";
            $this->uf->EditCustomAttributes = "";
            if (!$this->uf->Raw) {
                $this->uf->CurrentValue = HtmlDecode($this->uf->CurrentValue);
            }
            $this->uf->EditValue = HtmlEncode($this->uf->CurrentValue);
            $curVal = trim(strval($this->uf->CurrentValue));
            if ($curVal != "") {
                $this->uf->EditValue = $this->uf->lookupCacheOption($curVal);
                if ($this->uf->EditValue === null) { // Lookup from database
                    $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->uf->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->uf->Lookup->renderViewRow($rswrk[0]);
                        $this->uf->EditValue = $this->uf->displayValue($arwrk);
                    } else {
                        $this->uf->EditValue = HtmlEncode($this->uf->CurrentValue);
                    }
                }
            } else {
                $this->uf->EditValue = null;
            }
            $this->uf->PlaceHolder = RemoveHtml($this->uf->caption());

            // ufId
            $this->ufId->EditAttrs["class"] = "form-control";
            $this->ufId->EditCustomAttributes = "";
            $this->ufId->EditValue = HtmlEncode($this->ufId->CurrentValue);
            $curVal = trim(strval($this->ufId->CurrentValue));
            if ($curVal != "") {
                $this->ufId->EditValue = $this->ufId->lookupCacheOption($curVal);
                if ($this->ufId->EditValue === null) { // Lookup from database
                    $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->ufId->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ufId->Lookup->renderViewRow($rswrk[0]);
                        $this->ufId->EditValue = $this->ufId->displayValue($arwrk);
                    } else {
                        $this->ufId->EditValue = HtmlEncode($this->ufId->CurrentValue);
                    }
                }
            } else {
                $this->ufId->EditValue = null;
            }
            $this->ufId->PlaceHolder = RemoveHtml($this->ufId->caption());

            // county
            $this->county->EditAttrs["class"] = "form-control";
            $this->county->EditCustomAttributes = "";
            if (!$this->county->Raw) {
                $this->county->CurrentValue = HtmlDecode($this->county->CurrentValue);
            }
            $this->county->EditValue = HtmlEncode($this->county->CurrentValue);
            $this->county->PlaceHolder = RemoveHtml($this->county->caption());

            // longitude
            $this->longitude->EditAttrs["class"] = "form-control";
            $this->longitude->EditCustomAttributes = "";
            $this->longitude->EditValue = HtmlEncode($this->longitude->CurrentValue);
            $this->longitude->PlaceHolder = RemoveHtml($this->longitude->caption());
            if (strval($this->longitude->EditValue) != "" && is_numeric($this->longitude->EditValue)) {
                $this->longitude->EditValue = FormatNumber($this->longitude->EditValue, -2, -2, -2, -2);
            }

            // latitude
            $this->latitude->EditAttrs["class"] = "form-control";
            $this->latitude->EditCustomAttributes = "";
            $this->latitude->EditValue = HtmlEncode($this->latitude->CurrentValue);
            $this->latitude->PlaceHolder = RemoveHtml($this->latitude->caption());
            if (strval($this->latitude->EditValue) != "" && is_numeric($this->latitude->EditValue)) {
                $this->latitude->EditValue = FormatNumber($this->latitude->EditValue, -2, -2, -2, -2);
            }

            // Add refer script

            // city
            $this->city->LinkCustomAttributes = "";
            $this->city->HrefValue = "";

            // uf
            $this->uf->LinkCustomAttributes = "";
            $this->uf->HrefValue = "";

            // ufId
            $this->ufId->LinkCustomAttributes = "";
            $this->ufId->HrefValue = "";

            // county
            $this->county->LinkCustomAttributes = "";
            $this->county->HrefValue = "";

            // longitude
            $this->longitude->LinkCustomAttributes = "";
            $this->longitude->HrefValue = "";

            // latitude
            $this->latitude->LinkCustomAttributes = "";
            $this->latitude->HrefValue = "";
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if ($this->city->Required) {
            if (!$this->city->IsDetailKey && EmptyValue($this->city->FormValue)) {
                $this->city->addErrorMessage(str_replace("%s", $this->city->caption(), $this->city->RequiredErrorMessage));
            }
        }
        if ($this->uf->Required) {
            if (!$this->uf->IsDetailKey && EmptyValue($this->uf->FormValue)) {
                $this->uf->addErrorMessage(str_replace("%s", $this->uf->caption(), $this->uf->RequiredErrorMessage));
            }
        }
        if ($this->ufId->Required) {
            if (!$this->ufId->IsDetailKey && EmptyValue($this->ufId->FormValue)) {
                $this->ufId->addErrorMessage(str_replace("%s", $this->ufId->caption(), $this->ufId->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->ufId->FormValue)) {
            $this->ufId->addErrorMessage($this->ufId->getErrorMessage(false));
        }
        if ($this->county->Required) {
            if (!$this->county->IsDetailKey && EmptyValue($this->county->FormValue)) {
                $this->county->addErrorMessage(str_replace("%s", $this->county->caption(), $this->county->RequiredErrorMessage));
            }
        }
        if ($this->longitude->Required) {
            if (!$this->longitude->IsDetailKey && EmptyValue($this->longitude->FormValue)) {
                $this->longitude->addErrorMessage(str_replace("%s", $this->longitude->caption(), $this->longitude->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->longitude->FormValue)) {
            $this->longitude->addErrorMessage($this->longitude->getErrorMessage(false));
        }
        if ($this->latitude->Required) {
            if (!$this->latitude->IsDetailKey && EmptyValue($this->latitude->FormValue)) {
                $this->latitude->addErrorMessage(str_replace("%s", $this->latitude->caption(), $this->latitude->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->latitude->FormValue)) {
            $this->latitude->addErrorMessage($this->latitude->getErrorMessage(false));
        }

        // Return validate result
        $validateForm = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("ConfCityList"), "", $this->TableVar, true);
        $pageId = "addopt";
        $Breadcrumb->add("addopt", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_uf":
                    break;
                case "x_ufId":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll(\PDO::FETCH_BOTH);
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row);
                    $ar[strval($row[0])] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }
}
