<?php

namespace PHPMaker2021\school;

use Doctrine\DBAL\ParameterType;

/**
 * Page class
 */
class FedSchoolAdd extends FedSchool
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Table name
    public $TableName = 'fed_school';

    // Page object name
    public $PageObjName = "FedSchoolAdd";

    // Rendering View
    public $RenderingView = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl()
    {
        $url = ScriptName() . "?";
        if ($this->UseTokenInUrl) {
            $url .= "t=" . $this->TableVar . "&"; // Add page token
        }
        return $url;
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Validate page request
    protected function isPageRequest()
    {
        global $CurrentForm;
        if ($this->UseTokenInUrl) {
            if ($CurrentForm) {
                return ($this->TableVar == $CurrentForm->getValue("t"));
            }
            if (Get("t") !== null) {
                return ($this->TableVar == Get("t"));
            }
        }
        return true;
    }

    // Constructor
    public function __construct()
    {
        global $Language, $DashboardReport, $DebugTimer;
        global $UserTable;

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Parent constuctor
        parent::__construct();

        // Table object (fed_school)
        if (!isset($GLOBALS["fed_school"]) || get_class($GLOBALS["fed_school"]) == PROJECT_NAMESPACE . "fed_school") {
            $GLOBALS["fed_school"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl();

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'fed_school');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] = $GLOBALS["Conn"] ?? $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents($stream = null): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $ExportFileName, $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

         // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();

        // Export
        if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
            $content = $this->getContents();
            if ($ExportFileName == "") {
                $ExportFileName = $this->TableVar;
            }
            $class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
            if (class_exists($class)) {
                $doc = new $class(Container("fed_school"));
                $doc->Text = @$content;
                if ($this->isExport("email")) {
                    echo $this->exportEmail($doc->Text);
                } else {
                    $doc->export();
                }
                DeleteTempImages(); // Delete temp images
                return;
            }
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show error
                WriteJson(array_merge(["success" => false], $this->getMessages()));
            }
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $row = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page
                    $row["caption"] = $this->getModalCaption($pageName);
                    if ($pageName == "FedSchoolView") {
                        $row["view"] = "1";
                    }
                } else { // List page should not be shown as modal => error
                    $row["error"] = $this->getFailureMessage();
                    $this->clearFailureMessage();
                }
                WriteJson($row);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup()
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;

        // Get lookup parameters
        $lookupType = Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal")) {
            $searchValue = Post("sv", "");
            $pageSize = Post("recperpage", 10);
            $offset = Post("start", 0);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = Param("q", "");
            $pageSize = Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
            $start = Param("start", -1);
            $start = is_numeric($start) ? (int)$start : -1;
            $page = Param("page", -1);
            $page = is_numeric($page) ? (int)$page : -1;
            $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        }
        $userSelect = Decrypt(Post("s", ""));
        $userFilter = Decrypt(Post("f", ""));
        $userOrderBy = Decrypt(Post("o", ""));
        $keys = Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        $lookup->toJson($this); // Use settings from current page
    }
    public $FormClassName = "ew-horizontal ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $OldRecordset;
    public $CopyRecord;
    public $DetailPages; // Detail pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
            $SkipHeaderFooter;

        // Is modal
        $this->IsModal = Param("modal") == "1";

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->id->Visible = false;
        $this->federationId->setVisibility();
        $this->masterSchoolId->setVisibility();
        $this->school->setVisibility();
        $this->countryId->setVisibility();
        $this->UFId->setVisibility();
        $this->cityId->setVisibility();
        $this->neighborhood->setVisibility();
        $this->address->setVisibility();
        $this->zipcode->setVisibility();
        $this->website->setVisibility();
        $this->_email->setVisibility();
        $this->phone->setVisibility();
        $this->celphone->setVisibility();
        $this->logo->setVisibility();
        $this->openingDate->setVisibility();
        $this->federationRegister->setVisibility();
        $this->createUserId->setVisibility();
        $this->createDate->setVisibility();
        $this->typeId->setVisibility();
        $this->owner->setVisibility();
        $this->identityNumber->setVisibility();
        $this->birthDateOwner->setVisibility();
        $this->ownerCountryId->setVisibility();
        $this->ownerStateId->setVisibility();
        $this->ownCityId->setVisibility();
        $this->ownerTelephone->setVisibility();
        $this->ownerTelephoneWork->setVisibility();
        $this->ownerProfession->setVisibility();
        $this->employer->setVisibility();
        $this->ownerGraduation->setVisibility();
        $this->ownerGraduationLocation->setVisibility();
        $this->ownerGraduationObs->setVisibility();
        $this->ownerMaritalStatus->setVisibility();
        $this->ownerSpouseName->setVisibility();
        $this->ownerSpouseProfession->setVisibility();
        $this->propertySituation->setVisibility();
        $this->numberOfStudentsInBeginnig->setVisibility();
        $this->ownerAbout->setVisibility();
        $this->pdfLicense->setVisibility();
        $this->applicationId->setVisibility();
        $this->isheadquarter->setVisibility();
        $this->hideFieldsForAddEdit();

        // Do not use lookup cache
        $this->setUseLookupCache(false);

        // Set up detail page object
        $this->setupDetailPages();

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->federationId);
        $this->setupLookupOptions($this->masterSchoolId);
        $this->setupLookupOptions($this->countryId);
        $this->setupLookupOptions($this->UFId);
        $this->setupLookupOptions($this->cityId);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $this->FormClassName = "ew-form ew-add-form ew-horizontal";
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action") !== null) {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record / default values
        $loaded = $this->loadOldRecord();

        // Set up master/detail parameters
        // NOTE: must be after loadOldRecord to prevent master key values overwritten
        $this->setupMasterParms();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Set up detail parameters
        $this->setupDetailParms();

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$loaded) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("FedSchoolList"); // No matching record, return to list
                    return;
                }

                // Set up detail parameters
                $this->setupDetailParms();
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($this->OldRecordset)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    if ($this->getCurrentDetailTable() != "") { // Master/detail add
                        $returnUrl = $this->getDetailUrl();
                    } else {
                        $returnUrl = $this->getReturnUrl();
                    }
                    if (GetPageName($returnUrl) == "FedSchoolList") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "FedSchoolView") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }
                    if (IsApi()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values

                    // Set up detail parameters
                    $this->setupDetailParms();
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = ROWTYPE_ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Pass table and field properties to client side
            $this->toClientVar(["tableCaption"], ["caption", "Visible", "Required", "IsInvalid", "Raw"]);

            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->id->CurrentValue = CurrentUserID();
        $this->federationId->CurrentValue = null;
        $this->federationId->OldValue = $this->federationId->CurrentValue;
        $this->masterSchoolId->CurrentValue = null;
        $this->masterSchoolId->OldValue = $this->masterSchoolId->CurrentValue;
        $this->school->CurrentValue = null;
        $this->school->OldValue = $this->school->CurrentValue;
        $this->countryId->CurrentValue = null;
        $this->countryId->OldValue = $this->countryId->CurrentValue;
        $this->UFId->CurrentValue = null;
        $this->UFId->OldValue = $this->UFId->CurrentValue;
        $this->cityId->CurrentValue = null;
        $this->cityId->OldValue = $this->cityId->CurrentValue;
        $this->neighborhood->CurrentValue = null;
        $this->neighborhood->OldValue = $this->neighborhood->CurrentValue;
        $this->address->CurrentValue = null;
        $this->address->OldValue = $this->address->CurrentValue;
        $this->zipcode->CurrentValue = null;
        $this->zipcode->OldValue = $this->zipcode->CurrentValue;
        $this->website->CurrentValue = null;
        $this->website->OldValue = $this->website->CurrentValue;
        $this->_email->CurrentValue = null;
        $this->_email->OldValue = $this->_email->CurrentValue;
        $this->phone->CurrentValue = null;
        $this->phone->OldValue = $this->phone->CurrentValue;
        $this->celphone->CurrentValue = null;
        $this->celphone->OldValue = $this->celphone->CurrentValue;
        $this->logo->CurrentValue = null;
        $this->logo->OldValue = $this->logo->CurrentValue;
        $this->openingDate->CurrentValue = null;
        $this->openingDate->OldValue = $this->openingDate->CurrentValue;
        $this->federationRegister->CurrentValue = null;
        $this->federationRegister->OldValue = $this->federationRegister->CurrentValue;
        $this->createUserId->CurrentValue = null;
        $this->createUserId->OldValue = $this->createUserId->CurrentValue;
        $this->createDate->CurrentValue = null;
        $this->createDate->OldValue = $this->createDate->CurrentValue;
        $this->typeId->CurrentValue = null;
        $this->typeId->OldValue = $this->typeId->CurrentValue;
        $this->owner->CurrentValue = null;
        $this->owner->OldValue = $this->owner->CurrentValue;
        $this->identityNumber->CurrentValue = null;
        $this->identityNumber->OldValue = $this->identityNumber->CurrentValue;
        $this->birthDateOwner->CurrentValue = null;
        $this->birthDateOwner->OldValue = $this->birthDateOwner->CurrentValue;
        $this->ownerCountryId->CurrentValue = null;
        $this->ownerCountryId->OldValue = $this->ownerCountryId->CurrentValue;
        $this->ownerStateId->CurrentValue = null;
        $this->ownerStateId->OldValue = $this->ownerStateId->CurrentValue;
        $this->ownCityId->CurrentValue = null;
        $this->ownCityId->OldValue = $this->ownCityId->CurrentValue;
        $this->ownerTelephone->CurrentValue = null;
        $this->ownerTelephone->OldValue = $this->ownerTelephone->CurrentValue;
        $this->ownerTelephoneWork->CurrentValue = null;
        $this->ownerTelephoneWork->OldValue = $this->ownerTelephoneWork->CurrentValue;
        $this->ownerProfession->CurrentValue = null;
        $this->ownerProfession->OldValue = $this->ownerProfession->CurrentValue;
        $this->employer->CurrentValue = null;
        $this->employer->OldValue = $this->employer->CurrentValue;
        $this->ownerGraduation->CurrentValue = null;
        $this->ownerGraduation->OldValue = $this->ownerGraduation->CurrentValue;
        $this->ownerGraduationLocation->CurrentValue = null;
        $this->ownerGraduationLocation->OldValue = $this->ownerGraduationLocation->CurrentValue;
        $this->ownerGraduationObs->CurrentValue = null;
        $this->ownerGraduationObs->OldValue = $this->ownerGraduationObs->CurrentValue;
        $this->ownerMaritalStatus->CurrentValue = null;
        $this->ownerMaritalStatus->OldValue = $this->ownerMaritalStatus->CurrentValue;
        $this->ownerSpouseName->CurrentValue = null;
        $this->ownerSpouseName->OldValue = $this->ownerSpouseName->CurrentValue;
        $this->ownerSpouseProfession->CurrentValue = null;
        $this->ownerSpouseProfession->OldValue = $this->ownerSpouseProfession->CurrentValue;
        $this->propertySituation->CurrentValue = null;
        $this->propertySituation->OldValue = $this->propertySituation->CurrentValue;
        $this->numberOfStudentsInBeginnig->CurrentValue = null;
        $this->numberOfStudentsInBeginnig->OldValue = $this->numberOfStudentsInBeginnig->CurrentValue;
        $this->ownerAbout->CurrentValue = null;
        $this->ownerAbout->OldValue = $this->ownerAbout->CurrentValue;
        $this->pdfLicense->CurrentValue = null;
        $this->pdfLicense->OldValue = $this->pdfLicense->CurrentValue;
        $this->applicationId->CurrentValue = null;
        $this->applicationId->OldValue = $this->applicationId->CurrentValue;
        $this->isheadquarter->CurrentValue = null;
        $this->isheadquarter->OldValue = $this->isheadquarter->CurrentValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;

        // Check field name 'federationId' first before field var 'x_federationId'
        $val = $CurrentForm->hasValue("federationId") ? $CurrentForm->getValue("federationId") : $CurrentForm->getValue("x_federationId");
        if (!$this->federationId->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->federationId->Visible = false; // Disable update for API request
            } else {
                $this->federationId->setFormValue($val);
            }
        }

        // Check field name 'masterSchoolId' first before field var 'x_masterSchoolId'
        $val = $CurrentForm->hasValue("masterSchoolId") ? $CurrentForm->getValue("masterSchoolId") : $CurrentForm->getValue("x_masterSchoolId");
        if (!$this->masterSchoolId->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->masterSchoolId->Visible = false; // Disable update for API request
            } else {
                $this->masterSchoolId->setFormValue($val);
            }
        }

        // Check field name 'school' first before field var 'x_school'
        $val = $CurrentForm->hasValue("school") ? $CurrentForm->getValue("school") : $CurrentForm->getValue("x_school");
        if (!$this->school->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->school->Visible = false; // Disable update for API request
            } else {
                $this->school->setFormValue($val);
            }
        }

        // Check field name 'countryId' first before field var 'x_countryId'
        $val = $CurrentForm->hasValue("countryId") ? $CurrentForm->getValue("countryId") : $CurrentForm->getValue("x_countryId");
        if (!$this->countryId->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->countryId->Visible = false; // Disable update for API request
            } else {
                $this->countryId->setFormValue($val);
            }
        }

        // Check field name 'UFId' first before field var 'x_UFId'
        $val = $CurrentForm->hasValue("UFId") ? $CurrentForm->getValue("UFId") : $CurrentForm->getValue("x_UFId");
        if (!$this->UFId->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->UFId->Visible = false; // Disable update for API request
            } else {
                $this->UFId->setFormValue($val);
            }
        }

        // Check field name 'cityId' first before field var 'x_cityId'
        $val = $CurrentForm->hasValue("cityId") ? $CurrentForm->getValue("cityId") : $CurrentForm->getValue("x_cityId");
        if (!$this->cityId->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cityId->Visible = false; // Disable update for API request
            } else {
                $this->cityId->setFormValue($val);
            }
        }

        // Check field name 'neighborhood' first before field var 'x_neighborhood'
        $val = $CurrentForm->hasValue("neighborhood") ? $CurrentForm->getValue("neighborhood") : $CurrentForm->getValue("x_neighborhood");
        if (!$this->neighborhood->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->neighborhood->Visible = false; // Disable update for API request
            } else {
                $this->neighborhood->setFormValue($val);
            }
        }

        // Check field name 'address' first before field var 'x_address'
        $val = $CurrentForm->hasValue("address") ? $CurrentForm->getValue("address") : $CurrentForm->getValue("x_address");
        if (!$this->address->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->address->Visible = false; // Disable update for API request
            } else {
                $this->address->setFormValue($val);
            }
        }

        // Check field name 'zipcode' first before field var 'x_zipcode'
        $val = $CurrentForm->hasValue("zipcode") ? $CurrentForm->getValue("zipcode") : $CurrentForm->getValue("x_zipcode");
        if (!$this->zipcode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->zipcode->Visible = false; // Disable update for API request
            } else {
                $this->zipcode->setFormValue($val);
            }
        }

        // Check field name 'website' first before field var 'x_website'
        $val = $CurrentForm->hasValue("website") ? $CurrentForm->getValue("website") : $CurrentForm->getValue("x_website");
        if (!$this->website->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->website->Visible = false; // Disable update for API request
            } else {
                $this->website->setFormValue($val);
            }
        }

        // Check field name 'email' first before field var 'x__email'
        $val = $CurrentForm->hasValue("email") ? $CurrentForm->getValue("email") : $CurrentForm->getValue("x__email");
        if (!$this->_email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_email->Visible = false; // Disable update for API request
            } else {
                $this->_email->setFormValue($val);
            }
        }

        // Check field name 'phone' first before field var 'x_phone'
        $val = $CurrentForm->hasValue("phone") ? $CurrentForm->getValue("phone") : $CurrentForm->getValue("x_phone");
        if (!$this->phone->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->phone->Visible = false; // Disable update for API request
            } else {
                $this->phone->setFormValue($val);
            }
        }

        // Check field name 'celphone' first before field var 'x_celphone'
        $val = $CurrentForm->hasValue("celphone") ? $CurrentForm->getValue("celphone") : $CurrentForm->getValue("x_celphone");
        if (!$this->celphone->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->celphone->Visible = false; // Disable update for API request
            } else {
                $this->celphone->setFormValue($val);
            }
        }

        // Check field name 'logo' first before field var 'x_logo'
        $val = $CurrentForm->hasValue("logo") ? $CurrentForm->getValue("logo") : $CurrentForm->getValue("x_logo");
        if (!$this->logo->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->logo->Visible = false; // Disable update for API request
            } else {
                $this->logo->setFormValue($val);
            }
        }

        // Check field name 'openingDate' first before field var 'x_openingDate'
        $val = $CurrentForm->hasValue("openingDate") ? $CurrentForm->getValue("openingDate") : $CurrentForm->getValue("x_openingDate");
        if (!$this->openingDate->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->openingDate->Visible = false; // Disable update for API request
            } else {
                $this->openingDate->setFormValue($val);
            }
            $this->openingDate->CurrentValue = UnFormatDateTime($this->openingDate->CurrentValue, 0);
        }

        // Check field name 'federationRegister' first before field var 'x_federationRegister'
        $val = $CurrentForm->hasValue("federationRegister") ? $CurrentForm->getValue("federationRegister") : $CurrentForm->getValue("x_federationRegister");
        if (!$this->federationRegister->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->federationRegister->Visible = false; // Disable update for API request
            } else {
                $this->federationRegister->setFormValue($val);
            }
        }

        // Check field name 'createUserId' first before field var 'x_createUserId'
        $val = $CurrentForm->hasValue("createUserId") ? $CurrentForm->getValue("createUserId") : $CurrentForm->getValue("x_createUserId");
        if (!$this->createUserId->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->createUserId->Visible = false; // Disable update for API request
            } else {
                $this->createUserId->setFormValue($val);
            }
        }

        // Check field name 'createDate' first before field var 'x_createDate'
        $val = $CurrentForm->hasValue("createDate") ? $CurrentForm->getValue("createDate") : $CurrentForm->getValue("x_createDate");
        if (!$this->createDate->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->createDate->Visible = false; // Disable update for API request
            } else {
                $this->createDate->setFormValue($val);
            }
            $this->createDate->CurrentValue = UnFormatDateTime($this->createDate->CurrentValue, 0);
        }

        // Check field name 'typeId' first before field var 'x_typeId'
        $val = $CurrentForm->hasValue("typeId") ? $CurrentForm->getValue("typeId") : $CurrentForm->getValue("x_typeId");
        if (!$this->typeId->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->typeId->Visible = false; // Disable update for API request
            } else {
                $this->typeId->setFormValue($val);
            }
        }

        // Check field name 'owner' first before field var 'x_owner'
        $val = $CurrentForm->hasValue("owner") ? $CurrentForm->getValue("owner") : $CurrentForm->getValue("x_owner");
        if (!$this->owner->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->owner->Visible = false; // Disable update for API request
            } else {
                $this->owner->setFormValue($val);
            }
        }

        // Check field name 'identityNumber' first before field var 'x_identityNumber'
        $val = $CurrentForm->hasValue("identityNumber") ? $CurrentForm->getValue("identityNumber") : $CurrentForm->getValue("x_identityNumber");
        if (!$this->identityNumber->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->identityNumber->Visible = false; // Disable update for API request
            } else {
                $this->identityNumber->setFormValue($val);
            }
        }

        // Check field name 'birthDateOwner' first before field var 'x_birthDateOwner'
        $val = $CurrentForm->hasValue("birthDateOwner") ? $CurrentForm->getValue("birthDateOwner") : $CurrentForm->getValue("x_birthDateOwner");
        if (!$this->birthDateOwner->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->birthDateOwner->Visible = false; // Disable update for API request
            } else {
                $this->birthDateOwner->setFormValue($val);
            }
            $this->birthDateOwner->CurrentValue = UnFormatDateTime($this->birthDateOwner->CurrentValue, 0);
        }

        // Check field name 'ownerCountryId' first before field var 'x_ownerCountryId'
        $val = $CurrentForm->hasValue("ownerCountryId") ? $CurrentForm->getValue("ownerCountryId") : $CurrentForm->getValue("x_ownerCountryId");
        if (!$this->ownerCountryId->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ownerCountryId->Visible = false; // Disable update for API request
            } else {
                $this->ownerCountryId->setFormValue($val);
            }
        }

        // Check field name 'ownerStateId' first before field var 'x_ownerStateId'
        $val = $CurrentForm->hasValue("ownerStateId") ? $CurrentForm->getValue("ownerStateId") : $CurrentForm->getValue("x_ownerStateId");
        if (!$this->ownerStateId->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ownerStateId->Visible = false; // Disable update for API request
            } else {
                $this->ownerStateId->setFormValue($val);
            }
        }

        // Check field name 'ownCityId' first before field var 'x_ownCityId'
        $val = $CurrentForm->hasValue("ownCityId") ? $CurrentForm->getValue("ownCityId") : $CurrentForm->getValue("x_ownCityId");
        if (!$this->ownCityId->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ownCityId->Visible = false; // Disable update for API request
            } else {
                $this->ownCityId->setFormValue($val);
            }
        }

        // Check field name 'ownerTelephone' first before field var 'x_ownerTelephone'
        $val = $CurrentForm->hasValue("ownerTelephone") ? $CurrentForm->getValue("ownerTelephone") : $CurrentForm->getValue("x_ownerTelephone");
        if (!$this->ownerTelephone->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ownerTelephone->Visible = false; // Disable update for API request
            } else {
                $this->ownerTelephone->setFormValue($val);
            }
        }

        // Check field name 'ownerTelephoneWork' first before field var 'x_ownerTelephoneWork'
        $val = $CurrentForm->hasValue("ownerTelephoneWork") ? $CurrentForm->getValue("ownerTelephoneWork") : $CurrentForm->getValue("x_ownerTelephoneWork");
        if (!$this->ownerTelephoneWork->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ownerTelephoneWork->Visible = false; // Disable update for API request
            } else {
                $this->ownerTelephoneWork->setFormValue($val);
            }
        }

        // Check field name 'ownerProfession' first before field var 'x_ownerProfession'
        $val = $CurrentForm->hasValue("ownerProfession") ? $CurrentForm->getValue("ownerProfession") : $CurrentForm->getValue("x_ownerProfession");
        if (!$this->ownerProfession->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ownerProfession->Visible = false; // Disable update for API request
            } else {
                $this->ownerProfession->setFormValue($val);
            }
        }

        // Check field name 'employer' first before field var 'x_employer'
        $val = $CurrentForm->hasValue("employer") ? $CurrentForm->getValue("employer") : $CurrentForm->getValue("x_employer");
        if (!$this->employer->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->employer->Visible = false; // Disable update for API request
            } else {
                $this->employer->setFormValue($val);
            }
        }

        // Check field name 'ownerGraduation' first before field var 'x_ownerGraduation'
        $val = $CurrentForm->hasValue("ownerGraduation") ? $CurrentForm->getValue("ownerGraduation") : $CurrentForm->getValue("x_ownerGraduation");
        if (!$this->ownerGraduation->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ownerGraduation->Visible = false; // Disable update for API request
            } else {
                $this->ownerGraduation->setFormValue($val);
            }
        }

        // Check field name 'ownerGraduationLocation' first before field var 'x_ownerGraduationLocation'
        $val = $CurrentForm->hasValue("ownerGraduationLocation") ? $CurrentForm->getValue("ownerGraduationLocation") : $CurrentForm->getValue("x_ownerGraduationLocation");
        if (!$this->ownerGraduationLocation->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ownerGraduationLocation->Visible = false; // Disable update for API request
            } else {
                $this->ownerGraduationLocation->setFormValue($val);
            }
        }

        // Check field name 'ownerGraduationObs' first before field var 'x_ownerGraduationObs'
        $val = $CurrentForm->hasValue("ownerGraduationObs") ? $CurrentForm->getValue("ownerGraduationObs") : $CurrentForm->getValue("x_ownerGraduationObs");
        if (!$this->ownerGraduationObs->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ownerGraduationObs->Visible = false; // Disable update for API request
            } else {
                $this->ownerGraduationObs->setFormValue($val);
            }
        }

        // Check field name 'ownerMaritalStatus' first before field var 'x_ownerMaritalStatus'
        $val = $CurrentForm->hasValue("ownerMaritalStatus") ? $CurrentForm->getValue("ownerMaritalStatus") : $CurrentForm->getValue("x_ownerMaritalStatus");
        if (!$this->ownerMaritalStatus->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ownerMaritalStatus->Visible = false; // Disable update for API request
            } else {
                $this->ownerMaritalStatus->setFormValue($val);
            }
        }

        // Check field name 'ownerSpouseName' first before field var 'x_ownerSpouseName'
        $val = $CurrentForm->hasValue("ownerSpouseName") ? $CurrentForm->getValue("ownerSpouseName") : $CurrentForm->getValue("x_ownerSpouseName");
        if (!$this->ownerSpouseName->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ownerSpouseName->Visible = false; // Disable update for API request
            } else {
                $this->ownerSpouseName->setFormValue($val);
            }
        }

        // Check field name 'ownerSpouseProfession' first before field var 'x_ownerSpouseProfession'
        $val = $CurrentForm->hasValue("ownerSpouseProfession") ? $CurrentForm->getValue("ownerSpouseProfession") : $CurrentForm->getValue("x_ownerSpouseProfession");
        if (!$this->ownerSpouseProfession->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ownerSpouseProfession->Visible = false; // Disable update for API request
            } else {
                $this->ownerSpouseProfession->setFormValue($val);
            }
        }

        // Check field name 'propertySituation' first before field var 'x_propertySituation'
        $val = $CurrentForm->hasValue("propertySituation") ? $CurrentForm->getValue("propertySituation") : $CurrentForm->getValue("x_propertySituation");
        if (!$this->propertySituation->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->propertySituation->Visible = false; // Disable update for API request
            } else {
                $this->propertySituation->setFormValue($val);
            }
        }

        // Check field name 'numberOfStudentsInBeginnig' first before field var 'x_numberOfStudentsInBeginnig'
        $val = $CurrentForm->hasValue("numberOfStudentsInBeginnig") ? $CurrentForm->getValue("numberOfStudentsInBeginnig") : $CurrentForm->getValue("x_numberOfStudentsInBeginnig");
        if (!$this->numberOfStudentsInBeginnig->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->numberOfStudentsInBeginnig->Visible = false; // Disable update for API request
            } else {
                $this->numberOfStudentsInBeginnig->setFormValue($val);
            }
        }

        // Check field name 'ownerAbout' first before field var 'x_ownerAbout'
        $val = $CurrentForm->hasValue("ownerAbout") ? $CurrentForm->getValue("ownerAbout") : $CurrentForm->getValue("x_ownerAbout");
        if (!$this->ownerAbout->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ownerAbout->Visible = false; // Disable update for API request
            } else {
                $this->ownerAbout->setFormValue($val);
            }
        }

        // Check field name 'pdfLicense' first before field var 'x_pdfLicense'
        $val = $CurrentForm->hasValue("pdfLicense") ? $CurrentForm->getValue("pdfLicense") : $CurrentForm->getValue("x_pdfLicense");
        if (!$this->pdfLicense->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pdfLicense->Visible = false; // Disable update for API request
            } else {
                $this->pdfLicense->setFormValue($val);
            }
        }

        // Check field name 'applicationId' first before field var 'x_applicationId'
        $val = $CurrentForm->hasValue("applicationId") ? $CurrentForm->getValue("applicationId") : $CurrentForm->getValue("x_applicationId");
        if (!$this->applicationId->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->applicationId->Visible = false; // Disable update for API request
            } else {
                $this->applicationId->setFormValue($val);
            }
        }

        // Check field name 'isheadquarter' first before field var 'x_isheadquarter'
        $val = $CurrentForm->hasValue("isheadquarter") ? $CurrentForm->getValue("isheadquarter") : $CurrentForm->getValue("x_isheadquarter");
        if (!$this->isheadquarter->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->isheadquarter->Visible = false; // Disable update for API request
            } else {
                $this->isheadquarter->setFormValue($val);
            }
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->federationId->CurrentValue = $this->federationId->FormValue;
        $this->masterSchoolId->CurrentValue = $this->masterSchoolId->FormValue;
        $this->school->CurrentValue = $this->school->FormValue;
        $this->countryId->CurrentValue = $this->countryId->FormValue;
        $this->UFId->CurrentValue = $this->UFId->FormValue;
        $this->cityId->CurrentValue = $this->cityId->FormValue;
        $this->neighborhood->CurrentValue = $this->neighborhood->FormValue;
        $this->address->CurrentValue = $this->address->FormValue;
        $this->zipcode->CurrentValue = $this->zipcode->FormValue;
        $this->website->CurrentValue = $this->website->FormValue;
        $this->_email->CurrentValue = $this->_email->FormValue;
        $this->phone->CurrentValue = $this->phone->FormValue;
        $this->celphone->CurrentValue = $this->celphone->FormValue;
        $this->logo->CurrentValue = $this->logo->FormValue;
        $this->openingDate->CurrentValue = $this->openingDate->FormValue;
        $this->openingDate->CurrentValue = UnFormatDateTime($this->openingDate->CurrentValue, 0);
        $this->federationRegister->CurrentValue = $this->federationRegister->FormValue;
        $this->createUserId->CurrentValue = $this->createUserId->FormValue;
        $this->createDate->CurrentValue = $this->createDate->FormValue;
        $this->createDate->CurrentValue = UnFormatDateTime($this->createDate->CurrentValue, 0);
        $this->typeId->CurrentValue = $this->typeId->FormValue;
        $this->owner->CurrentValue = $this->owner->FormValue;
        $this->identityNumber->CurrentValue = $this->identityNumber->FormValue;
        $this->birthDateOwner->CurrentValue = $this->birthDateOwner->FormValue;
        $this->birthDateOwner->CurrentValue = UnFormatDateTime($this->birthDateOwner->CurrentValue, 0);
        $this->ownerCountryId->CurrentValue = $this->ownerCountryId->FormValue;
        $this->ownerStateId->CurrentValue = $this->ownerStateId->FormValue;
        $this->ownCityId->CurrentValue = $this->ownCityId->FormValue;
        $this->ownerTelephone->CurrentValue = $this->ownerTelephone->FormValue;
        $this->ownerTelephoneWork->CurrentValue = $this->ownerTelephoneWork->FormValue;
        $this->ownerProfession->CurrentValue = $this->ownerProfession->FormValue;
        $this->employer->CurrentValue = $this->employer->FormValue;
        $this->ownerGraduation->CurrentValue = $this->ownerGraduation->FormValue;
        $this->ownerGraduationLocation->CurrentValue = $this->ownerGraduationLocation->FormValue;
        $this->ownerGraduationObs->CurrentValue = $this->ownerGraduationObs->FormValue;
        $this->ownerMaritalStatus->CurrentValue = $this->ownerMaritalStatus->FormValue;
        $this->ownerSpouseName->CurrentValue = $this->ownerSpouseName->FormValue;
        $this->ownerSpouseProfession->CurrentValue = $this->ownerSpouseProfession->FormValue;
        $this->propertySituation->CurrentValue = $this->propertySituation->FormValue;
        $this->numberOfStudentsInBeginnig->CurrentValue = $this->numberOfStudentsInBeginnig->FormValue;
        $this->ownerAbout->CurrentValue = $this->ownerAbout->FormValue;
        $this->pdfLicense->CurrentValue = $this->pdfLicense->FormValue;
        $this->applicationId->CurrentValue = $this->applicationId->FormValue;
        $this->isheadquarter->CurrentValue = $this->isheadquarter->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssoc($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }

        // Check if valid User ID
        if ($res) {
            $res = $this->showOptionLink("add");
            if (!$res) {
                $userIdMsg = DeniedMessage();
                $this->setFailureMessage($userIdMsg);
            }
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }

        // Call Row Selected event
        $this->rowSelected($row);
        if (!$rs) {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->federationId->setDbValue($row['federationId']);
        $this->masterSchoolId->setDbValue($row['masterSchoolId']);
        $this->school->setDbValue($row['school']);
        $this->countryId->setDbValue($row['countryId']);
        $this->UFId->setDbValue($row['UFId']);
        $this->cityId->setDbValue($row['cityId']);
        if (array_key_exists('EV__cityId', $row)) {
            $this->cityId->VirtualValue = $row['EV__cityId']; // Set up virtual field value
        } else {
            $this->cityId->VirtualValue = ""; // Clear value
        }
        $this->neighborhood->setDbValue($row['neighborhood']);
        $this->address->setDbValue($row['address']);
        $this->zipcode->setDbValue($row['zipcode']);
        $this->website->setDbValue($row['website']);
        $this->_email->setDbValue($row['email']);
        $this->phone->setDbValue($row['phone']);
        $this->celphone->setDbValue($row['celphone']);
        $this->logo->setDbValue($row['logo']);
        $this->openingDate->setDbValue($row['openingDate']);
        $this->federationRegister->setDbValue($row['federationRegister']);
        $this->createUserId->setDbValue($row['createUserId']);
        $this->createDate->setDbValue($row['createDate']);
        $this->typeId->setDbValue($row['typeId']);
        $this->owner->setDbValue($row['owner']);
        $this->identityNumber->setDbValue($row['identityNumber']);
        $this->birthDateOwner->setDbValue($row['birthDateOwner']);
        $this->ownerCountryId->setDbValue($row['ownerCountryId']);
        $this->ownerStateId->setDbValue($row['ownerStateId']);
        $this->ownCityId->setDbValue($row['ownCityId']);
        $this->ownerTelephone->setDbValue($row['ownerTelephone']);
        $this->ownerTelephoneWork->setDbValue($row['ownerTelephoneWork']);
        $this->ownerProfession->setDbValue($row['ownerProfession']);
        $this->employer->setDbValue($row['employer']);
        $this->ownerGraduation->setDbValue($row['ownerGraduation']);
        $this->ownerGraduationLocation->setDbValue($row['ownerGraduationLocation']);
        $this->ownerGraduationObs->setDbValue($row['ownerGraduationObs']);
        $this->ownerMaritalStatus->setDbValue($row['ownerMaritalStatus']);
        $this->ownerSpouseName->setDbValue($row['ownerSpouseName']);
        $this->ownerSpouseProfession->setDbValue($row['ownerSpouseProfession']);
        $this->propertySituation->setDbValue($row['propertySituation']);
        $this->numberOfStudentsInBeginnig->setDbValue($row['numberOfStudentsInBeginnig']);
        $this->ownerAbout->setDbValue($row['ownerAbout']);
        $this->pdfLicense->setDbValue($row['pdfLicense']);
        $this->applicationId->setDbValue($row['applicationId']);
        $this->isheadquarter->setDbValue($row['isheadquarter']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $this->loadDefaultValues();
        $row = [];
        $row['id'] = $this->id->CurrentValue;
        $row['federationId'] = $this->federationId->CurrentValue;
        $row['masterSchoolId'] = $this->masterSchoolId->CurrentValue;
        $row['school'] = $this->school->CurrentValue;
        $row['countryId'] = $this->countryId->CurrentValue;
        $row['UFId'] = $this->UFId->CurrentValue;
        $row['cityId'] = $this->cityId->CurrentValue;
        $row['neighborhood'] = $this->neighborhood->CurrentValue;
        $row['address'] = $this->address->CurrentValue;
        $row['zipcode'] = $this->zipcode->CurrentValue;
        $row['website'] = $this->website->CurrentValue;
        $row['email'] = $this->_email->CurrentValue;
        $row['phone'] = $this->phone->CurrentValue;
        $row['celphone'] = $this->celphone->CurrentValue;
        $row['logo'] = $this->logo->CurrentValue;
        $row['openingDate'] = $this->openingDate->CurrentValue;
        $row['federationRegister'] = $this->federationRegister->CurrentValue;
        $row['createUserId'] = $this->createUserId->CurrentValue;
        $row['createDate'] = $this->createDate->CurrentValue;
        $row['typeId'] = $this->typeId->CurrentValue;
        $row['owner'] = $this->owner->CurrentValue;
        $row['identityNumber'] = $this->identityNumber->CurrentValue;
        $row['birthDateOwner'] = $this->birthDateOwner->CurrentValue;
        $row['ownerCountryId'] = $this->ownerCountryId->CurrentValue;
        $row['ownerStateId'] = $this->ownerStateId->CurrentValue;
        $row['ownCityId'] = $this->ownCityId->CurrentValue;
        $row['ownerTelephone'] = $this->ownerTelephone->CurrentValue;
        $row['ownerTelephoneWork'] = $this->ownerTelephoneWork->CurrentValue;
        $row['ownerProfession'] = $this->ownerProfession->CurrentValue;
        $row['employer'] = $this->employer->CurrentValue;
        $row['ownerGraduation'] = $this->ownerGraduation->CurrentValue;
        $row['ownerGraduationLocation'] = $this->ownerGraduationLocation->CurrentValue;
        $row['ownerGraduationObs'] = $this->ownerGraduationObs->CurrentValue;
        $row['ownerMaritalStatus'] = $this->ownerMaritalStatus->CurrentValue;
        $row['ownerSpouseName'] = $this->ownerSpouseName->CurrentValue;
        $row['ownerSpouseProfession'] = $this->ownerSpouseProfession->CurrentValue;
        $row['propertySituation'] = $this->propertySituation->CurrentValue;
        $row['numberOfStudentsInBeginnig'] = $this->numberOfStudentsInBeginnig->CurrentValue;
        $row['ownerAbout'] = $this->ownerAbout->CurrentValue;
        $row['pdfLicense'] = $this->pdfLicense->CurrentValue;
        $row['applicationId'] = $this->applicationId->CurrentValue;
        $row['isheadquarter'] = $this->isheadquarter->CurrentValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        $this->OldRecordset = null;
        $validKey = $this->OldKey != "";
        if ($validKey) {
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $this->OldRecordset = LoadRecordset($sql, $conn);
        }
        $this->loadRowValues($this->OldRecordset); // Load row values
        return $validKey;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // federationId

        // masterSchoolId

        // school

        // countryId

        // UFId

        // cityId

        // neighborhood

        // address

        // zipcode

        // website

        // email

        // phone

        // celphone

        // logo

        // openingDate

        // federationRegister

        // createUserId

        // createDate

        // typeId

        // owner

        // identityNumber

        // birthDateOwner

        // ownerCountryId

        // ownerStateId

        // ownCityId

        // ownerTelephone

        // ownerTelephoneWork

        // ownerProfession

        // employer

        // ownerGraduation

        // ownerGraduationLocation

        // ownerGraduationObs

        // ownerMaritalStatus

        // ownerSpouseName

        // ownerSpouseProfession

        // propertySituation

        // numberOfStudentsInBeginnig

        // ownerAbout

        // pdfLicense

        // applicationId

        // isheadquarter
        if ($this->RowType == ROWTYPE_VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewCustomAttributes = "";

            // federationId
            $curVal = trim(strval($this->federationId->CurrentValue));
            if ($curVal != "") {
                $this->federationId->ViewValue = $this->federationId->lookupCacheOption($curVal);
                if ($this->federationId->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->federationId->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->federationId->Lookup->renderViewRow($rswrk[0]);
                        $this->federationId->ViewValue = $this->federationId->displayValue($arwrk);
                    } else {
                        $this->federationId->ViewValue = $this->federationId->CurrentValue;
                    }
                }
            } else {
                $this->federationId->ViewValue = null;
            }
            $this->federationId->ViewCustomAttributes = "";

            // masterSchoolId
            $curVal = trim(strval($this->masterSchoolId->CurrentValue));
            if ($curVal != "") {
                $this->masterSchoolId->ViewValue = $this->masterSchoolId->lookupCacheOption($curVal);
                if ($this->masterSchoolId->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $lookupFilter = function() {
                        return "`typeId`=1";
                    };
                    $lookupFilter = $lookupFilter->bindTo($this);
                    $sqlWrk = $this->masterSchoolId->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->masterSchoolId->Lookup->renderViewRow($rswrk[0]);
                        $this->masterSchoolId->ViewValue = $this->masterSchoolId->displayValue($arwrk);
                    } else {
                        $this->masterSchoolId->ViewValue = $this->masterSchoolId->CurrentValue;
                    }
                }
            } else {
                $this->masterSchoolId->ViewValue = null;
            }
            $this->masterSchoolId->ViewCustomAttributes = "";

            // school
            $this->school->ViewValue = $this->school->CurrentValue;
            $this->school->ViewCustomAttributes = "";

            // countryId
            $curVal = trim(strval($this->countryId->CurrentValue));
            if ($curVal != "") {
                $this->countryId->ViewValue = $this->countryId->lookupCacheOption($curVal);
                if ($this->countryId->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->countryId->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->countryId->Lookup->renderViewRow($rswrk[0]);
                        $this->countryId->ViewValue = $this->countryId->displayValue($arwrk);
                    } else {
                        $this->countryId->ViewValue = $this->countryId->CurrentValue;
                    }
                }
            } else {
                $this->countryId->ViewValue = null;
            }
            $this->countryId->ViewCustomAttributes = "";

            // UFId
            $curVal = trim(strval($this->UFId->CurrentValue));
            if ($curVal != "") {
                $this->UFId->ViewValue = $this->UFId->lookupCacheOption($curVal);
                if ($this->UFId->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->UFId->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->UFId->Lookup->renderViewRow($rswrk[0]);
                        $this->UFId->ViewValue = $this->UFId->displayValue($arwrk);
                    } else {
                        $this->UFId->ViewValue = $this->UFId->CurrentValue;
                    }
                }
            } else {
                $this->UFId->ViewValue = null;
            }
            $this->UFId->ViewCustomAttributes = "";

            // cityId
            if ($this->cityId->VirtualValue != "") {
                $this->cityId->ViewValue = $this->cityId->VirtualValue;
            } else {
                $curVal = trim(strval($this->cityId->CurrentValue));
                if ($curVal != "") {
                    $this->cityId->ViewValue = $this->cityId->lookupCacheOption($curVal);
                    if ($this->cityId->ViewValue === null) { // Lookup from database
                        $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->cityId->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->cityId->Lookup->renderViewRow($rswrk[0]);
                            $this->cityId->ViewValue = $this->cityId->displayValue($arwrk);
                        } else {
                            $this->cityId->ViewValue = $this->cityId->CurrentValue;
                        }
                    }
                } else {
                    $this->cityId->ViewValue = null;
                }
            }
            $this->cityId->ViewCustomAttributes = "";

            // neighborhood
            $this->neighborhood->ViewValue = $this->neighborhood->CurrentValue;
            $this->neighborhood->ViewCustomAttributes = "";

            // address
            $this->address->ViewValue = $this->address->CurrentValue;
            $this->address->ViewCustomAttributes = "";

            // zipcode
            $this->zipcode->ViewValue = $this->zipcode->CurrentValue;
            $this->zipcode->ViewCustomAttributes = "";

            // website
            $this->website->ViewValue = $this->website->CurrentValue;
            $this->website->ViewCustomAttributes = "";

            // email
            $this->_email->ViewValue = $this->_email->CurrentValue;
            $this->_email->ViewCustomAttributes = "";

            // phone
            $this->phone->ViewValue = $this->phone->CurrentValue;
            $this->phone->ViewCustomAttributes = "";

            // celphone
            $this->celphone->ViewValue = $this->celphone->CurrentValue;
            $this->celphone->ViewCustomAttributes = "";

            // logo
            $this->logo->ViewValue = $this->logo->CurrentValue;
            $this->logo->ViewCustomAttributes = "";

            // openingDate
            $this->openingDate->ViewValue = $this->openingDate->CurrentValue;
            $this->openingDate->ViewValue = FormatDateTime($this->openingDate->ViewValue, 0);
            $this->openingDate->ViewCustomAttributes = "";

            // federationRegister
            $this->federationRegister->ViewValue = $this->federationRegister->CurrentValue;
            $this->federationRegister->ViewCustomAttributes = "";

            // createUserId
            $this->createUserId->ViewValue = $this->createUserId->CurrentValue;
            $this->createUserId->ViewValue = FormatNumber($this->createUserId->ViewValue, 0, -2, -2, -2);
            $this->createUserId->ViewCustomAttributes = "";

            // createDate
            $this->createDate->ViewValue = $this->createDate->CurrentValue;
            $this->createDate->ViewValue = FormatDateTime($this->createDate->ViewValue, 0);
            $this->createDate->ViewCustomAttributes = "";

            // typeId
            $this->typeId->ViewValue = $this->typeId->CurrentValue;
            $this->typeId->ViewValue = FormatNumber($this->typeId->ViewValue, 0, -2, -2, -2);
            $this->typeId->ViewCustomAttributes = "";

            // owner
            $this->owner->ViewValue = $this->owner->CurrentValue;
            $this->owner->ViewCustomAttributes = "";

            // identityNumber
            $this->identityNumber->ViewValue = $this->identityNumber->CurrentValue;
            $this->identityNumber->ViewCustomAttributes = "";

            // birthDateOwner
            $this->birthDateOwner->ViewValue = $this->birthDateOwner->CurrentValue;
            $this->birthDateOwner->ViewValue = FormatDateTime($this->birthDateOwner->ViewValue, 0);
            $this->birthDateOwner->ViewCustomAttributes = "";

            // ownerCountryId
            $this->ownerCountryId->ViewValue = $this->ownerCountryId->CurrentValue;
            $this->ownerCountryId->ViewValue = FormatNumber($this->ownerCountryId->ViewValue, 0, -2, -2, -2);
            $this->ownerCountryId->ViewCustomAttributes = "";

            // ownerStateId
            $this->ownerStateId->ViewValue = $this->ownerStateId->CurrentValue;
            $this->ownerStateId->ViewValue = FormatNumber($this->ownerStateId->ViewValue, 0, -2, -2, -2);
            $this->ownerStateId->ViewCustomAttributes = "";

            // ownCityId
            $this->ownCityId->ViewValue = $this->ownCityId->CurrentValue;
            $this->ownCityId->ViewValue = FormatNumber($this->ownCityId->ViewValue, 0, -2, -2, -2);
            $this->ownCityId->ViewCustomAttributes = "";

            // ownerTelephone
            $this->ownerTelephone->ViewValue = $this->ownerTelephone->CurrentValue;
            $this->ownerTelephone->ViewCustomAttributes = "";

            // ownerTelephoneWork
            $this->ownerTelephoneWork->ViewValue = $this->ownerTelephoneWork->CurrentValue;
            $this->ownerTelephoneWork->ViewCustomAttributes = "";

            // ownerProfession
            $this->ownerProfession->ViewValue = $this->ownerProfession->CurrentValue;
            $this->ownerProfession->ViewCustomAttributes = "";

            // employer
            $this->employer->ViewValue = $this->employer->CurrentValue;
            $this->employer->ViewCustomAttributes = "";

            // ownerGraduation
            $this->ownerGraduation->ViewValue = $this->ownerGraduation->CurrentValue;
            $this->ownerGraduation->ViewValue = FormatNumber($this->ownerGraduation->ViewValue, 0, -2, -2, -2);
            $this->ownerGraduation->ViewCustomAttributes = "";

            // ownerGraduationLocation
            $this->ownerGraduationLocation->ViewValue = $this->ownerGraduationLocation->CurrentValue;
            $this->ownerGraduationLocation->ViewCustomAttributes = "";

            // ownerGraduationObs
            $this->ownerGraduationObs->ViewValue = $this->ownerGraduationObs->CurrentValue;
            $this->ownerGraduationObs->ViewCustomAttributes = "";

            // ownerMaritalStatus
            $this->ownerMaritalStatus->ViewValue = $this->ownerMaritalStatus->CurrentValue;
            $this->ownerMaritalStatus->ViewValue = FormatNumber($this->ownerMaritalStatus->ViewValue, 0, -2, -2, -2);
            $this->ownerMaritalStatus->ViewCustomAttributes = "";

            // ownerSpouseName
            $this->ownerSpouseName->ViewValue = $this->ownerSpouseName->CurrentValue;
            $this->ownerSpouseName->ViewCustomAttributes = "";

            // ownerSpouseProfession
            $this->ownerSpouseProfession->ViewValue = $this->ownerSpouseProfession->CurrentValue;
            $this->ownerSpouseProfession->ViewCustomAttributes = "";

            // propertySituation
            $this->propertySituation->ViewValue = $this->propertySituation->CurrentValue;
            $this->propertySituation->ViewValue = FormatNumber($this->propertySituation->ViewValue, 0, -2, -2, -2);
            $this->propertySituation->ViewCustomAttributes = "";

            // numberOfStudentsInBeginnig
            $this->numberOfStudentsInBeginnig->ViewValue = $this->numberOfStudentsInBeginnig->CurrentValue;
            $this->numberOfStudentsInBeginnig->ViewValue = FormatNumber($this->numberOfStudentsInBeginnig->ViewValue, 0, -2, -2, -2);
            $this->numberOfStudentsInBeginnig->ViewCustomAttributes = "";

            // ownerAbout
            $this->ownerAbout->ViewValue = $this->ownerAbout->CurrentValue;
            $this->ownerAbout->ViewCustomAttributes = "";

            // pdfLicense
            $this->pdfLicense->ViewValue = $this->pdfLicense->CurrentValue;
            $this->pdfLicense->ViewCustomAttributes = "";

            // applicationId
            $this->applicationId->ViewValue = $this->applicationId->CurrentValue;
            $this->applicationId->ViewValue = FormatNumber($this->applicationId->ViewValue, 0, -2, -2, -2);
            $this->applicationId->ViewCustomAttributes = "";

            // isheadquarter
            if (ConvertToBool($this->isheadquarter->CurrentValue)) {
                $this->isheadquarter->ViewValue = $this->isheadquarter->tagCaption(1) != "" ? $this->isheadquarter->tagCaption(1) : "Yes";
            } else {
                $this->isheadquarter->ViewValue = $this->isheadquarter->tagCaption(2) != "" ? $this->isheadquarter->tagCaption(2) : "No";
            }
            $this->isheadquarter->ViewCustomAttributes = "";

            // federationId
            $this->federationId->LinkCustomAttributes = "";
            $this->federationId->HrefValue = "";
            $this->federationId->TooltipValue = "";

            // masterSchoolId
            $this->masterSchoolId->LinkCustomAttributes = "";
            $this->masterSchoolId->HrefValue = "";
            $this->masterSchoolId->TooltipValue = "";

            // school
            $this->school->LinkCustomAttributes = "";
            $this->school->HrefValue = "";
            $this->school->TooltipValue = "";

            // countryId
            $this->countryId->LinkCustomAttributes = "";
            $this->countryId->HrefValue = "";
            $this->countryId->TooltipValue = "";

            // UFId
            $this->UFId->LinkCustomAttributes = "";
            $this->UFId->HrefValue = "";
            $this->UFId->TooltipValue = "";

            // cityId
            $this->cityId->LinkCustomAttributes = "";
            $this->cityId->HrefValue = "";
            $this->cityId->TooltipValue = "";

            // neighborhood
            $this->neighborhood->LinkCustomAttributes = "";
            $this->neighborhood->HrefValue = "";
            $this->neighborhood->TooltipValue = "";

            // address
            $this->address->LinkCustomAttributes = "";
            $this->address->HrefValue = "";
            $this->address->TooltipValue = "";

            // zipcode
            $this->zipcode->LinkCustomAttributes = "";
            $this->zipcode->HrefValue = "";
            $this->zipcode->TooltipValue = "";

            // website
            $this->website->LinkCustomAttributes = "";
            $this->website->HrefValue = "";
            $this->website->TooltipValue = "";

            // email
            $this->_email->LinkCustomAttributes = "";
            $this->_email->HrefValue = "";
            $this->_email->TooltipValue = "";

            // phone
            $this->phone->LinkCustomAttributes = "";
            $this->phone->HrefValue = "";
            $this->phone->TooltipValue = "";

            // celphone
            $this->celphone->LinkCustomAttributes = "";
            $this->celphone->HrefValue = "";
            $this->celphone->TooltipValue = "";

            // logo
            $this->logo->LinkCustomAttributes = "";
            $this->logo->HrefValue = "";
            $this->logo->TooltipValue = "";

            // openingDate
            $this->openingDate->LinkCustomAttributes = "";
            $this->openingDate->HrefValue = "";
            $this->openingDate->TooltipValue = "";

            // federationRegister
            $this->federationRegister->LinkCustomAttributes = "";
            $this->federationRegister->HrefValue = "";
            $this->federationRegister->TooltipValue = "";

            // createUserId
            $this->createUserId->LinkCustomAttributes = "";
            $this->createUserId->HrefValue = "";
            $this->createUserId->TooltipValue = "";

            // createDate
            $this->createDate->LinkCustomAttributes = "";
            $this->createDate->HrefValue = "";
            $this->createDate->TooltipValue = "";

            // typeId
            $this->typeId->LinkCustomAttributes = "";
            $this->typeId->HrefValue = "";
            $this->typeId->TooltipValue = "";

            // owner
            $this->owner->LinkCustomAttributes = "";
            $this->owner->HrefValue = "";
            $this->owner->TooltipValue = "";

            // identityNumber
            $this->identityNumber->LinkCustomAttributes = "";
            $this->identityNumber->HrefValue = "";
            $this->identityNumber->TooltipValue = "";

            // birthDateOwner
            $this->birthDateOwner->LinkCustomAttributes = "";
            $this->birthDateOwner->HrefValue = "";
            $this->birthDateOwner->TooltipValue = "";

            // ownerCountryId
            $this->ownerCountryId->LinkCustomAttributes = "";
            $this->ownerCountryId->HrefValue = "";
            $this->ownerCountryId->TooltipValue = "";

            // ownerStateId
            $this->ownerStateId->LinkCustomAttributes = "";
            $this->ownerStateId->HrefValue = "";
            $this->ownerStateId->TooltipValue = "";

            // ownCityId
            $this->ownCityId->LinkCustomAttributes = "";
            $this->ownCityId->HrefValue = "";
            $this->ownCityId->TooltipValue = "";

            // ownerTelephone
            $this->ownerTelephone->LinkCustomAttributes = "";
            $this->ownerTelephone->HrefValue = "";
            $this->ownerTelephone->TooltipValue = "";

            // ownerTelephoneWork
            $this->ownerTelephoneWork->LinkCustomAttributes = "";
            $this->ownerTelephoneWork->HrefValue = "";
            $this->ownerTelephoneWork->TooltipValue = "";

            // ownerProfession
            $this->ownerProfession->LinkCustomAttributes = "";
            $this->ownerProfession->HrefValue = "";
            $this->ownerProfession->TooltipValue = "";

            // employer
            $this->employer->LinkCustomAttributes = "";
            $this->employer->HrefValue = "";
            $this->employer->TooltipValue = "";

            // ownerGraduation
            $this->ownerGraduation->LinkCustomAttributes = "";
            $this->ownerGraduation->HrefValue = "";
            $this->ownerGraduation->TooltipValue = "";

            // ownerGraduationLocation
            $this->ownerGraduationLocation->LinkCustomAttributes = "";
            $this->ownerGraduationLocation->HrefValue = "";
            $this->ownerGraduationLocation->TooltipValue = "";

            // ownerGraduationObs
            $this->ownerGraduationObs->LinkCustomAttributes = "";
            $this->ownerGraduationObs->HrefValue = "";
            $this->ownerGraduationObs->TooltipValue = "";

            // ownerMaritalStatus
            $this->ownerMaritalStatus->LinkCustomAttributes = "";
            $this->ownerMaritalStatus->HrefValue = "";
            $this->ownerMaritalStatus->TooltipValue = "";

            // ownerSpouseName
            $this->ownerSpouseName->LinkCustomAttributes = "";
            $this->ownerSpouseName->HrefValue = "";
            $this->ownerSpouseName->TooltipValue = "";

            // ownerSpouseProfession
            $this->ownerSpouseProfession->LinkCustomAttributes = "";
            $this->ownerSpouseProfession->HrefValue = "";
            $this->ownerSpouseProfession->TooltipValue = "";

            // propertySituation
            $this->propertySituation->LinkCustomAttributes = "";
            $this->propertySituation->HrefValue = "";
            $this->propertySituation->TooltipValue = "";

            // numberOfStudentsInBeginnig
            $this->numberOfStudentsInBeginnig->LinkCustomAttributes = "";
            $this->numberOfStudentsInBeginnig->HrefValue = "";
            $this->numberOfStudentsInBeginnig->TooltipValue = "";

            // ownerAbout
            $this->ownerAbout->LinkCustomAttributes = "";
            $this->ownerAbout->HrefValue = "";
            $this->ownerAbout->TooltipValue = "";

            // pdfLicense
            $this->pdfLicense->LinkCustomAttributes = "";
            $this->pdfLicense->HrefValue = "";
            $this->pdfLicense->TooltipValue = "";

            // applicationId
            $this->applicationId->LinkCustomAttributes = "";
            $this->applicationId->HrefValue = "";
            $this->applicationId->TooltipValue = "";

            // isheadquarter
            $this->isheadquarter->LinkCustomAttributes = "";
            $this->isheadquarter->HrefValue = "";
            $this->isheadquarter->TooltipValue = "";
        } elseif ($this->RowType == ROWTYPE_ADD) {
            // federationId
            $this->federationId->EditAttrs["class"] = "form-control";
            $this->federationId->EditCustomAttributes = "";
            $curVal = trim(strval($this->federationId->CurrentValue));
            if ($curVal != "") {
                $this->federationId->ViewValue = $this->federationId->lookupCacheOption($curVal);
            } else {
                $this->federationId->ViewValue = $this->federationId->Lookup !== null && is_array($this->federationId->Lookup->Options) ? $curVal : null;
            }
            if ($this->federationId->ViewValue !== null) { // Load from cache
                $this->federationId->EditValue = array_values($this->federationId->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`id`" . SearchString("=", $this->federationId->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->federationId->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->federationId->EditValue = $arwrk;
            }
            $this->federationId->PlaceHolder = RemoveHtml($this->federationId->caption());

            // masterSchoolId
            $this->masterSchoolId->EditAttrs["class"] = "form-control";
            $this->masterSchoolId->EditCustomAttributes = "";
            $curVal = trim(strval($this->masterSchoolId->CurrentValue));
            if ($curVal != "") {
                $this->masterSchoolId->ViewValue = $this->masterSchoolId->lookupCacheOption($curVal);
            } else {
                $this->masterSchoolId->ViewValue = $this->masterSchoolId->Lookup !== null && is_array($this->masterSchoolId->Lookup->Options) ? $curVal : null;
            }
            if ($this->masterSchoolId->ViewValue !== null) { // Load from cache
                $this->masterSchoolId->EditValue = array_values($this->masterSchoolId->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`id`" . SearchString("=", $this->masterSchoolId->CurrentValue, DATATYPE_NUMBER, "");
                }
                $lookupFilter = function() {
                    return "`typeId`=1";
                };
                $lookupFilter = $lookupFilter->bindTo($this);
                $sqlWrk = $this->masterSchoolId->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->masterSchoolId->EditValue = $arwrk;
            }
            $this->masterSchoolId->PlaceHolder = RemoveHtml($this->masterSchoolId->caption());

            // school
            $this->school->EditAttrs["class"] = "form-control";
            $this->school->EditCustomAttributes = "";
            if (!$this->school->Raw) {
                $this->school->CurrentValue = HtmlDecode($this->school->CurrentValue);
            }
            $this->school->EditValue = HtmlEncode($this->school->CurrentValue);
            $this->school->PlaceHolder = RemoveHtml($this->school->caption());

            // countryId
            $this->countryId->EditAttrs["class"] = "form-control";
            $this->countryId->EditCustomAttributes = "";
            $curVal = trim(strval($this->countryId->CurrentValue));
            if ($curVal != "") {
                $this->countryId->ViewValue = $this->countryId->lookupCacheOption($curVal);
            } else {
                $this->countryId->ViewValue = $this->countryId->Lookup !== null && is_array($this->countryId->Lookup->Options) ? $curVal : null;
            }
            if ($this->countryId->ViewValue !== null) { // Load from cache
                $this->countryId->EditValue = array_values($this->countryId->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`id`" . SearchString("=", $this->countryId->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->countryId->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->countryId->EditValue = $arwrk;
            }
            $this->countryId->PlaceHolder = RemoveHtml($this->countryId->caption());

            // UFId
            $this->UFId->EditAttrs["class"] = "form-control";
            $this->UFId->EditCustomAttributes = "";
            $curVal = trim(strval($this->UFId->CurrentValue));
            if ($curVal != "") {
                $this->UFId->ViewValue = $this->UFId->lookupCacheOption($curVal);
            } else {
                $this->UFId->ViewValue = $this->UFId->Lookup !== null && is_array($this->UFId->Lookup->Options) ? $curVal : null;
            }
            if ($this->UFId->ViewValue !== null) { // Load from cache
                $this->UFId->EditValue = array_values($this->UFId->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`id`" . SearchString("=", $this->UFId->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->UFId->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->UFId->EditValue = $arwrk;
            }
            $this->UFId->PlaceHolder = RemoveHtml($this->UFId->caption());

            // cityId
            $this->cityId->EditAttrs["class"] = "form-control";
            $this->cityId->EditCustomAttributes = "";
            $curVal = trim(strval($this->cityId->CurrentValue));
            if ($curVal != "") {
                $this->cityId->ViewValue = $this->cityId->lookupCacheOption($curVal);
            } else {
                $this->cityId->ViewValue = $this->cityId->Lookup !== null && is_array($this->cityId->Lookup->Options) ? $curVal : null;
            }
            if ($this->cityId->ViewValue !== null) { // Load from cache
                $this->cityId->EditValue = array_values($this->cityId->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`id`" . SearchString("=", $this->cityId->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->cityId->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->cityId->EditValue = $arwrk;
            }
            $this->cityId->PlaceHolder = RemoveHtml($this->cityId->caption());

            // neighborhood
            $this->neighborhood->EditAttrs["class"] = "form-control";
            $this->neighborhood->EditCustomAttributes = "";
            if (!$this->neighborhood->Raw) {
                $this->neighborhood->CurrentValue = HtmlDecode($this->neighborhood->CurrentValue);
            }
            $this->neighborhood->EditValue = HtmlEncode($this->neighborhood->CurrentValue);
            $this->neighborhood->PlaceHolder = RemoveHtml($this->neighborhood->caption());

            // address
            $this->address->EditAttrs["class"] = "form-control";
            $this->address->EditCustomAttributes = "";
            if (!$this->address->Raw) {
                $this->address->CurrentValue = HtmlDecode($this->address->CurrentValue);
            }
            $this->address->EditValue = HtmlEncode($this->address->CurrentValue);
            $this->address->PlaceHolder = RemoveHtml($this->address->caption());

            // zipcode
            $this->zipcode->EditAttrs["class"] = "form-control";
            $this->zipcode->EditCustomAttributes = "";
            if (!$this->zipcode->Raw) {
                $this->zipcode->CurrentValue = HtmlDecode($this->zipcode->CurrentValue);
            }
            $this->zipcode->EditValue = HtmlEncode($this->zipcode->CurrentValue);
            $this->zipcode->PlaceHolder = RemoveHtml($this->zipcode->caption());

            // website
            $this->website->EditAttrs["class"] = "form-control";
            $this->website->EditCustomAttributes = "";
            if (!$this->website->Raw) {
                $this->website->CurrentValue = HtmlDecode($this->website->CurrentValue);
            }
            $this->website->EditValue = HtmlEncode($this->website->CurrentValue);
            $this->website->PlaceHolder = RemoveHtml($this->website->caption());

            // email
            $this->_email->EditAttrs["class"] = "form-control";
            $this->_email->EditCustomAttributes = "";
            if (!$this->_email->Raw) {
                $this->_email->CurrentValue = HtmlDecode($this->_email->CurrentValue);
            }
            $this->_email->EditValue = HtmlEncode($this->_email->CurrentValue);
            $this->_email->PlaceHolder = RemoveHtml($this->_email->caption());

            // phone
            $this->phone->EditAttrs["class"] = "form-control";
            $this->phone->EditCustomAttributes = "";
            if (!$this->phone->Raw) {
                $this->phone->CurrentValue = HtmlDecode($this->phone->CurrentValue);
            }
            $this->phone->EditValue = HtmlEncode($this->phone->CurrentValue);
            $this->phone->PlaceHolder = RemoveHtml($this->phone->caption());

            // celphone
            $this->celphone->EditAttrs["class"] = "form-control";
            $this->celphone->EditCustomAttributes = "";
            if (!$this->celphone->Raw) {
                $this->celphone->CurrentValue = HtmlDecode($this->celphone->CurrentValue);
            }
            $this->celphone->EditValue = HtmlEncode($this->celphone->CurrentValue);
            $this->celphone->PlaceHolder = RemoveHtml($this->celphone->caption());

            // logo
            $this->logo->EditAttrs["class"] = "form-control";
            $this->logo->EditCustomAttributes = "";
            if (!$this->logo->Raw) {
                $this->logo->CurrentValue = HtmlDecode($this->logo->CurrentValue);
            }
            $this->logo->EditValue = HtmlEncode($this->logo->CurrentValue);
            $this->logo->PlaceHolder = RemoveHtml($this->logo->caption());

            // openingDate
            $this->openingDate->EditAttrs["class"] = "form-control";
            $this->openingDate->EditCustomAttributes = "";
            $this->openingDate->EditValue = HtmlEncode(FormatDateTime($this->openingDate->CurrentValue, 8));
            $this->openingDate->PlaceHolder = RemoveHtml($this->openingDate->caption());

            // federationRegister
            $this->federationRegister->EditAttrs["class"] = "form-control";
            $this->federationRegister->EditCustomAttributes = "";
            if (!$this->federationRegister->Raw) {
                $this->federationRegister->CurrentValue = HtmlDecode($this->federationRegister->CurrentValue);
            }
            $this->federationRegister->EditValue = HtmlEncode($this->federationRegister->CurrentValue);
            $this->federationRegister->PlaceHolder = RemoveHtml($this->federationRegister->caption());

            // createUserId
            $this->createUserId->EditAttrs["class"] = "form-control";
            $this->createUserId->EditCustomAttributes = "";
            $this->createUserId->EditValue = HtmlEncode($this->createUserId->CurrentValue);
            $this->createUserId->PlaceHolder = RemoveHtml($this->createUserId->caption());

            // createDate
            $this->createDate->EditAttrs["class"] = "form-control";
            $this->createDate->EditCustomAttributes = "";
            $this->createDate->EditValue = HtmlEncode(FormatDateTime($this->createDate->CurrentValue, 8));
            $this->createDate->PlaceHolder = RemoveHtml($this->createDate->caption());

            // typeId
            $this->typeId->EditAttrs["class"] = "form-control";
            $this->typeId->EditCustomAttributes = "";
            $this->typeId->EditValue = HtmlEncode($this->typeId->CurrentValue);
            $this->typeId->PlaceHolder = RemoveHtml($this->typeId->caption());

            // owner
            $this->owner->EditAttrs["class"] = "form-control";
            $this->owner->EditCustomAttributes = "";
            if (!$this->owner->Raw) {
                $this->owner->CurrentValue = HtmlDecode($this->owner->CurrentValue);
            }
            $this->owner->EditValue = HtmlEncode($this->owner->CurrentValue);
            $this->owner->PlaceHolder = RemoveHtml($this->owner->caption());

            // identityNumber
            $this->identityNumber->EditAttrs["class"] = "form-control";
            $this->identityNumber->EditCustomAttributes = "";
            if (!$this->identityNumber->Raw) {
                $this->identityNumber->CurrentValue = HtmlDecode($this->identityNumber->CurrentValue);
            }
            $this->identityNumber->EditValue = HtmlEncode($this->identityNumber->CurrentValue);
            $this->identityNumber->PlaceHolder = RemoveHtml($this->identityNumber->caption());

            // birthDateOwner
            $this->birthDateOwner->EditAttrs["class"] = "form-control";
            $this->birthDateOwner->EditCustomAttributes = "";
            $this->birthDateOwner->EditValue = HtmlEncode(FormatDateTime($this->birthDateOwner->CurrentValue, 8));
            $this->birthDateOwner->PlaceHolder = RemoveHtml($this->birthDateOwner->caption());

            // ownerCountryId
            $this->ownerCountryId->EditAttrs["class"] = "form-control";
            $this->ownerCountryId->EditCustomAttributes = "";
            $this->ownerCountryId->EditValue = HtmlEncode($this->ownerCountryId->CurrentValue);
            $this->ownerCountryId->PlaceHolder = RemoveHtml($this->ownerCountryId->caption());

            // ownerStateId
            $this->ownerStateId->EditAttrs["class"] = "form-control";
            $this->ownerStateId->EditCustomAttributes = "";
            $this->ownerStateId->EditValue = HtmlEncode($this->ownerStateId->CurrentValue);
            $this->ownerStateId->PlaceHolder = RemoveHtml($this->ownerStateId->caption());

            // ownCityId
            $this->ownCityId->EditAttrs["class"] = "form-control";
            $this->ownCityId->EditCustomAttributes = "";
            $this->ownCityId->EditValue = HtmlEncode($this->ownCityId->CurrentValue);
            $this->ownCityId->PlaceHolder = RemoveHtml($this->ownCityId->caption());

            // ownerTelephone
            $this->ownerTelephone->EditAttrs["class"] = "form-control";
            $this->ownerTelephone->EditCustomAttributes = "";
            if (!$this->ownerTelephone->Raw) {
                $this->ownerTelephone->CurrentValue = HtmlDecode($this->ownerTelephone->CurrentValue);
            }
            $this->ownerTelephone->EditValue = HtmlEncode($this->ownerTelephone->CurrentValue);
            $this->ownerTelephone->PlaceHolder = RemoveHtml($this->ownerTelephone->caption());

            // ownerTelephoneWork
            $this->ownerTelephoneWork->EditAttrs["class"] = "form-control";
            $this->ownerTelephoneWork->EditCustomAttributes = "";
            if (!$this->ownerTelephoneWork->Raw) {
                $this->ownerTelephoneWork->CurrentValue = HtmlDecode($this->ownerTelephoneWork->CurrentValue);
            }
            $this->ownerTelephoneWork->EditValue = HtmlEncode($this->ownerTelephoneWork->CurrentValue);
            $this->ownerTelephoneWork->PlaceHolder = RemoveHtml($this->ownerTelephoneWork->caption());

            // ownerProfession
            $this->ownerProfession->EditAttrs["class"] = "form-control";
            $this->ownerProfession->EditCustomAttributes = "";
            if (!$this->ownerProfession->Raw) {
                $this->ownerProfession->CurrentValue = HtmlDecode($this->ownerProfession->CurrentValue);
            }
            $this->ownerProfession->EditValue = HtmlEncode($this->ownerProfession->CurrentValue);
            $this->ownerProfession->PlaceHolder = RemoveHtml($this->ownerProfession->caption());

            // employer
            $this->employer->EditAttrs["class"] = "form-control";
            $this->employer->EditCustomAttributes = "";
            if (!$this->employer->Raw) {
                $this->employer->CurrentValue = HtmlDecode($this->employer->CurrentValue);
            }
            $this->employer->EditValue = HtmlEncode($this->employer->CurrentValue);
            $this->employer->PlaceHolder = RemoveHtml($this->employer->caption());

            // ownerGraduation
            $this->ownerGraduation->EditAttrs["class"] = "form-control";
            $this->ownerGraduation->EditCustomAttributes = "";
            $this->ownerGraduation->EditValue = HtmlEncode($this->ownerGraduation->CurrentValue);
            $this->ownerGraduation->PlaceHolder = RemoveHtml($this->ownerGraduation->caption());

            // ownerGraduationLocation
            $this->ownerGraduationLocation->EditAttrs["class"] = "form-control";
            $this->ownerGraduationLocation->EditCustomAttributes = "";
            if (!$this->ownerGraduationLocation->Raw) {
                $this->ownerGraduationLocation->CurrentValue = HtmlDecode($this->ownerGraduationLocation->CurrentValue);
            }
            $this->ownerGraduationLocation->EditValue = HtmlEncode($this->ownerGraduationLocation->CurrentValue);
            $this->ownerGraduationLocation->PlaceHolder = RemoveHtml($this->ownerGraduationLocation->caption());

            // ownerGraduationObs
            $this->ownerGraduationObs->EditAttrs["class"] = "form-control";
            $this->ownerGraduationObs->EditCustomAttributes = "";
            $this->ownerGraduationObs->EditValue = HtmlEncode($this->ownerGraduationObs->CurrentValue);
            $this->ownerGraduationObs->PlaceHolder = RemoveHtml($this->ownerGraduationObs->caption());

            // ownerMaritalStatus
            $this->ownerMaritalStatus->EditAttrs["class"] = "form-control";
            $this->ownerMaritalStatus->EditCustomAttributes = "";
            $this->ownerMaritalStatus->EditValue = HtmlEncode($this->ownerMaritalStatus->CurrentValue);
            $this->ownerMaritalStatus->PlaceHolder = RemoveHtml($this->ownerMaritalStatus->caption());

            // ownerSpouseName
            $this->ownerSpouseName->EditAttrs["class"] = "form-control";
            $this->ownerSpouseName->EditCustomAttributes = "";
            if (!$this->ownerSpouseName->Raw) {
                $this->ownerSpouseName->CurrentValue = HtmlDecode($this->ownerSpouseName->CurrentValue);
            }
            $this->ownerSpouseName->EditValue = HtmlEncode($this->ownerSpouseName->CurrentValue);
            $this->ownerSpouseName->PlaceHolder = RemoveHtml($this->ownerSpouseName->caption());

            // ownerSpouseProfession
            $this->ownerSpouseProfession->EditAttrs["class"] = "form-control";
            $this->ownerSpouseProfession->EditCustomAttributes = "";
            if (!$this->ownerSpouseProfession->Raw) {
                $this->ownerSpouseProfession->CurrentValue = HtmlDecode($this->ownerSpouseProfession->CurrentValue);
            }
            $this->ownerSpouseProfession->EditValue = HtmlEncode($this->ownerSpouseProfession->CurrentValue);
            $this->ownerSpouseProfession->PlaceHolder = RemoveHtml($this->ownerSpouseProfession->caption());

            // propertySituation
            $this->propertySituation->EditAttrs["class"] = "form-control";
            $this->propertySituation->EditCustomAttributes = "";
            $this->propertySituation->EditValue = HtmlEncode($this->propertySituation->CurrentValue);
            $this->propertySituation->PlaceHolder = RemoveHtml($this->propertySituation->caption());

            // numberOfStudentsInBeginnig
            $this->numberOfStudentsInBeginnig->EditAttrs["class"] = "form-control";
            $this->numberOfStudentsInBeginnig->EditCustomAttributes = "";
            $this->numberOfStudentsInBeginnig->EditValue = HtmlEncode($this->numberOfStudentsInBeginnig->CurrentValue);
            $this->numberOfStudentsInBeginnig->PlaceHolder = RemoveHtml($this->numberOfStudentsInBeginnig->caption());

            // ownerAbout
            $this->ownerAbout->EditAttrs["class"] = "form-control";
            $this->ownerAbout->EditCustomAttributes = "";
            $this->ownerAbout->EditValue = HtmlEncode($this->ownerAbout->CurrentValue);
            $this->ownerAbout->PlaceHolder = RemoveHtml($this->ownerAbout->caption());

            // pdfLicense
            $this->pdfLicense->EditAttrs["class"] = "form-control";
            $this->pdfLicense->EditCustomAttributes = "";
            $this->pdfLicense->EditValue = HtmlEncode($this->pdfLicense->CurrentValue);
            $this->pdfLicense->PlaceHolder = RemoveHtml($this->pdfLicense->caption());

            // applicationId
            $this->applicationId->EditAttrs["class"] = "form-control";
            $this->applicationId->EditCustomAttributes = "";
            if ($this->applicationId->getSessionValue() != "") {
                $this->applicationId->CurrentValue = GetForeignKeyValue($this->applicationId->getSessionValue());
                $this->applicationId->ViewValue = $this->applicationId->CurrentValue;
                $this->applicationId->ViewValue = FormatNumber($this->applicationId->ViewValue, 0, -2, -2, -2);
                $this->applicationId->ViewCustomAttributes = "";
            } else {
                $this->applicationId->EditValue = HtmlEncode($this->applicationId->CurrentValue);
                $this->applicationId->PlaceHolder = RemoveHtml($this->applicationId->caption());
            }

            // isheadquarter
            $this->isheadquarter->EditCustomAttributes = "";
            $this->isheadquarter->EditValue = $this->isheadquarter->options(false);
            $this->isheadquarter->PlaceHolder = RemoveHtml($this->isheadquarter->caption());

            // Add refer script

            // federationId
            $this->federationId->LinkCustomAttributes = "";
            $this->federationId->HrefValue = "";

            // masterSchoolId
            $this->masterSchoolId->LinkCustomAttributes = "";
            $this->masterSchoolId->HrefValue = "";

            // school
            $this->school->LinkCustomAttributes = "";
            $this->school->HrefValue = "";

            // countryId
            $this->countryId->LinkCustomAttributes = "";
            $this->countryId->HrefValue = "";

            // UFId
            $this->UFId->LinkCustomAttributes = "";
            $this->UFId->HrefValue = "";

            // cityId
            $this->cityId->LinkCustomAttributes = "";
            $this->cityId->HrefValue = "";

            // neighborhood
            $this->neighborhood->LinkCustomAttributes = "";
            $this->neighborhood->HrefValue = "";

            // address
            $this->address->LinkCustomAttributes = "";
            $this->address->HrefValue = "";

            // zipcode
            $this->zipcode->LinkCustomAttributes = "";
            $this->zipcode->HrefValue = "";

            // website
            $this->website->LinkCustomAttributes = "";
            $this->website->HrefValue = "";

            // email
            $this->_email->LinkCustomAttributes = "";
            $this->_email->HrefValue = "";

            // phone
            $this->phone->LinkCustomAttributes = "";
            $this->phone->HrefValue = "";

            // celphone
            $this->celphone->LinkCustomAttributes = "";
            $this->celphone->HrefValue = "";

            // logo
            $this->logo->LinkCustomAttributes = "";
            $this->logo->HrefValue = "";

            // openingDate
            $this->openingDate->LinkCustomAttributes = "";
            $this->openingDate->HrefValue = "";

            // federationRegister
            $this->federationRegister->LinkCustomAttributes = "";
            $this->federationRegister->HrefValue = "";

            // createUserId
            $this->createUserId->LinkCustomAttributes = "";
            $this->createUserId->HrefValue = "";

            // createDate
            $this->createDate->LinkCustomAttributes = "";
            $this->createDate->HrefValue = "";

            // typeId
            $this->typeId->LinkCustomAttributes = "";
            $this->typeId->HrefValue = "";

            // owner
            $this->owner->LinkCustomAttributes = "";
            $this->owner->HrefValue = "";

            // identityNumber
            $this->identityNumber->LinkCustomAttributes = "";
            $this->identityNumber->HrefValue = "";

            // birthDateOwner
            $this->birthDateOwner->LinkCustomAttributes = "";
            $this->birthDateOwner->HrefValue = "";

            // ownerCountryId
            $this->ownerCountryId->LinkCustomAttributes = "";
            $this->ownerCountryId->HrefValue = "";

            // ownerStateId
            $this->ownerStateId->LinkCustomAttributes = "";
            $this->ownerStateId->HrefValue = "";

            // ownCityId
            $this->ownCityId->LinkCustomAttributes = "";
            $this->ownCityId->HrefValue = "";

            // ownerTelephone
            $this->ownerTelephone->LinkCustomAttributes = "";
            $this->ownerTelephone->HrefValue = "";

            // ownerTelephoneWork
            $this->ownerTelephoneWork->LinkCustomAttributes = "";
            $this->ownerTelephoneWork->HrefValue = "";

            // ownerProfession
            $this->ownerProfession->LinkCustomAttributes = "";
            $this->ownerProfession->HrefValue = "";

            // employer
            $this->employer->LinkCustomAttributes = "";
            $this->employer->HrefValue = "";

            // ownerGraduation
            $this->ownerGraduation->LinkCustomAttributes = "";
            $this->ownerGraduation->HrefValue = "";

            // ownerGraduationLocation
            $this->ownerGraduationLocation->LinkCustomAttributes = "";
            $this->ownerGraduationLocation->HrefValue = "";

            // ownerGraduationObs
            $this->ownerGraduationObs->LinkCustomAttributes = "";
            $this->ownerGraduationObs->HrefValue = "";

            // ownerMaritalStatus
            $this->ownerMaritalStatus->LinkCustomAttributes = "";
            $this->ownerMaritalStatus->HrefValue = "";

            // ownerSpouseName
            $this->ownerSpouseName->LinkCustomAttributes = "";
            $this->ownerSpouseName->HrefValue = "";

            // ownerSpouseProfession
            $this->ownerSpouseProfession->LinkCustomAttributes = "";
            $this->ownerSpouseProfession->HrefValue = "";

            // propertySituation
            $this->propertySituation->LinkCustomAttributes = "";
            $this->propertySituation->HrefValue = "";

            // numberOfStudentsInBeginnig
            $this->numberOfStudentsInBeginnig->LinkCustomAttributes = "";
            $this->numberOfStudentsInBeginnig->HrefValue = "";

            // ownerAbout
            $this->ownerAbout->LinkCustomAttributes = "";
            $this->ownerAbout->HrefValue = "";

            // pdfLicense
            $this->pdfLicense->LinkCustomAttributes = "";
            $this->pdfLicense->HrefValue = "";

            // applicationId
            $this->applicationId->LinkCustomAttributes = "";
            $this->applicationId->HrefValue = "";

            // isheadquarter
            $this->isheadquarter->LinkCustomAttributes = "";
            $this->isheadquarter->HrefValue = "";
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if ($this->federationId->Required) {
            if (!$this->federationId->IsDetailKey && EmptyValue($this->federationId->FormValue)) {
                $this->federationId->addErrorMessage(str_replace("%s", $this->federationId->caption(), $this->federationId->RequiredErrorMessage));
            }
        }
        if ($this->masterSchoolId->Required) {
            if (!$this->masterSchoolId->IsDetailKey && EmptyValue($this->masterSchoolId->FormValue)) {
                $this->masterSchoolId->addErrorMessage(str_replace("%s", $this->masterSchoolId->caption(), $this->masterSchoolId->RequiredErrorMessage));
            }
        }
        if ($this->school->Required) {
            if (!$this->school->IsDetailKey && EmptyValue($this->school->FormValue)) {
                $this->school->addErrorMessage(str_replace("%s", $this->school->caption(), $this->school->RequiredErrorMessage));
            }
        }
        if ($this->countryId->Required) {
            if (!$this->countryId->IsDetailKey && EmptyValue($this->countryId->FormValue)) {
                $this->countryId->addErrorMessage(str_replace("%s", $this->countryId->caption(), $this->countryId->RequiredErrorMessage));
            }
        }
        if ($this->UFId->Required) {
            if (!$this->UFId->IsDetailKey && EmptyValue($this->UFId->FormValue)) {
                $this->UFId->addErrorMessage(str_replace("%s", $this->UFId->caption(), $this->UFId->RequiredErrorMessage));
            }
        }
        if ($this->cityId->Required) {
            if (!$this->cityId->IsDetailKey && EmptyValue($this->cityId->FormValue)) {
                $this->cityId->addErrorMessage(str_replace("%s", $this->cityId->caption(), $this->cityId->RequiredErrorMessage));
            }
        }
        if ($this->neighborhood->Required) {
            if (!$this->neighborhood->IsDetailKey && EmptyValue($this->neighborhood->FormValue)) {
                $this->neighborhood->addErrorMessage(str_replace("%s", $this->neighborhood->caption(), $this->neighborhood->RequiredErrorMessage));
            }
        }
        if ($this->address->Required) {
            if (!$this->address->IsDetailKey && EmptyValue($this->address->FormValue)) {
                $this->address->addErrorMessage(str_replace("%s", $this->address->caption(), $this->address->RequiredErrorMessage));
            }
        }
        if ($this->zipcode->Required) {
            if (!$this->zipcode->IsDetailKey && EmptyValue($this->zipcode->FormValue)) {
                $this->zipcode->addErrorMessage(str_replace("%s", $this->zipcode->caption(), $this->zipcode->RequiredErrorMessage));
            }
        }
        if ($this->website->Required) {
            if (!$this->website->IsDetailKey && EmptyValue($this->website->FormValue)) {
                $this->website->addErrorMessage(str_replace("%s", $this->website->caption(), $this->website->RequiredErrorMessage));
            }
        }
        if ($this->_email->Required) {
            if (!$this->_email->IsDetailKey && EmptyValue($this->_email->FormValue)) {
                $this->_email->addErrorMessage(str_replace("%s", $this->_email->caption(), $this->_email->RequiredErrorMessage));
            }
        }
        if ($this->phone->Required) {
            if (!$this->phone->IsDetailKey && EmptyValue($this->phone->FormValue)) {
                $this->phone->addErrorMessage(str_replace("%s", $this->phone->caption(), $this->phone->RequiredErrorMessage));
            }
        }
        if ($this->celphone->Required) {
            if (!$this->celphone->IsDetailKey && EmptyValue($this->celphone->FormValue)) {
                $this->celphone->addErrorMessage(str_replace("%s", $this->celphone->caption(), $this->celphone->RequiredErrorMessage));
            }
        }
        if ($this->logo->Required) {
            if (!$this->logo->IsDetailKey && EmptyValue($this->logo->FormValue)) {
                $this->logo->addErrorMessage(str_replace("%s", $this->logo->caption(), $this->logo->RequiredErrorMessage));
            }
        }
        if ($this->openingDate->Required) {
            if (!$this->openingDate->IsDetailKey && EmptyValue($this->openingDate->FormValue)) {
                $this->openingDate->addErrorMessage(str_replace("%s", $this->openingDate->caption(), $this->openingDate->RequiredErrorMessage));
            }
        }
        if (!CheckDate($this->openingDate->FormValue)) {
            $this->openingDate->addErrorMessage($this->openingDate->getErrorMessage(false));
        }
        if ($this->federationRegister->Required) {
            if (!$this->federationRegister->IsDetailKey && EmptyValue($this->federationRegister->FormValue)) {
                $this->federationRegister->addErrorMessage(str_replace("%s", $this->federationRegister->caption(), $this->federationRegister->RequiredErrorMessage));
            }
        }
        if ($this->createUserId->Required) {
            if (!$this->createUserId->IsDetailKey && EmptyValue($this->createUserId->FormValue)) {
                $this->createUserId->addErrorMessage(str_replace("%s", $this->createUserId->caption(), $this->createUserId->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->createUserId->FormValue)) {
            $this->createUserId->addErrorMessage($this->createUserId->getErrorMessage(false));
        }
        if ($this->createDate->Required) {
            if (!$this->createDate->IsDetailKey && EmptyValue($this->createDate->FormValue)) {
                $this->createDate->addErrorMessage(str_replace("%s", $this->createDate->caption(), $this->createDate->RequiredErrorMessage));
            }
        }
        if (!CheckDate($this->createDate->FormValue)) {
            $this->createDate->addErrorMessage($this->createDate->getErrorMessage(false));
        }
        if ($this->typeId->Required) {
            if (!$this->typeId->IsDetailKey && EmptyValue($this->typeId->FormValue)) {
                $this->typeId->addErrorMessage(str_replace("%s", $this->typeId->caption(), $this->typeId->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->typeId->FormValue)) {
            $this->typeId->addErrorMessage($this->typeId->getErrorMessage(false));
        }
        if ($this->owner->Required) {
            if (!$this->owner->IsDetailKey && EmptyValue($this->owner->FormValue)) {
                $this->owner->addErrorMessage(str_replace("%s", $this->owner->caption(), $this->owner->RequiredErrorMessage));
            }
        }
        if ($this->identityNumber->Required) {
            if (!$this->identityNumber->IsDetailKey && EmptyValue($this->identityNumber->FormValue)) {
                $this->identityNumber->addErrorMessage(str_replace("%s", $this->identityNumber->caption(), $this->identityNumber->RequiredErrorMessage));
            }
        }
        if ($this->birthDateOwner->Required) {
            if (!$this->birthDateOwner->IsDetailKey && EmptyValue($this->birthDateOwner->FormValue)) {
                $this->birthDateOwner->addErrorMessage(str_replace("%s", $this->birthDateOwner->caption(), $this->birthDateOwner->RequiredErrorMessage));
            }
        }
        if (!CheckDate($this->birthDateOwner->FormValue)) {
            $this->birthDateOwner->addErrorMessage($this->birthDateOwner->getErrorMessage(false));
        }
        if ($this->ownerCountryId->Required) {
            if (!$this->ownerCountryId->IsDetailKey && EmptyValue($this->ownerCountryId->FormValue)) {
                $this->ownerCountryId->addErrorMessage(str_replace("%s", $this->ownerCountryId->caption(), $this->ownerCountryId->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->ownerCountryId->FormValue)) {
            $this->ownerCountryId->addErrorMessage($this->ownerCountryId->getErrorMessage(false));
        }
        if ($this->ownerStateId->Required) {
            if (!$this->ownerStateId->IsDetailKey && EmptyValue($this->ownerStateId->FormValue)) {
                $this->ownerStateId->addErrorMessage(str_replace("%s", $this->ownerStateId->caption(), $this->ownerStateId->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->ownerStateId->FormValue)) {
            $this->ownerStateId->addErrorMessage($this->ownerStateId->getErrorMessage(false));
        }
        if ($this->ownCityId->Required) {
            if (!$this->ownCityId->IsDetailKey && EmptyValue($this->ownCityId->FormValue)) {
                $this->ownCityId->addErrorMessage(str_replace("%s", $this->ownCityId->caption(), $this->ownCityId->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->ownCityId->FormValue)) {
            $this->ownCityId->addErrorMessage($this->ownCityId->getErrorMessage(false));
        }
        if ($this->ownerTelephone->Required) {
            if (!$this->ownerTelephone->IsDetailKey && EmptyValue($this->ownerTelephone->FormValue)) {
                $this->ownerTelephone->addErrorMessage(str_replace("%s", $this->ownerTelephone->caption(), $this->ownerTelephone->RequiredErrorMessage));
            }
        }
        if ($this->ownerTelephoneWork->Required) {
            if (!$this->ownerTelephoneWork->IsDetailKey && EmptyValue($this->ownerTelephoneWork->FormValue)) {
                $this->ownerTelephoneWork->addErrorMessage(str_replace("%s", $this->ownerTelephoneWork->caption(), $this->ownerTelephoneWork->RequiredErrorMessage));
            }
        }
        if ($this->ownerProfession->Required) {
            if (!$this->ownerProfession->IsDetailKey && EmptyValue($this->ownerProfession->FormValue)) {
                $this->ownerProfession->addErrorMessage(str_replace("%s", $this->ownerProfession->caption(), $this->ownerProfession->RequiredErrorMessage));
            }
        }
        if ($this->employer->Required) {
            if (!$this->employer->IsDetailKey && EmptyValue($this->employer->FormValue)) {
                $this->employer->addErrorMessage(str_replace("%s", $this->employer->caption(), $this->employer->RequiredErrorMessage));
            }
        }
        if ($this->ownerGraduation->Required) {
            if (!$this->ownerGraduation->IsDetailKey && EmptyValue($this->ownerGraduation->FormValue)) {
                $this->ownerGraduation->addErrorMessage(str_replace("%s", $this->ownerGraduation->caption(), $this->ownerGraduation->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->ownerGraduation->FormValue)) {
            $this->ownerGraduation->addErrorMessage($this->ownerGraduation->getErrorMessage(false));
        }
        if ($this->ownerGraduationLocation->Required) {
            if (!$this->ownerGraduationLocation->IsDetailKey && EmptyValue($this->ownerGraduationLocation->FormValue)) {
                $this->ownerGraduationLocation->addErrorMessage(str_replace("%s", $this->ownerGraduationLocation->caption(), $this->ownerGraduationLocation->RequiredErrorMessage));
            }
        }
        if ($this->ownerGraduationObs->Required) {
            if (!$this->ownerGraduationObs->IsDetailKey && EmptyValue($this->ownerGraduationObs->FormValue)) {
                $this->ownerGraduationObs->addErrorMessage(str_replace("%s", $this->ownerGraduationObs->caption(), $this->ownerGraduationObs->RequiredErrorMessage));
            }
        }
        if ($this->ownerMaritalStatus->Required) {
            if (!$this->ownerMaritalStatus->IsDetailKey && EmptyValue($this->ownerMaritalStatus->FormValue)) {
                $this->ownerMaritalStatus->addErrorMessage(str_replace("%s", $this->ownerMaritalStatus->caption(), $this->ownerMaritalStatus->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->ownerMaritalStatus->FormValue)) {
            $this->ownerMaritalStatus->addErrorMessage($this->ownerMaritalStatus->getErrorMessage(false));
        }
        if ($this->ownerSpouseName->Required) {
            if (!$this->ownerSpouseName->IsDetailKey && EmptyValue($this->ownerSpouseName->FormValue)) {
                $this->ownerSpouseName->addErrorMessage(str_replace("%s", $this->ownerSpouseName->caption(), $this->ownerSpouseName->RequiredErrorMessage));
            }
        }
        if ($this->ownerSpouseProfession->Required) {
            if (!$this->ownerSpouseProfession->IsDetailKey && EmptyValue($this->ownerSpouseProfession->FormValue)) {
                $this->ownerSpouseProfession->addErrorMessage(str_replace("%s", $this->ownerSpouseProfession->caption(), $this->ownerSpouseProfession->RequiredErrorMessage));
            }
        }
        if ($this->propertySituation->Required) {
            if (!$this->propertySituation->IsDetailKey && EmptyValue($this->propertySituation->FormValue)) {
                $this->propertySituation->addErrorMessage(str_replace("%s", $this->propertySituation->caption(), $this->propertySituation->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->propertySituation->FormValue)) {
            $this->propertySituation->addErrorMessage($this->propertySituation->getErrorMessage(false));
        }
        if ($this->numberOfStudentsInBeginnig->Required) {
            if (!$this->numberOfStudentsInBeginnig->IsDetailKey && EmptyValue($this->numberOfStudentsInBeginnig->FormValue)) {
                $this->numberOfStudentsInBeginnig->addErrorMessage(str_replace("%s", $this->numberOfStudentsInBeginnig->caption(), $this->numberOfStudentsInBeginnig->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->numberOfStudentsInBeginnig->FormValue)) {
            $this->numberOfStudentsInBeginnig->addErrorMessage($this->numberOfStudentsInBeginnig->getErrorMessage(false));
        }
        if ($this->ownerAbout->Required) {
            if (!$this->ownerAbout->IsDetailKey && EmptyValue($this->ownerAbout->FormValue)) {
                $this->ownerAbout->addErrorMessage(str_replace("%s", $this->ownerAbout->caption(), $this->ownerAbout->RequiredErrorMessage));
            }
        }
        if ($this->pdfLicense->Required) {
            if (!$this->pdfLicense->IsDetailKey && EmptyValue($this->pdfLicense->FormValue)) {
                $this->pdfLicense->addErrorMessage(str_replace("%s", $this->pdfLicense->caption(), $this->pdfLicense->RequiredErrorMessage));
            }
        }
        if ($this->applicationId->Required) {
            if (!$this->applicationId->IsDetailKey && EmptyValue($this->applicationId->FormValue)) {
                $this->applicationId->addErrorMessage(str_replace("%s", $this->applicationId->caption(), $this->applicationId->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->applicationId->FormValue)) {
            $this->applicationId->addErrorMessage($this->applicationId->getErrorMessage(false));
        }
        if ($this->isheadquarter->Required) {
            if ($this->isheadquarter->FormValue == "") {
                $this->isheadquarter->addErrorMessage(str_replace("%s", $this->isheadquarter->caption(), $this->isheadquarter->RequiredErrorMessage));
            }
        }

        // Validate detail grid
        $detailTblVar = explode(",", $this->getCurrentDetailTable());
        $detailPage = Container("SchoolUsersGrid");
        if (in_array("school_users", $detailTblVar) && $detailPage->DetailAdd) {
            $detailPage->validateGridForm();
        }
        $detailPage = Container("SchoolMemberGrid");
        if (in_array("school_member", $detailTblVar) && $detailPage->DetailAdd) {
            $detailPage->validateGridForm();
        }

        // Return validate result
        $validateForm = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Check if valid User ID
        $validUser = false;
        if ($Security->currentUserID() != "" && !EmptyValue($this->id->CurrentValue) && !$Security->isAdmin()) { // Non system admin
            $validUser = $Security->isValidUserID($this->id->CurrentValue);
            if (!$validUser) {
                $userIdMsg = str_replace("%c", CurrentUserID(), $Language->phrase("UnAuthorizedUserID"));
                $userIdMsg = str_replace("%u", $this->id->CurrentValue, $userIdMsg);
                $this->setFailureMessage($userIdMsg);
                return false;
            }
        }
        $conn = $this->getConnection();

        // Begin transaction
        if ($this->getCurrentDetailTable() != "") {
            $conn->beginTransaction();
        }

        // Load db values from rsold
        $this->loadDbValues($rsold);
        if ($rsold) {
        }
        $rsnew = [];

        // federationId
        $this->federationId->setDbValueDef($rsnew, $this->federationId->CurrentValue, null, false);

        // masterSchoolId
        $this->masterSchoolId->setDbValueDef($rsnew, $this->masterSchoolId->CurrentValue, null, false);

        // school
        $this->school->setDbValueDef($rsnew, $this->school->CurrentValue, null, false);

        // countryId
        $this->countryId->setDbValueDef($rsnew, $this->countryId->CurrentValue, null, false);

        // UFId
        $this->UFId->setDbValueDef($rsnew, $this->UFId->CurrentValue, null, false);

        // cityId
        $this->cityId->setDbValueDef($rsnew, $this->cityId->CurrentValue, null, false);

        // neighborhood
        $this->neighborhood->setDbValueDef($rsnew, $this->neighborhood->CurrentValue, null, false);

        // address
        $this->address->setDbValueDef($rsnew, $this->address->CurrentValue, null, false);

        // zipcode
        $this->zipcode->setDbValueDef($rsnew, $this->zipcode->CurrentValue, null, false);

        // website
        $this->website->setDbValueDef($rsnew, $this->website->CurrentValue, null, false);

        // email
        $this->_email->setDbValueDef($rsnew, $this->_email->CurrentValue, null, false);

        // phone
        $this->phone->setDbValueDef($rsnew, $this->phone->CurrentValue, null, false);

        // celphone
        $this->celphone->setDbValueDef($rsnew, $this->celphone->CurrentValue, null, false);

        // logo
        $this->logo->setDbValueDef($rsnew, $this->logo->CurrentValue, null, false);

        // openingDate
        $this->openingDate->setDbValueDef($rsnew, UnFormatDateTime($this->openingDate->CurrentValue, 0), null, false);

        // federationRegister
        $this->federationRegister->setDbValueDef($rsnew, $this->federationRegister->CurrentValue, null, false);

        // createUserId
        $this->createUserId->setDbValueDef($rsnew, $this->createUserId->CurrentValue, null, false);

        // createDate
        $this->createDate->setDbValueDef($rsnew, UnFormatDateTime($this->createDate->CurrentValue, 0), null, false);

        // typeId
        $this->typeId->setDbValueDef($rsnew, $this->typeId->CurrentValue, null, false);

        // owner
        $this->owner->setDbValueDef($rsnew, $this->owner->CurrentValue, null, false);

        // identityNumber
        $this->identityNumber->setDbValueDef($rsnew, $this->identityNumber->CurrentValue, null, false);

        // birthDateOwner
        $this->birthDateOwner->setDbValueDef($rsnew, UnFormatDateTime($this->birthDateOwner->CurrentValue, 0), null, false);

        // ownerCountryId
        $this->ownerCountryId->setDbValueDef($rsnew, $this->ownerCountryId->CurrentValue, null, false);

        // ownerStateId
        $this->ownerStateId->setDbValueDef($rsnew, $this->ownerStateId->CurrentValue, null, false);

        // ownCityId
        $this->ownCityId->setDbValueDef($rsnew, $this->ownCityId->CurrentValue, null, false);

        // ownerTelephone
        $this->ownerTelephone->setDbValueDef($rsnew, $this->ownerTelephone->CurrentValue, null, false);

        // ownerTelephoneWork
        $this->ownerTelephoneWork->setDbValueDef($rsnew, $this->ownerTelephoneWork->CurrentValue, null, false);

        // ownerProfession
        $this->ownerProfession->setDbValueDef($rsnew, $this->ownerProfession->CurrentValue, null, false);

        // employer
        $this->employer->setDbValueDef($rsnew, $this->employer->CurrentValue, null, false);

        // ownerGraduation
        $this->ownerGraduation->setDbValueDef($rsnew, $this->ownerGraduation->CurrentValue, null, false);

        // ownerGraduationLocation
        $this->ownerGraduationLocation->setDbValueDef($rsnew, $this->ownerGraduationLocation->CurrentValue, null, false);

        // ownerGraduationObs
        $this->ownerGraduationObs->setDbValueDef($rsnew, $this->ownerGraduationObs->CurrentValue, null, false);

        // ownerMaritalStatus
        $this->ownerMaritalStatus->setDbValueDef($rsnew, $this->ownerMaritalStatus->CurrentValue, null, false);

        // ownerSpouseName
        $this->ownerSpouseName->setDbValueDef($rsnew, $this->ownerSpouseName->CurrentValue, null, false);

        // ownerSpouseProfession
        $this->ownerSpouseProfession->setDbValueDef($rsnew, $this->ownerSpouseProfession->CurrentValue, null, false);

        // propertySituation
        $this->propertySituation->setDbValueDef($rsnew, $this->propertySituation->CurrentValue, null, false);

        // numberOfStudentsInBeginnig
        $this->numberOfStudentsInBeginnig->setDbValueDef($rsnew, $this->numberOfStudentsInBeginnig->CurrentValue, null, false);

        // ownerAbout
        $this->ownerAbout->setDbValueDef($rsnew, $this->ownerAbout->CurrentValue, null, false);

        // pdfLicense
        $this->pdfLicense->setDbValueDef($rsnew, $this->pdfLicense->CurrentValue, null, false);

        // applicationId
        $this->applicationId->setDbValueDef($rsnew, $this->applicationId->CurrentValue, null, false);

        // isheadquarter
        $tmpBool = $this->isheadquarter->CurrentValue;
        if ($tmpBool != "1" && $tmpBool != "0") {
            $tmpBool = !empty($tmpBool) ? "1" : "0";
        }
        $this->isheadquarter->setDbValueDef($rsnew, $tmpBool, null, false);

        // id
        if (!$Security->isAdmin() && $Security->isLoggedIn()) { // Non system admin
            $rsnew['id'] = CurrentUserID();
        }

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        $addRow = false;
        if ($insertRow) {
            try {
                $addRow = $this->insert($rsnew);
            } catch (\Exception $e) {
                $this->setFailureMessage($e->getMessage());
            }
            if ($addRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }

        // Add detail records
        if ($addRow) {
            $detailTblVar = explode(",", $this->getCurrentDetailTable());
            $detailPage = Container("SchoolUsersGrid");
            if (in_array("school_users", $detailTblVar) && $detailPage->DetailAdd) {
                $detailPage->schoolId->setSessionValue($this->id->CurrentValue); // Set master key
                $Security->loadCurrentUserLevel($this->ProjectID . "school_users"); // Load user level of detail table
                $addRow = $detailPage->gridInsert();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
                if (!$addRow) {
                $detailPage->schoolId->setSessionValue(""); // Clear master key if insert failed
                }
            }
            $detailPage = Container("SchoolMemberGrid");
            if (in_array("school_member", $detailTblVar) && $detailPage->DetailAdd) {
                $detailPage->schoolId->setSessionValue($this->id->CurrentValue); // Set master key
                $Security->loadCurrentUserLevel($this->ProjectID . "school_member"); // Load user level of detail table
                $addRow = $detailPage->gridInsert();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
                if (!$addRow) {
                $detailPage->schoolId->setSessionValue(""); // Clear master key if insert failed
                }
            }
        }

        // Commit/Rollback transaction
        if ($this->getCurrentDetailTable() != "") {
            if ($addRow) {
                $conn->commit(); // Commit transaction
            } else {
                $conn->rollback(); // Rollback transaction
            }
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Clean upload path if any
        if ($addRow) {
        }

        // Write JSON for API request
        if (IsApi() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            WriteJson(["success" => true, $this->TableVar => $row]);
        }
        return $addRow;
    }

    // Show link optionally based on User ID
    protected function showOptionLink($id = "")
    {
        global $Security;
        if ($Security->isLoggedIn() && !$Security->isAdmin() && !$this->userIDAllow($id)) {
            return $Security->isValidUserID($this->id->CurrentValue);
        }
        return true;
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        $validMaster = false;
        // Get the keys for master table
        if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                $validMaster = true;
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "fed_applicationschool") {
                $validMaster = true;
                $masterTbl = Container("fed_applicationschool");
                if (($parm = Get("fk_id", Get("applicationId"))) !== null) {
                    $masterTbl->id->setQueryStringValue($parm);
                    $this->applicationId->setQueryStringValue($masterTbl->id->QueryStringValue);
                    $this->applicationId->setSessionValue($this->applicationId->QueryStringValue);
                    if (!is_numeric($masterTbl->id->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        } elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                    $validMaster = true;
                    $this->DbMasterFilter = "";
                    $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "fed_applicationschool") {
                $validMaster = true;
                $masterTbl = Container("fed_applicationschool");
                if (($parm = Post("fk_id", Post("applicationId"))) !== null) {
                    $masterTbl->id->setFormValue($parm);
                    $this->applicationId->setFormValue($masterTbl->id->FormValue);
                    $this->applicationId->setSessionValue($this->applicationId->FormValue);
                    if (!is_numeric($masterTbl->id->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        }
        if ($validMaster) {
            // Save current master table
            $this->setCurrentMasterTable($masterTblVar);

            // Reset start record counter (new master key)
            if (!$this->isAddOrEdit()) {
                $this->StartRecord = 1;
                $this->setStartRecordNumber($this->StartRecord);
            }

            // Clear previous master key from Session
            if ($masterTblVar != "fed_applicationschool") {
                if ($this->applicationId->CurrentValue == "") {
                    $this->applicationId->setSessionValue("");
                }
            }
        }
        $this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
        $this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
    }

    // Set up detail parms based on QueryString
    protected function setupDetailParms()
    {
        // Get the keys for master table
        $detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
        if ($detailTblVar !== null) {
            $this->setCurrentDetailTable($detailTblVar);
        } else {
            $detailTblVar = $this->getCurrentDetailTable();
        }
        if ($detailTblVar != "") {
            $detailTblVar = explode(",", $detailTblVar);
            if (in_array("school_users", $detailTblVar)) {
                $detailPageObj = Container("SchoolUsersGrid");
                if ($detailPageObj->DetailAdd) {
                    if ($this->CopyRecord) {
                        $detailPageObj->CurrentMode = "copy";
                    } else {
                        $detailPageObj->CurrentMode = "add";
                    }
                    $detailPageObj->CurrentAction = "gridadd";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->schoolId->IsDetailKey = true;
                    $detailPageObj->schoolId->CurrentValue = $this->id->CurrentValue;
                    $detailPageObj->schoolId->setSessionValue($detailPageObj->schoolId->CurrentValue);
                }
            }
            if (in_array("school_member", $detailTblVar)) {
                $detailPageObj = Container("SchoolMemberGrid");
                if ($detailPageObj->DetailAdd) {
                    if ($this->CopyRecord) {
                        $detailPageObj->CurrentMode = "copy";
                    } else {
                        $detailPageObj->CurrentMode = "add";
                    }
                    $detailPageObj->CurrentAction = "gridadd";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->schoolId->IsDetailKey = true;
                    $detailPageObj->schoolId->CurrentValue = $this->id->CurrentValue;
                    $detailPageObj->schoolId->setSessionValue($detailPageObj->schoolId->CurrentValue);
                }
            }
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("FedSchoolList"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Set up detail pages
    protected function setupDetailPages()
    {
        $pages = new SubPages();
        $pages->Style = "tabs";
        $pages->add('school_users');
        $pages->add('school_member');
        $this->DetailPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_federationId":
                    break;
                case "x_masterSchoolId":
                    $lookupFilter = function () {
                        return "`typeId`=1";
                    };
                    $lookupFilter = $lookupFilter->bindTo($this);
                    break;
                case "x_countryId":
                    break;
                case "x_UFId":
                    break;
                case "x_cityId":
                    break;
                case "x_isheadquarter":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll(\PDO::FETCH_BOTH);
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row);
                    $ar[strval($row[0])] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in CustomError
        return true;
    }
}
