<?php

namespace PHPMaker2021\school;

use Doctrine\DBAL\ParameterType;

/**
 * Table class for view_test_aproveds
 */
class ViewTestAproveds extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Export
    public $ExportDoc;

    // Fields
    public $id;
    public $memberId;
    public $testId;
    public $rankId;
    public $nextRankId;
    public $testPaid;
    public $memberAge;
    public $obs;
    public $renew;
    public $schoolId;
    public $result;
    public $createUseriD;
    public $createDate;
    public $testNominated;
    public $memberDOB;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        global $Language, $CurrentLanguage;
        parent::__construct();

        // Language object
        $Language = Container("language");
        $this->TableVar = 'view_test_aproveds';
        $this->TableName = 'view_test_aproveds';
        $this->TableType = 'VIEW';

        // Update Table
        $this->UpdateTable = "`view_test_aproveds`";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = true; // Allow detail add
        $this->DetailEdit = true; // Allow detail edit
        $this->DetailView = true; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this->TableVar);

        // id
        $this->id = new DbField('view_test_aproveds', 'view_test_aproveds', 'x_id', 'id', '`id`', '`id`', 3, 11, -1, false, '`id`', false, false, false, 'FORMATTED TEXT', 'NO');
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Sortable = true; // Allow sort
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->id->Param, "CustomMsg");
        $this->Fields['id'] = &$this->id;

        // memberId
        $this->memberId = new DbField('view_test_aproveds', 'view_test_aproveds', 'x_memberId', 'memberId', '`memberId`', '`memberId`', 3, 11, -1, false, '`memberId`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->memberId->Sortable = true; // Allow sort
        switch ($CurrentLanguage) {
            case "en":
                $this->memberId->Lookup = new Lookup('memberId', 'school_member', false, 'id', ["name","lastName","",""], [], [], [], [], [], [], '', '');
                break;
            case "pt-br":
                $this->memberId->Lookup = new Lookup('memberId', 'school_member', false, 'id', ["name","lastName","",""], [], [], [], [], [], [], '', '');
                break;
            case "es":
                $this->memberId->Lookup = new Lookup('memberId', 'school_member', false, 'id', ["name","lastName","",""], [], [], [], [], [], [], '', '');
                break;
            default:
                $this->memberId->Lookup = new Lookup('memberId', 'school_member', false, 'id', ["name","lastName","",""], [], [], [], [], [], [], '', '');
                break;
        }
        $this->memberId->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->memberId->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->memberId->Param, "CustomMsg");
        $this->Fields['memberId'] = &$this->memberId;

        // testId
        $this->testId = new DbField('view_test_aproveds', 'view_test_aproveds', 'x_testId', 'testId', '`testId`', '`testId`', 3, 11, -1, false, '`testId`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->testId->IsForeignKey = true; // Foreign key field
        $this->testId->Sortable = true; // Allow sort
        switch ($CurrentLanguage) {
            case "en":
                $this->testId->Lookup = new Lookup('testId', 'tes_test', false, 'id', ["description","testCity","testDate","testTime"], [], [], [], [], [], [], '', '');
                break;
            case "pt-br":
                $this->testId->Lookup = new Lookup('testId', 'tes_test', false, 'id', ["description","testCity","testDate","testTime"], [], [], [], [], [], [], '', '');
                break;
            case "es":
                $this->testId->Lookup = new Lookup('testId', 'tes_test', false, 'id', ["description","testCity","testDate","testTime"], [], [], [], [], [], [], '', '');
                break;
            default:
                $this->testId->Lookup = new Lookup('testId', 'tes_test', false, 'id', ["description","testCity","testDate","testTime"], [], [], [], [], [], [], '', '');
                break;
        }
        $this->testId->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->testId->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->testId->Param, "CustomMsg");
        $this->Fields['testId'] = &$this->testId;

        // rankId
        $this->rankId = new DbField('view_test_aproveds', 'view_test_aproveds', 'x_rankId', 'rankId', '`rankId`', '`rankId`', 3, 11, -1, false, '`rankId`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->rankId->Sortable = true; // Allow sort
        $this->rankId->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->rankId->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->rankId->Lookup = new Lookup('rankId', 'fed_rank', false, 'id', ["rankBR","","",""], [], [], [], [], [], [], '', '');
                break;
            case "pt-br":
                $this->rankId->Lookup = new Lookup('rankId', 'fed_rank', false, 'id', ["rankBR","","",""], [], [], [], [], [], [], '', '');
                break;
            case "es":
                $this->rankId->Lookup = new Lookup('rankId', 'fed_rank', false, 'id', ["rankBR","","",""], [], [], [], [], [], [], '', '');
                break;
            default:
                $this->rankId->Lookup = new Lookup('rankId', 'fed_rank', false, 'id', ["rankBR","","",""], [], [], [], [], [], [], '', '');
                break;
        }
        $this->rankId->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->rankId->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->rankId->Param, "CustomMsg");
        $this->Fields['rankId'] = &$this->rankId;

        // nextRankId
        $this->nextRankId = new DbField('view_test_aproveds', 'view_test_aproveds', 'x_nextRankId', 'nextRankId', '`nextRankId`', '`nextRankId`', 3, 11, -1, false, '`nextRankId`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->nextRankId->Sortable = true; // Allow sort
        $this->nextRankId->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->nextRankId->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->nextRankId->Lookup = new Lookup('nextRankId', 'fed_rank', false, 'id', ["rankBR","","",""], [], [], [], [], [], [], '', '');
                break;
            case "pt-br":
                $this->nextRankId->Lookup = new Lookup('nextRankId', 'fed_rank', false, 'id', ["rankBR","","",""], [], [], [], [], [], [], '', '');
                break;
            case "es":
                $this->nextRankId->Lookup = new Lookup('nextRankId', 'fed_rank', false, 'id', ["rankBR","","",""], [], [], [], [], [], [], '', '');
                break;
            default:
                $this->nextRankId->Lookup = new Lookup('nextRankId', 'fed_rank', false, 'id', ["rankBR","","",""], [], [], [], [], [], [], '', '');
                break;
        }
        $this->nextRankId->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->nextRankId->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->nextRankId->Param, "CustomMsg");
        $this->Fields['nextRankId'] = &$this->nextRankId;

        // testPaid
        $this->testPaid = new DbField('view_test_aproveds', 'view_test_aproveds', 'x_testPaid', 'testPaid', '`testPaid`', '`testPaid`', 16, 1, -1, false, '`testPaid`', false, false, false, 'FORMATTED TEXT', 'CHECKBOX');
        $this->testPaid->Sortable = true; // Allow sort
        $this->testPaid->DataType = DATATYPE_BOOLEAN;
        switch ($CurrentLanguage) {
            case "en":
                $this->testPaid->Lookup = new Lookup('testPaid', 'view_test_aproveds', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
            case "pt-br":
                $this->testPaid->Lookup = new Lookup('testPaid', 'view_test_aproveds', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
            case "es":
                $this->testPaid->Lookup = new Lookup('testPaid', 'view_test_aproveds', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
            default:
                $this->testPaid->Lookup = new Lookup('testPaid', 'view_test_aproveds', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
        }
        $this->testPaid->OptionCount = 2;
        $this->testPaid->DefaultErrorMessage = $Language->phrase("IncorrectField");
        $this->testPaid->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->testPaid->Param, "CustomMsg");
        $this->Fields['testPaid'] = &$this->testPaid;

        // memberAge
        $this->memberAge = new DbField('view_test_aproveds', 'view_test_aproveds', 'x_memberAge', 'memberAge', '`memberAge`', '`memberAge`', 3, 11, -1, false, '`memberAge`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->memberAge->Sortable = true; // Allow sort
        $this->memberAge->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->memberAge->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->memberAge->Param, "CustomMsg");
        $this->Fields['memberAge'] = &$this->memberAge;

        // obs
        $this->obs = new DbField('view_test_aproveds', 'view_test_aproveds', 'x_obs', 'obs', '`obs`', '`obs`', 201, 65535, -1, false, '`obs`', false, false, false, 'FORMATTED TEXT', 'TEXTAREA');
        $this->obs->Sortable = true; // Allow sort
        $this->obs->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->obs->Param, "CustomMsg");
        $this->Fields['obs'] = &$this->obs;

        // renew
        $this->renew = new DbField('view_test_aproveds', 'view_test_aproveds', 'x_renew', 'renew', '`renew`', '`renew`', 16, 1, -1, false, '`renew`', false, false, false, 'FORMATTED TEXT', 'CHECKBOX');
        $this->renew->Sortable = true; // Allow sort
        $this->renew->DataType = DATATYPE_BOOLEAN;
        switch ($CurrentLanguage) {
            case "en":
                $this->renew->Lookup = new Lookup('renew', 'view_test_aproveds', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
            case "pt-br":
                $this->renew->Lookup = new Lookup('renew', 'view_test_aproveds', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
            case "es":
                $this->renew->Lookup = new Lookup('renew', 'view_test_aproveds', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
            default:
                $this->renew->Lookup = new Lookup('renew', 'view_test_aproveds', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
        }
        $this->renew->OptionCount = 2;
        $this->renew->DefaultErrorMessage = $Language->phrase("IncorrectField");
        $this->renew->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->renew->Param, "CustomMsg");
        $this->Fields['renew'] = &$this->renew;

        // schoolId
        $this->schoolId = new DbField('view_test_aproveds', 'view_test_aproveds', 'x_schoolId', 'schoolId', '`schoolId`', '`schoolId`', 3, 11, -1, false, '`schoolId`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->schoolId->Sortable = true; // Allow sort
        switch ($CurrentLanguage) {
            case "en":
                $this->schoolId->Lookup = new Lookup('schoolId', 'fed_school', false, 'id', ["school","countryId","cityId",""], [], [], [], [], [], [], '', '');
                break;
            case "pt-br":
                $this->schoolId->Lookup = new Lookup('schoolId', 'fed_school', false, 'id', ["school","countryId","cityId",""], [], [], [], [], [], [], '', '');
                break;
            case "es":
                $this->schoolId->Lookup = new Lookup('schoolId', 'fed_school', false, 'id', ["school","countryId","cityId",""], [], [], [], [], [], [], '', '');
                break;
            default:
                $this->schoolId->Lookup = new Lookup('schoolId', 'fed_school', false, 'id', ["school","countryId","cityId",""], [], [], [], [], [], [], '', '');
                break;
        }
        $this->schoolId->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->schoolId->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->schoolId->Param, "CustomMsg");
        $this->Fields['schoolId'] = &$this->schoolId;

        // result
        $this->result = new DbField('view_test_aproveds', 'view_test_aproveds', 'x_result', 'result', '`result`', '`result`', 16, 1, -1, false, '`result`', false, false, false, 'FORMATTED TEXT', 'CHECKBOX');
        $this->result->Sortable = true; // Allow sort
        $this->result->DataType = DATATYPE_BOOLEAN;
        switch ($CurrentLanguage) {
            case "en":
                $this->result->Lookup = new Lookup('result', 'view_test_aproveds', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
            case "pt-br":
                $this->result->Lookup = new Lookup('result', 'view_test_aproveds', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
            case "es":
                $this->result->Lookup = new Lookup('result', 'view_test_aproveds', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
            default:
                $this->result->Lookup = new Lookup('result', 'view_test_aproveds', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
        }
        $this->result->OptionCount = 2;
        $this->result->DefaultErrorMessage = $Language->phrase("IncorrectField");
        $this->result->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->result->Param, "CustomMsg");
        $this->Fields['result'] = &$this->result;

        // createUseriD
        $this->createUseriD = new DbField('view_test_aproveds', 'view_test_aproveds', 'x_createUseriD', 'createUseriD', '`createUseriD`', '`createUseriD`', 3, 11, -1, false, '`createUseriD`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->createUseriD->Sortable = true; // Allow sort
        switch ($CurrentLanguage) {
            case "en":
                $this->createUseriD->Lookup = new Lookup('createUseriD', 'school_member', false, 'id', ["name","lastName","",""], [], [], [], [], [], [], '', '');
                break;
            case "pt-br":
                $this->createUseriD->Lookup = new Lookup('createUseriD', 'school_member', false, 'id', ["name","lastName","",""], [], [], [], [], [], [], '', '');
                break;
            case "es":
                $this->createUseriD->Lookup = new Lookup('createUseriD', 'school_member', false, 'id', ["name","lastName","",""], [], [], [], [], [], [], '', '');
                break;
            default:
                $this->createUseriD->Lookup = new Lookup('createUseriD', 'school_member', false, 'id', ["name","lastName","",""], [], [], [], [], [], [], '', '');
                break;
        }
        $this->createUseriD->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->createUseriD->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->createUseriD->Param, "CustomMsg");
        $this->Fields['createUseriD'] = &$this->createUseriD;

        // createDate
        $this->createDate = new DbField('view_test_aproveds', 'view_test_aproveds', 'x_createDate', 'createDate', '`createDate`', CastDateFieldForLike("`createDate`", 0, "DB"), 133, 10, 0, false, '`createDate`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->createDate->Sortable = true; // Allow sort
        $this->createDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->createDate->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->createDate->Param, "CustomMsg");
        $this->Fields['createDate'] = &$this->createDate;

        // testNominated
        $this->testNominated = new DbField('view_test_aproveds', 'view_test_aproveds', 'x_testNominated', 'testNominated', '`testNominated`', '`testNominated`', 16, 1, -1, false, '`testNominated`', false, false, false, 'FORMATTED TEXT', 'CHECKBOX');
        $this->testNominated->Sortable = true; // Allow sort
        $this->testNominated->DataType = DATATYPE_BOOLEAN;
        switch ($CurrentLanguage) {
            case "en":
                $this->testNominated->Lookup = new Lookup('testNominated', 'view_test_aproveds', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
            case "pt-br":
                $this->testNominated->Lookup = new Lookup('testNominated', 'view_test_aproveds', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
            case "es":
                $this->testNominated->Lookup = new Lookup('testNominated', 'view_test_aproveds', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
            default:
                $this->testNominated->Lookup = new Lookup('testNominated', 'view_test_aproveds', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
        }
        $this->testNominated->OptionCount = 2;
        $this->testNominated->DefaultErrorMessage = $Language->phrase("IncorrectField");
        $this->testNominated->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->testNominated->Param, "CustomMsg");
        $this->Fields['testNominated'] = &$this->testNominated;

        // memberDOB
        $this->memberDOB = new DbField('view_test_aproveds', 'view_test_aproveds', 'x_memberDOB', 'memberDOB', '`memberDOB`', CastDateFieldForLike("`memberDOB`", 0, "DB"), 133, 10, 0, false, '`memberDOB`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->memberDOB->Sortable = true; // Allow sort
        $this->memberDOB->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->memberDOB->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->memberDOB->Param, "CustomMsg");
        $this->Fields['memberDOB'] = &$this->memberDOB;
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $fld->setSort($curSort);
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        } else {
            $fld->setSort("");
        }
    }

    // Current master table name
    public function getCurrentMasterTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE"));
    }

    public function setCurrentMasterTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")] = $v;
    }

    // Session master WHERE clause
    public function getMasterFilter()
    {
        // Master filter
        $masterFilter = "";
        if ($this->getCurrentMasterTable() == "tes_test") {
            if ($this->testId->getSessionValue() != "") {
                $masterFilter .= "" . GetForeignKeySql("`id`", $this->testId->getSessionValue(), DATATYPE_NUMBER, "DB");
            } else {
                return "";
            }
        }
        return $masterFilter;
    }

    // Session detail WHERE clause
    public function getDetailFilter()
    {
        // Detail filter
        $detailFilter = "";
        if ($this->getCurrentMasterTable() == "tes_test") {
            if ($this->testId->getSessionValue() != "") {
                $detailFilter .= "" . GetForeignKeySql("`testId`", $this->testId->getSessionValue(), DATATYPE_NUMBER, "DB");
            } else {
                return "";
            }
        }
        return $detailFilter;
    }

    // Master filter
    public function sqlMasterFilter_tes_test()
    {
        return "`id`=@id@";
    }
    // Detail filter
    public function sqlDetailFilter_tes_test()
    {
        return "`testId`=@testId@";
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "`view_test_aproveds`";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : $this->DefaultSort;
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter)
    {
        global $Security;
        // Add User ID filter
        if ($Security->currentUserID() != "" && !$Security->isAdmin()) { // Non system admin
            if ($this->getCurrentMasterTable() == "tes_test" || $this->getCurrentMasterTable() == "") {
                $filter = $this->addDetailUserIDFilter($filter, "tes_test"); // Add detail User ID filter
            }
        }
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof \Doctrine\DBAL\Query\QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $rs = $conn->executeQuery($sqlwrk);
        $cnt = $rs->fetchColumn();
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        )->getSQL();
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    protected function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        $success = $this->insertSql($rs)->execute();
        if ($success) {
            // Get insert id if necessary
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    protected function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        $success = $this->updateSql($rs, $where, $curfilter)->execute();
        $success = ($success > 0) ? $success : true;
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    protected function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            $success = $this->deleteSql($rs, $where, $curfilter)->execute();
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->memberId->DbValue = $row['memberId'];
        $this->testId->DbValue = $row['testId'];
        $this->rankId->DbValue = $row['rankId'];
        $this->nextRankId->DbValue = $row['nextRankId'];
        $this->testPaid->DbValue = $row['testPaid'];
        $this->memberAge->DbValue = $row['memberAge'];
        $this->obs->DbValue = $row['obs'];
        $this->renew->DbValue = $row['renew'];
        $this->schoolId->DbValue = $row['schoolId'];
        $this->result->DbValue = $row['result'];
        $this->createUseriD->DbValue = $row['createUseriD'];
        $this->createDate->DbValue = $row['createDate'];
        $this->testNominated->DbValue = $row['testNominated'];
        $this->memberDOB->DbValue = $row['memberDOB'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = $this->id->OldValue !== null ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("ViewTestAprovedsList");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "ViewTestAprovedsView") {
            return $Language->phrase("View");
        } elseif ($pageName == "ViewTestAprovedsEdit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "ViewTestAprovedsAdd") {
            return $Language->phrase("Add");
        } else {
            return "";
        }
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "ViewTestAprovedsView";
            case Config("API_ADD_ACTION"):
                return "ViewTestAprovedsAdd";
            case Config("API_EDIT_ACTION"):
                return "ViewTestAprovedsEdit";
            case Config("API_DELETE_ACTION"):
                return "ViewTestAprovedsDelete";
            case Config("API_LIST_ACTION"):
                return "ViewTestAprovedsList";
            default:
                return "";
        }
    }

    // List URL
    public function getListUrl()
    {
        return "ViewTestAprovedsList";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("ViewTestAprovedsView", $this->getUrlParm($parm));
        } else {
            $url = $this->keyUrl("ViewTestAprovedsView", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "ViewTestAprovedsAdd?" . $this->getUrlParm($parm);
        } else {
            $url = "ViewTestAprovedsAdd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("ViewTestAprovedsEdit", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("ViewTestAprovedsAdd", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        return $this->keyUrl("ViewTestAprovedsDelete", $this->getUrlParm());
    }

    // Add master url
    public function addMasterUrl($url)
    {
        if ($this->getCurrentMasterTable() == "tes_test" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
            $url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
            $url .= "&" . GetForeignKeyUrl("fk_id", $this->testId->CurrentValue ?? $this->testId->getSessionValue());
        }
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . rawurlencode($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderSort($fld)
    {
        $classId = $fld->TableVar . "_" . $fld->Param;
        $scriptId = str_replace("%id%", $classId, "tpc_%id%");
        $scriptStart = $this->UseCustomTemplate ? "<template id=\"" . $scriptId . "\">" : "";
        $scriptEnd = $this->UseCustomTemplate ? "</template>" : "";
        $jsSort = " class=\"ew-pointer\" onclick=\"ew.sort(event, '" . $this->sortUrl($fld) . "', 1);\"";
        if ($this->sortUrl($fld) == "") {
            $html = <<<NOSORTHTML
{$scriptStart}<div class="ew-table-header-caption">{$fld->caption()}</div>{$scriptEnd}
NOSORTHTML;
        } else {
            if ($fld->getSort() == "ASC") {
                $sortIcon = '<i class="fas fa-sort-up"></i>';
            } elseif ($fld->getSort() == "DESC") {
                $sortIcon = '<i class="fas fa-sort-down"></i>';
            } else {
                $sortIcon = '';
            }
            $html = <<<SORTHTML
{$scriptStart}<div{$jsSort}><div class="ew-table-header-btn"><span class="ew-table-header-caption">{$fld->caption()}</span><span class="ew-table-header-sort">{$sortIcon}</span></div></div>{$scriptEnd}
SORTHTML;
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort());
            return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif (IsApi() && (($keyValue = Key(0) ?? Route(2)) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }

            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter
    public function &loadRs($filter)
    {
        $sql = $this->getSql($filter); // Set up filter (WHERE Clause)
        $conn = $this->getConnection();
        $stmt = $conn->executeQuery($sql);
        return $stmt;
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->memberId->setDbValue($row['memberId']);
        $this->testId->setDbValue($row['testId']);
        $this->rankId->setDbValue($row['rankId']);
        $this->nextRankId->setDbValue($row['nextRankId']);
        $this->testPaid->setDbValue($row['testPaid']);
        $this->memberAge->setDbValue($row['memberAge']);
        $this->obs->setDbValue($row['obs']);
        $this->renew->setDbValue($row['renew']);
        $this->schoolId->setDbValue($row['schoolId']);
        $this->result->setDbValue($row['result']);
        $this->createUseriD->setDbValue($row['createUseriD']);
        $this->createDate->setDbValue($row['createDate']);
        $this->testNominated->setDbValue($row['testNominated']);
        $this->memberDOB->setDbValue($row['memberDOB']);
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // memberId

        // testId

        // rankId

        // nextRankId

        // testPaid

        // memberAge

        // obs

        // renew

        // schoolId

        // result

        // createUseriD

        // createDate

        // testNominated

        // memberDOB

        // id
        $this->id->ViewValue = $this->id->CurrentValue;
        $this->id->ViewCustomAttributes = "";

        // memberId
        $this->memberId->ViewValue = $this->memberId->CurrentValue;
        $curVal = trim(strval($this->memberId->CurrentValue));
        if ($curVal != "") {
            $this->memberId->ViewValue = $this->memberId->lookupCacheOption($curVal);
            if ($this->memberId->ViewValue === null) { // Lookup from database
                $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->memberId->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->memberId->Lookup->renderViewRow($rswrk[0]);
                    $this->memberId->ViewValue = $this->memberId->displayValue($arwrk);
                } else {
                    $this->memberId->ViewValue = $this->memberId->CurrentValue;
                }
            }
        } else {
            $this->memberId->ViewValue = null;
        }
        $this->memberId->ViewCustomAttributes = "";

        // testId
        $this->testId->ViewValue = $this->testId->CurrentValue;
        $curVal = trim(strval($this->testId->CurrentValue));
        if ($curVal != "") {
            $this->testId->ViewValue = $this->testId->lookupCacheOption($curVal);
            if ($this->testId->ViewValue === null) { // Lookup from database
                $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->testId->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->testId->Lookup->renderViewRow($rswrk[0]);
                    $this->testId->ViewValue = $this->testId->displayValue($arwrk);
                } else {
                    $this->testId->ViewValue = $this->testId->CurrentValue;
                }
            }
        } else {
            $this->testId->ViewValue = null;
        }
        $this->testId->ViewCustomAttributes = "";

        // rankId
        $curVal = trim(strval($this->rankId->CurrentValue));
        if ($curVal != "") {
            $this->rankId->ViewValue = $this->rankId->lookupCacheOption($curVal);
            if ($this->rankId->ViewValue === null) { // Lookup from database
                $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->rankId->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rankId->Lookup->renderViewRow($rswrk[0]);
                    $this->rankId->ViewValue = $this->rankId->displayValue($arwrk);
                } else {
                    $this->rankId->ViewValue = $this->rankId->CurrentValue;
                }
            }
        } else {
            $this->rankId->ViewValue = null;
        }
        $this->rankId->ViewCustomAttributes = "";

        // nextRankId
        $curVal = trim(strval($this->nextRankId->CurrentValue));
        if ($curVal != "") {
            $this->nextRankId->ViewValue = $this->nextRankId->lookupCacheOption($curVal);
            if ($this->nextRankId->ViewValue === null) { // Lookup from database
                $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->nextRankId->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->nextRankId->Lookup->renderViewRow($rswrk[0]);
                    $this->nextRankId->ViewValue = $this->nextRankId->displayValue($arwrk);
                } else {
                    $this->nextRankId->ViewValue = $this->nextRankId->CurrentValue;
                }
            }
        } else {
            $this->nextRankId->ViewValue = null;
        }
        $this->nextRankId->ViewCustomAttributes = "";

        // testPaid
        if (ConvertToBool($this->testPaid->CurrentValue)) {
            $this->testPaid->ViewValue = $this->testPaid->tagCaption(1) != "" ? $this->testPaid->tagCaption(1) : "Yes";
        } else {
            $this->testPaid->ViewValue = $this->testPaid->tagCaption(2) != "" ? $this->testPaid->tagCaption(2) : "No";
        }
        $this->testPaid->ViewCustomAttributes = "";

        // memberAge
        $this->memberAge->ViewValue = $this->memberAge->CurrentValue;
        $this->memberAge->ViewValue = FormatNumber($this->memberAge->ViewValue, 0, -2, -2, -2);
        $this->memberAge->ViewCustomAttributes = "";

        // obs
        $this->obs->ViewValue = $this->obs->CurrentValue;
        $this->obs->ViewCustomAttributes = "";

        // renew
        if (ConvertToBool($this->renew->CurrentValue)) {
            $this->renew->ViewValue = $this->renew->tagCaption(1) != "" ? $this->renew->tagCaption(1) : "Yes";
        } else {
            $this->renew->ViewValue = $this->renew->tagCaption(2) != "" ? $this->renew->tagCaption(2) : "No";
        }
        $this->renew->ViewCustomAttributes = "";

        // schoolId
        $this->schoolId->ViewValue = $this->schoolId->CurrentValue;
        $curVal = trim(strval($this->schoolId->CurrentValue));
        if ($curVal != "") {
            $this->schoolId->ViewValue = $this->schoolId->lookupCacheOption($curVal);
            if ($this->schoolId->ViewValue === null) { // Lookup from database
                $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->schoolId->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->schoolId->Lookup->renderViewRow($rswrk[0]);
                    $this->schoolId->ViewValue = $this->schoolId->displayValue($arwrk);
                } else {
                    $this->schoolId->ViewValue = $this->schoolId->CurrentValue;
                }
            }
        } else {
            $this->schoolId->ViewValue = null;
        }
        $this->schoolId->ViewCustomAttributes = "";

        // result
        if (ConvertToBool($this->result->CurrentValue)) {
            $this->result->ViewValue = $this->result->tagCaption(1) != "" ? $this->result->tagCaption(1) : "Yes";
        } else {
            $this->result->ViewValue = $this->result->tagCaption(2) != "" ? $this->result->tagCaption(2) : "No";
        }
        $this->result->ViewCustomAttributes = "";

        // createUseriD
        $this->createUseriD->ViewValue = $this->createUseriD->CurrentValue;
        $curVal = trim(strval($this->createUseriD->CurrentValue));
        if ($curVal != "") {
            $this->createUseriD->ViewValue = $this->createUseriD->lookupCacheOption($curVal);
            if ($this->createUseriD->ViewValue === null) { // Lookup from database
                $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->createUseriD->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->createUseriD->Lookup->renderViewRow($rswrk[0]);
                    $this->createUseriD->ViewValue = $this->createUseriD->displayValue($arwrk);
                } else {
                    $this->createUseriD->ViewValue = $this->createUseriD->CurrentValue;
                }
            }
        } else {
            $this->createUseriD->ViewValue = null;
        }
        $this->createUseriD->ViewCustomAttributes = "";

        // createDate
        $this->createDate->ViewValue = $this->createDate->CurrentValue;
        $this->createDate->ViewValue = FormatDateTime($this->createDate->ViewValue, 0);
        $this->createDate->ViewCustomAttributes = "";

        // testNominated
        if (ConvertToBool($this->testNominated->CurrentValue)) {
            $this->testNominated->ViewValue = $this->testNominated->tagCaption(1) != "" ? $this->testNominated->tagCaption(1) : "Yes";
        } else {
            $this->testNominated->ViewValue = $this->testNominated->tagCaption(2) != "" ? $this->testNominated->tagCaption(2) : "No";
        }
        $this->testNominated->ViewCustomAttributes = "";

        // memberDOB
        $this->memberDOB->ViewValue = $this->memberDOB->CurrentValue;
        $this->memberDOB->ViewValue = FormatDateTime($this->memberDOB->ViewValue, 0);
        $this->memberDOB->ViewCustomAttributes = "";

        // id
        $this->id->LinkCustomAttributes = "";
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // memberId
        $this->memberId->LinkCustomAttributes = "";
        $this->memberId->HrefValue = "";
        $this->memberId->TooltipValue = "";

        // testId
        $this->testId->LinkCustomAttributes = "";
        $this->testId->HrefValue = "";
        $this->testId->TooltipValue = "";

        // rankId
        $this->rankId->LinkCustomAttributes = "";
        $this->rankId->HrefValue = "";
        $this->rankId->TooltipValue = "";

        // nextRankId
        $this->nextRankId->LinkCustomAttributes = "";
        $this->nextRankId->HrefValue = "";
        $this->nextRankId->TooltipValue = "";

        // testPaid
        $this->testPaid->LinkCustomAttributes = "";
        $this->testPaid->HrefValue = "";
        $this->testPaid->TooltipValue = "";

        // memberAge
        $this->memberAge->LinkCustomAttributes = "";
        $this->memberAge->HrefValue = "";
        $this->memberAge->TooltipValue = "";

        // obs
        $this->obs->LinkCustomAttributes = "";
        $this->obs->HrefValue = "";
        $this->obs->TooltipValue = "";

        // renew
        $this->renew->LinkCustomAttributes = "";
        $this->renew->HrefValue = "";
        $this->renew->TooltipValue = "";

        // schoolId
        $this->schoolId->LinkCustomAttributes = "";
        $this->schoolId->HrefValue = "";
        $this->schoolId->TooltipValue = "";

        // result
        $this->result->LinkCustomAttributes = "";
        $this->result->HrefValue = "";
        $this->result->TooltipValue = "";

        // createUseriD
        $this->createUseriD->LinkCustomAttributes = "";
        $this->createUseriD->HrefValue = "";
        $this->createUseriD->TooltipValue = "";

        // createDate
        $this->createDate->LinkCustomAttributes = "";
        $this->createDate->HrefValue = "";
        $this->createDate->TooltipValue = "";

        // testNominated
        $this->testNominated->LinkCustomAttributes = "";
        $this->testNominated->HrefValue = "";
        $this->testNominated->TooltipValue = "";

        // memberDOB
        $this->memberDOB->LinkCustomAttributes = "";
        $this->memberDOB->HrefValue = "";
        $this->memberDOB->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->EditAttrs["class"] = "form-control";
        $this->id->EditCustomAttributes = "";
        $this->id->EditValue = $this->id->CurrentValue;
        $this->id->ViewCustomAttributes = "";

        // memberId
        $this->memberId->EditAttrs["class"] = "form-control";
        $this->memberId->EditCustomAttributes = "";
        $this->memberId->EditValue = $this->memberId->CurrentValue;
        $this->memberId->PlaceHolder = RemoveHtml($this->memberId->caption());

        // testId
        $this->testId->EditAttrs["class"] = "form-control";
        $this->testId->EditCustomAttributes = "";
        if ($this->testId->getSessionValue() != "") {
            $this->testId->CurrentValue = GetForeignKeyValue($this->testId->getSessionValue());
            $this->testId->ViewValue = $this->testId->CurrentValue;
            $curVal = trim(strval($this->testId->CurrentValue));
            if ($curVal != "") {
                $this->testId->ViewValue = $this->testId->lookupCacheOption($curVal);
                if ($this->testId->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->testId->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->testId->Lookup->renderViewRow($rswrk[0]);
                        $this->testId->ViewValue = $this->testId->displayValue($arwrk);
                    } else {
                        $this->testId->ViewValue = $this->testId->CurrentValue;
                    }
                }
            } else {
                $this->testId->ViewValue = null;
            }
            $this->testId->ViewCustomAttributes = "";
        } else {
            $this->testId->EditValue = $this->testId->CurrentValue;
            $this->testId->PlaceHolder = RemoveHtml($this->testId->caption());
        }

        // rankId
        $this->rankId->EditAttrs["class"] = "form-control";
        $this->rankId->EditCustomAttributes = "";
        $this->rankId->PlaceHolder = RemoveHtml($this->rankId->caption());

        // nextRankId
        $this->nextRankId->EditAttrs["class"] = "form-control";
        $this->nextRankId->EditCustomAttributes = "";
        $this->nextRankId->PlaceHolder = RemoveHtml($this->nextRankId->caption());

        // testPaid
        $this->testPaid->EditCustomAttributes = "";
        $this->testPaid->EditValue = $this->testPaid->options(false);
        $this->testPaid->PlaceHolder = RemoveHtml($this->testPaid->caption());

        // memberAge
        $this->memberAge->EditAttrs["class"] = "form-control";
        $this->memberAge->EditCustomAttributes = "";
        $this->memberAge->EditValue = $this->memberAge->CurrentValue;
        $this->memberAge->PlaceHolder = RemoveHtml($this->memberAge->caption());

        // obs
        $this->obs->EditAttrs["class"] = "form-control";
        $this->obs->EditCustomAttributes = "";
        $this->obs->EditValue = $this->obs->CurrentValue;
        $this->obs->PlaceHolder = RemoveHtml($this->obs->caption());

        // renew
        $this->renew->EditCustomAttributes = "";
        $this->renew->EditValue = $this->renew->options(false);
        $this->renew->PlaceHolder = RemoveHtml($this->renew->caption());

        // schoolId

        // result
        $this->result->EditCustomAttributes = "";
        $this->result->EditValue = $this->result->options(false);
        $this->result->PlaceHolder = RemoveHtml($this->result->caption());

        // createUseriD

        // createDate

        // testNominated
        $this->testNominated->EditCustomAttributes = "";
        $this->testNominated->EditValue = $this->testNominated->options(false);
        $this->testNominated->PlaceHolder = RemoveHtml($this->testNominated->caption());

        // memberDOB
        $this->memberDOB->EditAttrs["class"] = "form-control";
        $this->memberDOB->EditCustomAttributes = "";
        $this->memberDOB->EditValue = FormatDateTime($this->memberDOB->CurrentValue, 8);
        $this->memberDOB->PlaceHolder = RemoveHtml($this->memberDOB->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->memberId);
                    $doc->exportCaption($this->testId);
                    $doc->exportCaption($this->nextRankId);
                    $doc->exportCaption($this->testPaid);
                    $doc->exportCaption($this->memberAge);
                    $doc->exportCaption($this->obs);
                    $doc->exportCaption($this->renew);
                    $doc->exportCaption($this->schoolId);
                    $doc->exportCaption($this->result);
                    $doc->exportCaption($this->createUseriD);
                    $doc->exportCaption($this->createDate);
                    $doc->exportCaption($this->testNominated);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->memberId);
                    $doc->exportCaption($this->testId);
                    $doc->exportCaption($this->rankId);
                    $doc->exportCaption($this->nextRankId);
                    $doc->exportCaption($this->testPaid);
                    $doc->exportCaption($this->memberAge);
                    $doc->exportCaption($this->renew);
                    $doc->exportCaption($this->schoolId);
                    $doc->exportCaption($this->result);
                    $doc->exportCaption($this->createUseriD);
                    $doc->exportCaption($this->createDate);
                    $doc->exportCaption($this->testNominated);
                    $doc->exportCaption($this->memberDOB);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->memberId);
                        $doc->exportField($this->testId);
                        $doc->exportField($this->nextRankId);
                        $doc->exportField($this->testPaid);
                        $doc->exportField($this->memberAge);
                        $doc->exportField($this->obs);
                        $doc->exportField($this->renew);
                        $doc->exportField($this->schoolId);
                        $doc->exportField($this->result);
                        $doc->exportField($this->createUseriD);
                        $doc->exportField($this->createDate);
                        $doc->exportField($this->testNominated);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->memberId);
                        $doc->exportField($this->testId);
                        $doc->exportField($this->rankId);
                        $doc->exportField($this->nextRankId);
                        $doc->exportField($this->testPaid);
                        $doc->exportField($this->memberAge);
                        $doc->exportField($this->renew);
                        $doc->exportField($this->schoolId);
                        $doc->exportField($this->result);
                        $doc->exportField($this->createUseriD);
                        $doc->exportField($this->createDate);
                        $doc->exportField($this->testNominated);
                        $doc->exportField($this->memberDOB);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($row);
            }
            $recordset->moveNext();
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Add master User ID filter
    public function addMasterUserIDFilter($filter, $currentMasterTable)
    {
        $filterWrk = $filter;
        if ($currentMasterTable == "tes_test") {
            $filterWrk = Container("tes_test")->addUserIDFilter($filterWrk);
        }
        return $filterWrk;
    }

    // Add detail User ID filter
    public function addDetailUserIDFilter($filter, $currentMasterTable)
    {
        $filterWrk = $filter;
        if ($currentMasterTable == "tes_test") {
            $mastertable = Container("tes_test");
            if (!$mastertable->userIdAllow()) {
                $subqueryWrk = $mastertable->getUserIDSubquery($this->testId, $mastertable->id);
                AddFilter($filterWrk, $subqueryWrk);
            }
        }
        return $filterWrk;
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        // No binary fields
        return false;
    }

    // Table level events

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email); var_dump($args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
