<?php

namespace PHPMaker2021\school;

// Set up and run Grid object
$Grid = Container("FedSchoolGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var currentForm, currentPageID;
var ffed_schoolgrid;
loadjs.ready("head", function () {
    var $ = jQuery;
    // Form object
    ffed_schoolgrid = new ew.Form("ffed_schoolgrid", "grid");
    ffed_schoolgrid.formKeyCountName = '<?= $Grid->FormKeyCountName ?>';

    // Add fields
    var currentTable = <?= JsonEncode(GetClientVar("tables", "fed_school")) ?>,
        fields = currentTable.fields;
    if (!ew.vars.tables.fed_school)
        ew.vars.tables.fed_school = currentTable;
    ffed_schoolgrid.addFields([
        ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
        ["masterSchoolId", [fields.masterSchoolId.visible && fields.masterSchoolId.required ? ew.Validators.required(fields.masterSchoolId.caption) : null], fields.masterSchoolId.isInvalid],
        ["school", [fields.school.visible && fields.school.required ? ew.Validators.required(fields.school.caption) : null], fields.school.isInvalid],
        ["countryId", [fields.countryId.visible && fields.countryId.required ? ew.Validators.required(fields.countryId.caption) : null], fields.countryId.isInvalid],
        ["cityId", [fields.cityId.visible && fields.cityId.required ? ew.Validators.required(fields.cityId.caption) : null], fields.cityId.isInvalid],
        ["owner", [fields.owner.visible && fields.owner.required ? ew.Validators.required(fields.owner.caption) : null], fields.owner.isInvalid],
        ["applicationId", [fields.applicationId.visible && fields.applicationId.required ? ew.Validators.required(fields.applicationId.caption) : null, ew.Validators.integer], fields.applicationId.isInvalid],
        ["isheadquarter", [fields.isheadquarter.visible && fields.isheadquarter.required ? ew.Validators.required(fields.isheadquarter.caption) : null], fields.isheadquarter.isInvalid]
    ]);

    // Set invalid fields
    $(function() {
        var f = ffed_schoolgrid,
            fobj = f.getForm(),
            $fobj = $(fobj),
            $k = $fobj.find("#" + f.formKeyCountName), // Get key_count
            rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1,
            startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
        for (var i = startcnt; i <= rowcnt; i++) {
            var rowIndex = ($k[0]) ? String(i) : "";
            f.setInvalid(rowIndex);
        }
    });

    // Validate form
    ffed_schoolgrid.validate = function () {
        if (!this.validateRequired)
            return true; // Ignore validation
        var fobj = this.getForm(),
            $fobj = $(fobj);
        if ($fobj.find("#confirm").val() == "confirm")
            return true;
        var addcnt = 0,
            $k = $fobj.find("#" + this.formKeyCountName), // Get key_count
            rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1,
            startcnt = (rowcnt == 0) ? 0 : 1, // Check rowcnt == 0 => Inline-Add
            gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
        for (var i = startcnt; i <= rowcnt; i++) {
            var rowIndex = ($k[0]) ? String(i) : "";
            $fobj.data("rowindex", rowIndex);
            var checkrow = (gridinsert) ? !this.emptyRow(rowIndex) : true;
            if (checkrow) {
                addcnt++;

            // Validate fields
            if (!this.validateFields(rowIndex))
                return false;

            // Call Form_CustomValidate event
            if (!this.customValidate(fobj)) {
                this.focus();
                return false;
            }
            } // End Grid Add checking
        }
        return true;
    }

    // Check empty row
    ffed_schoolgrid.emptyRow = function (rowIndex) {
        var fobj = this.getForm();
        if (ew.valueChanged(fobj, rowIndex, "masterSchoolId", false))
            return false;
        if (ew.valueChanged(fobj, rowIndex, "school", false))
            return false;
        if (ew.valueChanged(fobj, rowIndex, "countryId", false))
            return false;
        if (ew.valueChanged(fobj, rowIndex, "cityId", false))
            return false;
        if (ew.valueChanged(fobj, rowIndex, "owner", false))
            return false;
        if (ew.valueChanged(fobj, rowIndex, "applicationId", false))
            return false;
        if (ew.valueChanged(fobj, rowIndex, "isheadquarter[]", true))
            return false;
        return true;
    }

    // Form_CustomValidate
    ffed_schoolgrid.customValidate = function(fobj) { // DO NOT CHANGE THIS LINE!
        // Your custom validation code here, return false if invalid.
        return true;
    }

    // Use JavaScript validation or not
    ffed_schoolgrid.validateRequired = <?= Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

    // Dynamic selection lists
    ffed_schoolgrid.lists.masterSchoolId = <?= $Grid->masterSchoolId->toClientList($Grid) ?>;
    ffed_schoolgrid.lists.countryId = <?= $Grid->countryId->toClientList($Grid) ?>;
    ffed_schoolgrid.lists.cityId = <?= $Grid->cityId->toClientList($Grid) ?>;
    ffed_schoolgrid.lists.isheadquarter = <?= $Grid->isheadquarter->toClientList($Grid) ?>;
    loadjs.done("ffed_schoolgrid");
});
</script>
<?php } ?>
<?php
$Grid->renderOtherOptions();
?>
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($Grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> fed_school">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="ffed_schoolgrid" class="ew-form ew-list-form form-inline">
<div id="gmp_fed_school" class="<?= ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<table id="tbl_fed_schoolgrid" class="table ew-table"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = ROWTYPE_HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Grid->id->headerCellClass() ?>"><div id="elh_fed_school_id" class="fed_school_id"><?= $Grid->renderSort($Grid->id) ?></div></th>
<?php } ?>
<?php if ($Grid->masterSchoolId->Visible) { // masterSchoolId ?>
        <th data-name="masterSchoolId" class="<?= $Grid->masterSchoolId->headerCellClass() ?>"><div id="elh_fed_school_masterSchoolId" class="fed_school_masterSchoolId"><?= $Grid->renderSort($Grid->masterSchoolId) ?></div></th>
<?php } ?>
<?php if ($Grid->school->Visible) { // school ?>
        <th data-name="school" class="<?= $Grid->school->headerCellClass() ?>"><div id="elh_fed_school_school" class="fed_school_school"><?= $Grid->renderSort($Grid->school) ?></div></th>
<?php } ?>
<?php if ($Grid->countryId->Visible) { // countryId ?>
        <th data-name="countryId" class="<?= $Grid->countryId->headerCellClass() ?>"><div id="elh_fed_school_countryId" class="fed_school_countryId"><?= $Grid->renderSort($Grid->countryId) ?></div></th>
<?php } ?>
<?php if ($Grid->cityId->Visible) { // cityId ?>
        <th data-name="cityId" class="<?= $Grid->cityId->headerCellClass() ?>"><div id="elh_fed_school_cityId" class="fed_school_cityId"><?= $Grid->renderSort($Grid->cityId) ?></div></th>
<?php } ?>
<?php if ($Grid->owner->Visible) { // owner ?>
        <th data-name="owner" class="<?= $Grid->owner->headerCellClass() ?>"><div id="elh_fed_school_owner" class="fed_school_owner"><?= $Grid->renderSort($Grid->owner) ?></div></th>
<?php } ?>
<?php if ($Grid->applicationId->Visible) { // applicationId ?>
        <th data-name="applicationId" class="<?= $Grid->applicationId->headerCellClass() ?>"><div id="elh_fed_school_applicationId" class="fed_school_applicationId"><?= $Grid->renderSort($Grid->applicationId) ?></div></th>
<?php } ?>
<?php if ($Grid->isheadquarter->Visible) { // isheadquarter ?>
        <th data-name="isheadquarter" class="<?= $Grid->isheadquarter->headerCellClass() ?>"><div id="elh_fed_school_isheadquarter" class="fed_school_isheadquarter"><?= $Grid->renderSort($Grid->isheadquarter) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody>
<?php
$Grid->StartRecord = 1;
$Grid->StopRecord = $Grid->TotalRecords; // Show all records

// Restore number of post back records
if ($CurrentForm && ($Grid->isConfirm() || $Grid->EventCancelled)) {
    $CurrentForm->Index = -1;
    if ($CurrentForm->hasValue($Grid->FormKeyCountName) && ($Grid->isGridAdd() || $Grid->isGridEdit() || $Grid->isConfirm())) {
        $Grid->KeyCount = $CurrentForm->getValue($Grid->FormKeyCountName);
        $Grid->StopRecord = $Grid->StartRecord + $Grid->KeyCount - 1;
    }
}
$Grid->RecordCount = $Grid->StartRecord - 1;
if ($Grid->Recordset && !$Grid->Recordset->EOF) {
    // Nothing to do
} elseif (!$Grid->AllowAddDeleteRow && $Grid->StopRecord == 0) {
    $Grid->StopRecord = $Grid->GridAddRowCount;
}

// Initialize aggregate
$Grid->RowType = ROWTYPE_AGGREGATEINIT;
$Grid->resetAttributes();
$Grid->renderRow();
if ($Grid->isGridAdd())
    $Grid->RowIndex = 0;
if ($Grid->isGridEdit())
    $Grid->RowIndex = 0;
while ($Grid->RecordCount < $Grid->StopRecord) {
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->RowCount++;
        if ($Grid->isGridAdd() || $Grid->isGridEdit() || $Grid->isConfirm()) {
            $Grid->RowIndex++;
            $CurrentForm->Index = $Grid->RowIndex;
            if ($CurrentForm->hasValue($Grid->FormActionName) && ($Grid->isConfirm() || $Grid->EventCancelled)) {
                $Grid->RowAction = strval($CurrentForm->getValue($Grid->FormActionName));
            } elseif ($Grid->isGridAdd()) {
                $Grid->RowAction = "insert";
            } else {
                $Grid->RowAction = "";
            }
        }

        // Set up key count
        $Grid->KeyCount = $Grid->RowIndex;

        // Init row class and style
        $Grid->resetAttributes();
        $Grid->CssClass = "";
        if ($Grid->isGridAdd()) {
            if ($Grid->CurrentMode == "copy") {
                $Grid->loadRowValues($Grid->Recordset); // Load row values
                $Grid->OldKey = $Grid->getKey(true); // Get from CurrentValue
            } else {
                $Grid->loadRowValues(); // Load default values
                $Grid->OldKey = "";
            }
        } else {
            $Grid->loadRowValues($Grid->Recordset); // Load row values
            $Grid->OldKey = $Grid->getKey(true); // Get from CurrentValue
        }
        $Grid->setKey($Grid->OldKey);
        $Grid->RowType = ROWTYPE_VIEW; // Render view
        if ($Grid->isGridAdd()) { // Grid add
            $Grid->RowType = ROWTYPE_ADD; // Render add
        }
        if ($Grid->isGridAdd() && $Grid->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) { // Insert failed
            $Grid->restoreCurrentRowFormValues($Grid->RowIndex); // Restore form values
        }
        if ($Grid->isGridEdit()) { // Grid edit
            if ($Grid->EventCancelled) {
                $Grid->restoreCurrentRowFormValues($Grid->RowIndex); // Restore form values
            }
            if ($Grid->RowAction == "insert") {
                $Grid->RowType = ROWTYPE_ADD; // Render add
            } else {
                $Grid->RowType = ROWTYPE_EDIT; // Render edit
            }
        }
        if ($Grid->isGridEdit() && ($Grid->RowType == ROWTYPE_EDIT || $Grid->RowType == ROWTYPE_ADD) && $Grid->EventCancelled) { // Update failed
            $Grid->restoreCurrentRowFormValues($Grid->RowIndex); // Restore form values
        }
        if ($Grid->RowType == ROWTYPE_EDIT) { // Edit row
            $Grid->EditRowCount++;
        }
        if ($Grid->isConfirm()) { // Confirm row
            $Grid->restoreCurrentRowFormValues($Grid->RowIndex); // Restore form values
        }

        // Set up row id / data-rowindex
        $Grid->RowAttrs->merge(["data-rowindex" => $Grid->RowCount, "id" => "r" . $Grid->RowCount . "_fed_school", "data-rowtype" => $Grid->RowType]);

        // Render row
        $Grid->renderRow();

        // Render list options
        $Grid->renderListOptions();

        // Skip delete row / empty row for confirm page
        if ($Grid->RowAction != "delete" && $Grid->RowAction != "insertdelete" && !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow())) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id" <?= $Grid->id->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_id" class="form-group"></span>
<input type="hidden" data-table="fed_school" data-field="x_id" data-hidden="1" name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_id" class="form-group">
<span<?= $Grid->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->id->getDisplayValue($Grid->id->EditValue))) ?>"></span>
</span>
<input type="hidden" data-table="fed_school" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_id">
<span<?= $Grid->id->viewAttributes() ?>>
<?= $Grid->id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="fed_school" data-field="x_id" data-hidden="1" name="ffed_schoolgrid$x<?= $Grid->RowIndex ?>_id" id="ffed_schoolgrid$x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->FormValue) ?>">
<input type="hidden" data-table="fed_school" data-field="x_id" data-hidden="1" name="ffed_schoolgrid$o<?= $Grid->RowIndex ?>_id" id="ffed_schoolgrid$o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="fed_school" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->masterSchoolId->Visible) { // masterSchoolId ?>
        <td data-name="masterSchoolId" <?= $Grid->masterSchoolId->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_masterSchoolId" class="form-group">
<?php $Grid->masterSchoolId->EditAttrs->prepend("onchange", "ew.updateOptions.call(this);"); ?>
    <select
        id="x<?= $Grid->RowIndex ?>_masterSchoolId"
        name="x<?= $Grid->RowIndex ?>_masterSchoolId"
        class="form-control ew-select<?= $Grid->masterSchoolId->isInvalidClass() ?>"
        data-select2-id="fed_school_x<?= $Grid->RowIndex ?>_masterSchoolId"
        data-table="fed_school"
        data-field="x_masterSchoolId"
        data-value-separator="<?= $Grid->masterSchoolId->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->masterSchoolId->getPlaceHolder()) ?>"
        <?= $Grid->masterSchoolId->editAttributes() ?>>
        <?= $Grid->masterSchoolId->selectOptionListHtml("x{$Grid->RowIndex}_masterSchoolId") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->masterSchoolId->getErrorMessage() ?></div>
<?= $Grid->masterSchoolId->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_masterSchoolId") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='fed_school_x<?= $Grid->RowIndex ?>_masterSchoolId']"),
        options = { name: "x<?= $Grid->RowIndex ?>_masterSchoolId", selectId: "fed_school_x<?= $Grid->RowIndex ?>_masterSchoolId", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.fed_school.fields.masterSchoolId.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
<input type="hidden" data-table="fed_school" data-field="x_masterSchoolId" data-hidden="1" name="o<?= $Grid->RowIndex ?>_masterSchoolId" id="o<?= $Grid->RowIndex ?>_masterSchoolId" value="<?= HtmlEncode($Grid->masterSchoolId->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_masterSchoolId" class="form-group">
<?php $Grid->masterSchoolId->EditAttrs->prepend("onchange", "ew.updateOptions.call(this);"); ?>
    <select
        id="x<?= $Grid->RowIndex ?>_masterSchoolId"
        name="x<?= $Grid->RowIndex ?>_masterSchoolId"
        class="form-control ew-select<?= $Grid->masterSchoolId->isInvalidClass() ?>"
        data-select2-id="fed_school_x<?= $Grid->RowIndex ?>_masterSchoolId"
        data-table="fed_school"
        data-field="x_masterSchoolId"
        data-value-separator="<?= $Grid->masterSchoolId->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->masterSchoolId->getPlaceHolder()) ?>"
        <?= $Grid->masterSchoolId->editAttributes() ?>>
        <?= $Grid->masterSchoolId->selectOptionListHtml("x{$Grid->RowIndex}_masterSchoolId") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->masterSchoolId->getErrorMessage() ?></div>
<?= $Grid->masterSchoolId->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_masterSchoolId") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='fed_school_x<?= $Grid->RowIndex ?>_masterSchoolId']"),
        options = { name: "x<?= $Grid->RowIndex ?>_masterSchoolId", selectId: "fed_school_x<?= $Grid->RowIndex ?>_masterSchoolId", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.fed_school.fields.masterSchoolId.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_masterSchoolId">
<span<?= $Grid->masterSchoolId->viewAttributes() ?>>
<?= $Grid->masterSchoolId->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="fed_school" data-field="x_masterSchoolId" data-hidden="1" name="ffed_schoolgrid$x<?= $Grid->RowIndex ?>_masterSchoolId" id="ffed_schoolgrid$x<?= $Grid->RowIndex ?>_masterSchoolId" value="<?= HtmlEncode($Grid->masterSchoolId->FormValue) ?>">
<input type="hidden" data-table="fed_school" data-field="x_masterSchoolId" data-hidden="1" name="ffed_schoolgrid$o<?= $Grid->RowIndex ?>_masterSchoolId" id="ffed_schoolgrid$o<?= $Grid->RowIndex ?>_masterSchoolId" value="<?= HtmlEncode($Grid->masterSchoolId->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->school->Visible) { // school ?>
        <td data-name="school" <?= $Grid->school->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_school" class="form-group">
<input type="<?= $Grid->school->getInputTextType() ?>" data-table="fed_school" data-field="x_school" name="x<?= $Grid->RowIndex ?>_school" id="x<?= $Grid->RowIndex ?>_school" size="30" maxlength="45" placeholder="<?= HtmlEncode($Grid->school->getPlaceHolder()) ?>" value="<?= $Grid->school->EditValue ?>"<?= $Grid->school->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->school->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="fed_school" data-field="x_school" data-hidden="1" name="o<?= $Grid->RowIndex ?>_school" id="o<?= $Grid->RowIndex ?>_school" value="<?= HtmlEncode($Grid->school->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_school" class="form-group">
<input type="<?= $Grid->school->getInputTextType() ?>" data-table="fed_school" data-field="x_school" name="x<?= $Grid->RowIndex ?>_school" id="x<?= $Grid->RowIndex ?>_school" size="30" maxlength="45" placeholder="<?= HtmlEncode($Grid->school->getPlaceHolder()) ?>" value="<?= $Grid->school->EditValue ?>"<?= $Grid->school->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->school->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_school">
<span<?= $Grid->school->viewAttributes() ?>>
<?= $Grid->school->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="fed_school" data-field="x_school" data-hidden="1" name="ffed_schoolgrid$x<?= $Grid->RowIndex ?>_school" id="ffed_schoolgrid$x<?= $Grid->RowIndex ?>_school" value="<?= HtmlEncode($Grid->school->FormValue) ?>">
<input type="hidden" data-table="fed_school" data-field="x_school" data-hidden="1" name="ffed_schoolgrid$o<?= $Grid->RowIndex ?>_school" id="ffed_schoolgrid$o<?= $Grid->RowIndex ?>_school" value="<?= HtmlEncode($Grid->school->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->countryId->Visible) { // countryId ?>
        <td data-name="countryId" <?= $Grid->countryId->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_countryId" class="form-group">
    <select
        id="x<?= $Grid->RowIndex ?>_countryId"
        name="x<?= $Grid->RowIndex ?>_countryId"
        class="form-control ew-select<?= $Grid->countryId->isInvalidClass() ?>"
        data-select2-id="fed_school_x<?= $Grid->RowIndex ?>_countryId"
        data-table="fed_school"
        data-field="x_countryId"
        data-value-separator="<?= $Grid->countryId->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->countryId->getPlaceHolder()) ?>"
        <?= $Grid->countryId->editAttributes() ?>>
        <?= $Grid->countryId->selectOptionListHtml("x{$Grid->RowIndex}_countryId") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->countryId->getErrorMessage() ?></div>
<?= $Grid->countryId->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_countryId") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='fed_school_x<?= $Grid->RowIndex ?>_countryId']"),
        options = { name: "x<?= $Grid->RowIndex ?>_countryId", selectId: "fed_school_x<?= $Grid->RowIndex ?>_countryId", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.fed_school.fields.countryId.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
<input type="hidden" data-table="fed_school" data-field="x_countryId" data-hidden="1" name="o<?= $Grid->RowIndex ?>_countryId" id="o<?= $Grid->RowIndex ?>_countryId" value="<?= HtmlEncode($Grid->countryId->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_countryId" class="form-group">
    <select
        id="x<?= $Grid->RowIndex ?>_countryId"
        name="x<?= $Grid->RowIndex ?>_countryId"
        class="form-control ew-select<?= $Grid->countryId->isInvalidClass() ?>"
        data-select2-id="fed_school_x<?= $Grid->RowIndex ?>_countryId"
        data-table="fed_school"
        data-field="x_countryId"
        data-value-separator="<?= $Grid->countryId->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->countryId->getPlaceHolder()) ?>"
        <?= $Grid->countryId->editAttributes() ?>>
        <?= $Grid->countryId->selectOptionListHtml("x{$Grid->RowIndex}_countryId") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->countryId->getErrorMessage() ?></div>
<?= $Grid->countryId->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_countryId") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='fed_school_x<?= $Grid->RowIndex ?>_countryId']"),
        options = { name: "x<?= $Grid->RowIndex ?>_countryId", selectId: "fed_school_x<?= $Grid->RowIndex ?>_countryId", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.fed_school.fields.countryId.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_countryId">
<span<?= $Grid->countryId->viewAttributes() ?>>
<?= $Grid->countryId->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="fed_school" data-field="x_countryId" data-hidden="1" name="ffed_schoolgrid$x<?= $Grid->RowIndex ?>_countryId" id="ffed_schoolgrid$x<?= $Grid->RowIndex ?>_countryId" value="<?= HtmlEncode($Grid->countryId->FormValue) ?>">
<input type="hidden" data-table="fed_school" data-field="x_countryId" data-hidden="1" name="ffed_schoolgrid$o<?= $Grid->RowIndex ?>_countryId" id="ffed_schoolgrid$o<?= $Grid->RowIndex ?>_countryId" value="<?= HtmlEncode($Grid->countryId->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->cityId->Visible) { // cityId ?>
        <td data-name="cityId" <?= $Grid->cityId->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_cityId" class="form-group">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_cityId"
        name="x<?= $Grid->RowIndex ?>_cityId"
        class="form-control ew-select<?= $Grid->cityId->isInvalidClass() ?>"
        data-select2-id="fed_school_x<?= $Grid->RowIndex ?>_cityId"
        data-table="fed_school"
        data-field="x_cityId"
        data-value-separator="<?= $Grid->cityId->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->cityId->getPlaceHolder()) ?>"
        <?= $Grid->cityId->editAttributes() ?>>
        <?= $Grid->cityId->selectOptionListHtml("x{$Grid->RowIndex}_cityId") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "conf_city") && !$Grid->cityId->ReadOnly) { ?>
    <div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_cityId" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->cityId->caption() ?>" data-title="<?= $Grid->cityId->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?= $Grid->RowIndex ?>_cityId',url:'<?= GetUrl("ConfCityAddopt") ?>'});"><i class="fas fa-plus ew-icon"></i></button></div>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->cityId->getErrorMessage() ?></div>
<?= $Grid->cityId->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_cityId") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='fed_school_x<?= $Grid->RowIndex ?>_cityId']"),
        options = { name: "x<?= $Grid->RowIndex ?>_cityId", selectId: "fed_school_x<?= $Grid->RowIndex ?>_cityId", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.fed_school.fields.cityId.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
<input type="hidden" data-table="fed_school" data-field="x_cityId" data-hidden="1" name="o<?= $Grid->RowIndex ?>_cityId" id="o<?= $Grid->RowIndex ?>_cityId" value="<?= HtmlEncode($Grid->cityId->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_cityId" class="form-group">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_cityId"
        name="x<?= $Grid->RowIndex ?>_cityId"
        class="form-control ew-select<?= $Grid->cityId->isInvalidClass() ?>"
        data-select2-id="fed_school_x<?= $Grid->RowIndex ?>_cityId"
        data-table="fed_school"
        data-field="x_cityId"
        data-value-separator="<?= $Grid->cityId->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->cityId->getPlaceHolder()) ?>"
        <?= $Grid->cityId->editAttributes() ?>>
        <?= $Grid->cityId->selectOptionListHtml("x{$Grid->RowIndex}_cityId") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "conf_city") && !$Grid->cityId->ReadOnly) { ?>
    <div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_cityId" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->cityId->caption() ?>" data-title="<?= $Grid->cityId->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?= $Grid->RowIndex ?>_cityId',url:'<?= GetUrl("ConfCityAddopt") ?>'});"><i class="fas fa-plus ew-icon"></i></button></div>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->cityId->getErrorMessage() ?></div>
<?= $Grid->cityId->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_cityId") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='fed_school_x<?= $Grid->RowIndex ?>_cityId']"),
        options = { name: "x<?= $Grid->RowIndex ?>_cityId", selectId: "fed_school_x<?= $Grid->RowIndex ?>_cityId", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.fed_school.fields.cityId.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_cityId">
<span<?= $Grid->cityId->viewAttributes() ?>>
<?= $Grid->cityId->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="fed_school" data-field="x_cityId" data-hidden="1" name="ffed_schoolgrid$x<?= $Grid->RowIndex ?>_cityId" id="ffed_schoolgrid$x<?= $Grid->RowIndex ?>_cityId" value="<?= HtmlEncode($Grid->cityId->FormValue) ?>">
<input type="hidden" data-table="fed_school" data-field="x_cityId" data-hidden="1" name="ffed_schoolgrid$o<?= $Grid->RowIndex ?>_cityId" id="ffed_schoolgrid$o<?= $Grid->RowIndex ?>_cityId" value="<?= HtmlEncode($Grid->cityId->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->owner->Visible) { // owner ?>
        <td data-name="owner" <?= $Grid->owner->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_owner" class="form-group">
<input type="<?= $Grid->owner->getInputTextType() ?>" data-table="fed_school" data-field="x_owner" name="x<?= $Grid->RowIndex ?>_owner" id="x<?= $Grid->RowIndex ?>_owner" size="30" maxlength="45" placeholder="<?= HtmlEncode($Grid->owner->getPlaceHolder()) ?>" value="<?= $Grid->owner->EditValue ?>"<?= $Grid->owner->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->owner->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="fed_school" data-field="x_owner" data-hidden="1" name="o<?= $Grid->RowIndex ?>_owner" id="o<?= $Grid->RowIndex ?>_owner" value="<?= HtmlEncode($Grid->owner->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_owner" class="form-group">
<input type="<?= $Grid->owner->getInputTextType() ?>" data-table="fed_school" data-field="x_owner" name="x<?= $Grid->RowIndex ?>_owner" id="x<?= $Grid->RowIndex ?>_owner" size="30" maxlength="45" placeholder="<?= HtmlEncode($Grid->owner->getPlaceHolder()) ?>" value="<?= $Grid->owner->EditValue ?>"<?= $Grid->owner->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->owner->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_owner">
<span<?= $Grid->owner->viewAttributes() ?>>
<?= $Grid->owner->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="fed_school" data-field="x_owner" data-hidden="1" name="ffed_schoolgrid$x<?= $Grid->RowIndex ?>_owner" id="ffed_schoolgrid$x<?= $Grid->RowIndex ?>_owner" value="<?= HtmlEncode($Grid->owner->FormValue) ?>">
<input type="hidden" data-table="fed_school" data-field="x_owner" data-hidden="1" name="ffed_schoolgrid$o<?= $Grid->RowIndex ?>_owner" id="ffed_schoolgrid$o<?= $Grid->RowIndex ?>_owner" value="<?= HtmlEncode($Grid->owner->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->applicationId->Visible) { // applicationId ?>
        <td data-name="applicationId" <?= $Grid->applicationId->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($Grid->applicationId->getSessionValue() != "") { ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_applicationId" class="form-group">
<span<?= $Grid->applicationId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->applicationId->getDisplayValue($Grid->applicationId->ViewValue))) ?>"></span>
</span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_applicationId" name="x<?= $Grid->RowIndex ?>_applicationId" value="<?= HtmlEncode($Grid->applicationId->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_applicationId" class="form-group">
<input type="<?= $Grid->applicationId->getInputTextType() ?>" data-table="fed_school" data-field="x_applicationId" name="x<?= $Grid->RowIndex ?>_applicationId" id="x<?= $Grid->RowIndex ?>_applicationId" size="30" placeholder="<?= HtmlEncode($Grid->applicationId->getPlaceHolder()) ?>" value="<?= $Grid->applicationId->EditValue ?>"<?= $Grid->applicationId->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->applicationId->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="fed_school" data-field="x_applicationId" data-hidden="1" name="o<?= $Grid->RowIndex ?>_applicationId" id="o<?= $Grid->RowIndex ?>_applicationId" value="<?= HtmlEncode($Grid->applicationId->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($Grid->applicationId->getSessionValue() != "") { ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_applicationId" class="form-group">
<span<?= $Grid->applicationId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->applicationId->getDisplayValue($Grid->applicationId->ViewValue))) ?>"></span>
</span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_applicationId" name="x<?= $Grid->RowIndex ?>_applicationId" value="<?= HtmlEncode($Grid->applicationId->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_applicationId" class="form-group">
<input type="<?= $Grid->applicationId->getInputTextType() ?>" data-table="fed_school" data-field="x_applicationId" name="x<?= $Grid->RowIndex ?>_applicationId" id="x<?= $Grid->RowIndex ?>_applicationId" size="30" placeholder="<?= HtmlEncode($Grid->applicationId->getPlaceHolder()) ?>" value="<?= $Grid->applicationId->EditValue ?>"<?= $Grid->applicationId->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->applicationId->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_applicationId">
<span<?= $Grid->applicationId->viewAttributes() ?>>
<?= $Grid->applicationId->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="fed_school" data-field="x_applicationId" data-hidden="1" name="ffed_schoolgrid$x<?= $Grid->RowIndex ?>_applicationId" id="ffed_schoolgrid$x<?= $Grid->RowIndex ?>_applicationId" value="<?= HtmlEncode($Grid->applicationId->FormValue) ?>">
<input type="hidden" data-table="fed_school" data-field="x_applicationId" data-hidden="1" name="ffed_schoolgrid$o<?= $Grid->RowIndex ?>_applicationId" id="ffed_schoolgrid$o<?= $Grid->RowIndex ?>_applicationId" value="<?= HtmlEncode($Grid->applicationId->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->isheadquarter->Visible) { // isheadquarter ?>
        <td data-name="isheadquarter" <?= $Grid->isheadquarter->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_isheadquarter" class="form-group">
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" class="custom-control-input<?= $Grid->isheadquarter->isInvalidClass() ?>" data-table="fed_school" data-field="x_isheadquarter" name="x<?= $Grid->RowIndex ?>_isheadquarter[]" id="x<?= $Grid->RowIndex ?>_isheadquarter_783901" value="1"<?= ConvertToBool($Grid->isheadquarter->CurrentValue) ? " checked" : "" ?><?= $Grid->isheadquarter->editAttributes() ?>>
    <label class="custom-control-label" for="x<?= $Grid->RowIndex ?>_isheadquarter_783901"></label>
</div>
<div class="invalid-feedback"><?= $Grid->isheadquarter->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="fed_school" data-field="x_isheadquarter" data-hidden="1" name="o<?= $Grid->RowIndex ?>_isheadquarter[]" id="o<?= $Grid->RowIndex ?>_isheadquarter[]" value="<?= HtmlEncode($Grid->isheadquarter->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_isheadquarter" class="form-group">
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" class="custom-control-input<?= $Grid->isheadquarter->isInvalidClass() ?>" data-table="fed_school" data-field="x_isheadquarter" name="x<?= $Grid->RowIndex ?>_isheadquarter[]" id="x<?= $Grid->RowIndex ?>_isheadquarter_522805" value="1"<?= ConvertToBool($Grid->isheadquarter->CurrentValue) ? " checked" : "" ?><?= $Grid->isheadquarter->editAttributes() ?>>
    <label class="custom-control-label" for="x<?= $Grid->RowIndex ?>_isheadquarter_522805"></label>
</div>
<div class="invalid-feedback"><?= $Grid->isheadquarter->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_fed_school_isheadquarter">
<span<?= $Grid->isheadquarter->viewAttributes() ?>>
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" id="x_isheadquarter_<?= $Grid->RowCount ?>" class="custom-control-input" value="<?= $Grid->isheadquarter->getViewValue() ?>" disabled<?php if (ConvertToBool($Grid->isheadquarter->CurrentValue)) { ?> checked<?php } ?>>
    <label class="custom-control-label" for="x_isheadquarter_<?= $Grid->RowCount ?>"></label>
</div></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="fed_school" data-field="x_isheadquarter" data-hidden="1" name="ffed_schoolgrid$x<?= $Grid->RowIndex ?>_isheadquarter" id="ffed_schoolgrid$x<?= $Grid->RowIndex ?>_isheadquarter" value="<?= HtmlEncode($Grid->isheadquarter->FormValue) ?>">
<input type="hidden" data-table="fed_school" data-field="x_isheadquarter" data-hidden="1" name="ffed_schoolgrid$o<?= $Grid->RowIndex ?>_isheadquarter[]" id="ffed_schoolgrid$o<?= $Grid->RowIndex ?>_isheadquarter[]" value="<?= HtmlEncode($Grid->isheadquarter->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == ROWTYPE_ADD || $Grid->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["ffed_schoolgrid","load"], function () {
    ffed_schoolgrid.updateLists(<?= $Grid->RowIndex ?>);
});
</script>
<?php } ?>
<?php
    }
    } // End delete row checking
    if (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy")
        if (!$Grid->Recordset->EOF) {
            $Grid->Recordset->moveNext();
        }
}
?>
<?php
    if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy" || $Grid->CurrentMode == "edit") {
        $Grid->RowIndex = '$rowindex$';
        $Grid->loadRowValues();

        // Set row properties
        $Grid->resetAttributes();
        $Grid->RowAttrs->merge(["data-rowindex" => $Grid->RowIndex, "id" => "r0_fed_school", "data-rowtype" => ROWTYPE_ADD]);
        $Grid->RowAttrs->appendClass("ew-template");
        $Grid->RowType = ROWTYPE_ADD;

        // Render row
        $Grid->renderRow();

        // Render list options
        $Grid->renderListOptions();
        $Grid->StartRowCount = 0;
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowIndex);
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id">
<?php if (!$Grid->isConfirm()) { ?>
<span id="el$rowindex$_fed_school_id" class="form-group fed_school_id"></span>
<?php } else { ?>
<span id="el$rowindex$_fed_school_id" class="form-group fed_school_id">
<span<?= $Grid->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->id->getDisplayValue($Grid->id->ViewValue))) ?>"></span>
</span>
<input type="hidden" data-table="fed_school" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="fed_school" data-field="x_id" data-hidden="1" name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
</td>
    <?php } ?>
    <?php if ($Grid->masterSchoolId->Visible) { // masterSchoolId ?>
        <td data-name="masterSchoolId">
<?php if (!$Grid->isConfirm()) { ?>
<span id="el$rowindex$_fed_school_masterSchoolId" class="form-group fed_school_masterSchoolId">
<?php $Grid->masterSchoolId->EditAttrs->prepend("onchange", "ew.updateOptions.call(this);"); ?>
    <select
        id="x<?= $Grid->RowIndex ?>_masterSchoolId"
        name="x<?= $Grid->RowIndex ?>_masterSchoolId"
        class="form-control ew-select<?= $Grid->masterSchoolId->isInvalidClass() ?>"
        data-select2-id="fed_school_x<?= $Grid->RowIndex ?>_masterSchoolId"
        data-table="fed_school"
        data-field="x_masterSchoolId"
        data-value-separator="<?= $Grid->masterSchoolId->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->masterSchoolId->getPlaceHolder()) ?>"
        <?= $Grid->masterSchoolId->editAttributes() ?>>
        <?= $Grid->masterSchoolId->selectOptionListHtml("x{$Grid->RowIndex}_masterSchoolId") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->masterSchoolId->getErrorMessage() ?></div>
<?= $Grid->masterSchoolId->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_masterSchoolId") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='fed_school_x<?= $Grid->RowIndex ?>_masterSchoolId']"),
        options = { name: "x<?= $Grid->RowIndex ?>_masterSchoolId", selectId: "fed_school_x<?= $Grid->RowIndex ?>_masterSchoolId", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.fed_school.fields.masterSchoolId.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
<?php } else { ?>
<span id="el$rowindex$_fed_school_masterSchoolId" class="form-group fed_school_masterSchoolId">
<span<?= $Grid->masterSchoolId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->masterSchoolId->getDisplayValue($Grid->masterSchoolId->ViewValue))) ?>"></span>
</span>
<input type="hidden" data-table="fed_school" data-field="x_masterSchoolId" data-hidden="1" name="x<?= $Grid->RowIndex ?>_masterSchoolId" id="x<?= $Grid->RowIndex ?>_masterSchoolId" value="<?= HtmlEncode($Grid->masterSchoolId->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="fed_school" data-field="x_masterSchoolId" data-hidden="1" name="o<?= $Grid->RowIndex ?>_masterSchoolId" id="o<?= $Grid->RowIndex ?>_masterSchoolId" value="<?= HtmlEncode($Grid->masterSchoolId->OldValue) ?>">
</td>
    <?php } ?>
    <?php if ($Grid->school->Visible) { // school ?>
        <td data-name="school">
<?php if (!$Grid->isConfirm()) { ?>
<span id="el$rowindex$_fed_school_school" class="form-group fed_school_school">
<input type="<?= $Grid->school->getInputTextType() ?>" data-table="fed_school" data-field="x_school" name="x<?= $Grid->RowIndex ?>_school" id="x<?= $Grid->RowIndex ?>_school" size="30" maxlength="45" placeholder="<?= HtmlEncode($Grid->school->getPlaceHolder()) ?>" value="<?= $Grid->school->EditValue ?>"<?= $Grid->school->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->school->getErrorMessage() ?></div>
</span>
<?php } else { ?>
<span id="el$rowindex$_fed_school_school" class="form-group fed_school_school">
<span<?= $Grid->school->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->school->getDisplayValue($Grid->school->ViewValue))) ?>"></span>
</span>
<input type="hidden" data-table="fed_school" data-field="x_school" data-hidden="1" name="x<?= $Grid->RowIndex ?>_school" id="x<?= $Grid->RowIndex ?>_school" value="<?= HtmlEncode($Grid->school->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="fed_school" data-field="x_school" data-hidden="1" name="o<?= $Grid->RowIndex ?>_school" id="o<?= $Grid->RowIndex ?>_school" value="<?= HtmlEncode($Grid->school->OldValue) ?>">
</td>
    <?php } ?>
    <?php if ($Grid->countryId->Visible) { // countryId ?>
        <td data-name="countryId">
<?php if (!$Grid->isConfirm()) { ?>
<span id="el$rowindex$_fed_school_countryId" class="form-group fed_school_countryId">
    <select
        id="x<?= $Grid->RowIndex ?>_countryId"
        name="x<?= $Grid->RowIndex ?>_countryId"
        class="form-control ew-select<?= $Grid->countryId->isInvalidClass() ?>"
        data-select2-id="fed_school_x<?= $Grid->RowIndex ?>_countryId"
        data-table="fed_school"
        data-field="x_countryId"
        data-value-separator="<?= $Grid->countryId->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->countryId->getPlaceHolder()) ?>"
        <?= $Grid->countryId->editAttributes() ?>>
        <?= $Grid->countryId->selectOptionListHtml("x{$Grid->RowIndex}_countryId") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->countryId->getErrorMessage() ?></div>
<?= $Grid->countryId->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_countryId") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='fed_school_x<?= $Grid->RowIndex ?>_countryId']"),
        options = { name: "x<?= $Grid->RowIndex ?>_countryId", selectId: "fed_school_x<?= $Grid->RowIndex ?>_countryId", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.fed_school.fields.countryId.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
<?php } else { ?>
<span id="el$rowindex$_fed_school_countryId" class="form-group fed_school_countryId">
<span<?= $Grid->countryId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->countryId->getDisplayValue($Grid->countryId->ViewValue))) ?>"></span>
</span>
<input type="hidden" data-table="fed_school" data-field="x_countryId" data-hidden="1" name="x<?= $Grid->RowIndex ?>_countryId" id="x<?= $Grid->RowIndex ?>_countryId" value="<?= HtmlEncode($Grid->countryId->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="fed_school" data-field="x_countryId" data-hidden="1" name="o<?= $Grid->RowIndex ?>_countryId" id="o<?= $Grid->RowIndex ?>_countryId" value="<?= HtmlEncode($Grid->countryId->OldValue) ?>">
</td>
    <?php } ?>
    <?php if ($Grid->cityId->Visible) { // cityId ?>
        <td data-name="cityId">
<?php if (!$Grid->isConfirm()) { ?>
<span id="el$rowindex$_fed_school_cityId" class="form-group fed_school_cityId">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_cityId"
        name="x<?= $Grid->RowIndex ?>_cityId"
        class="form-control ew-select<?= $Grid->cityId->isInvalidClass() ?>"
        data-select2-id="fed_school_x<?= $Grid->RowIndex ?>_cityId"
        data-table="fed_school"
        data-field="x_cityId"
        data-value-separator="<?= $Grid->cityId->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->cityId->getPlaceHolder()) ?>"
        <?= $Grid->cityId->editAttributes() ?>>
        <?= $Grid->cityId->selectOptionListHtml("x{$Grid->RowIndex}_cityId") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "conf_city") && !$Grid->cityId->ReadOnly) { ?>
    <div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_cityId" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->cityId->caption() ?>" data-title="<?= $Grid->cityId->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?= $Grid->RowIndex ?>_cityId',url:'<?= GetUrl("ConfCityAddopt") ?>'});"><i class="fas fa-plus ew-icon"></i></button></div>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->cityId->getErrorMessage() ?></div>
<?= $Grid->cityId->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_cityId") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='fed_school_x<?= $Grid->RowIndex ?>_cityId']"),
        options = { name: "x<?= $Grid->RowIndex ?>_cityId", selectId: "fed_school_x<?= $Grid->RowIndex ?>_cityId", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.fed_school.fields.cityId.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
<?php } else { ?>
<span id="el$rowindex$_fed_school_cityId" class="form-group fed_school_cityId">
<span<?= $Grid->cityId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->cityId->getDisplayValue($Grid->cityId->ViewValue))) ?>"></span>
</span>
<input type="hidden" data-table="fed_school" data-field="x_cityId" data-hidden="1" name="x<?= $Grid->RowIndex ?>_cityId" id="x<?= $Grid->RowIndex ?>_cityId" value="<?= HtmlEncode($Grid->cityId->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="fed_school" data-field="x_cityId" data-hidden="1" name="o<?= $Grid->RowIndex ?>_cityId" id="o<?= $Grid->RowIndex ?>_cityId" value="<?= HtmlEncode($Grid->cityId->OldValue) ?>">
</td>
    <?php } ?>
    <?php if ($Grid->owner->Visible) { // owner ?>
        <td data-name="owner">
<?php if (!$Grid->isConfirm()) { ?>
<span id="el$rowindex$_fed_school_owner" class="form-group fed_school_owner">
<input type="<?= $Grid->owner->getInputTextType() ?>" data-table="fed_school" data-field="x_owner" name="x<?= $Grid->RowIndex ?>_owner" id="x<?= $Grid->RowIndex ?>_owner" size="30" maxlength="45" placeholder="<?= HtmlEncode($Grid->owner->getPlaceHolder()) ?>" value="<?= $Grid->owner->EditValue ?>"<?= $Grid->owner->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->owner->getErrorMessage() ?></div>
</span>
<?php } else { ?>
<span id="el$rowindex$_fed_school_owner" class="form-group fed_school_owner">
<span<?= $Grid->owner->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->owner->getDisplayValue($Grid->owner->ViewValue))) ?>"></span>
</span>
<input type="hidden" data-table="fed_school" data-field="x_owner" data-hidden="1" name="x<?= $Grid->RowIndex ?>_owner" id="x<?= $Grid->RowIndex ?>_owner" value="<?= HtmlEncode($Grid->owner->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="fed_school" data-field="x_owner" data-hidden="1" name="o<?= $Grid->RowIndex ?>_owner" id="o<?= $Grid->RowIndex ?>_owner" value="<?= HtmlEncode($Grid->owner->OldValue) ?>">
</td>
    <?php } ?>
    <?php if ($Grid->applicationId->Visible) { // applicationId ?>
        <td data-name="applicationId">
<?php if (!$Grid->isConfirm()) { ?>
<?php if ($Grid->applicationId->getSessionValue() != "") { ?>
<span id="el$rowindex$_fed_school_applicationId" class="form-group fed_school_applicationId">
<span<?= $Grid->applicationId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->applicationId->getDisplayValue($Grid->applicationId->ViewValue))) ?>"></span>
</span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_applicationId" name="x<?= $Grid->RowIndex ?>_applicationId" value="<?= HtmlEncode($Grid->applicationId->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el$rowindex$_fed_school_applicationId" class="form-group fed_school_applicationId">
<input type="<?= $Grid->applicationId->getInputTextType() ?>" data-table="fed_school" data-field="x_applicationId" name="x<?= $Grid->RowIndex ?>_applicationId" id="x<?= $Grid->RowIndex ?>_applicationId" size="30" placeholder="<?= HtmlEncode($Grid->applicationId->getPlaceHolder()) ?>" value="<?= $Grid->applicationId->EditValue ?>"<?= $Grid->applicationId->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->applicationId->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_fed_school_applicationId" class="form-group fed_school_applicationId">
<span<?= $Grid->applicationId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->applicationId->getDisplayValue($Grid->applicationId->ViewValue))) ?>"></span>
</span>
<input type="hidden" data-table="fed_school" data-field="x_applicationId" data-hidden="1" name="x<?= $Grid->RowIndex ?>_applicationId" id="x<?= $Grid->RowIndex ?>_applicationId" value="<?= HtmlEncode($Grid->applicationId->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="fed_school" data-field="x_applicationId" data-hidden="1" name="o<?= $Grid->RowIndex ?>_applicationId" id="o<?= $Grid->RowIndex ?>_applicationId" value="<?= HtmlEncode($Grid->applicationId->OldValue) ?>">
</td>
    <?php } ?>
    <?php if ($Grid->isheadquarter->Visible) { // isheadquarter ?>
        <td data-name="isheadquarter">
<?php if (!$Grid->isConfirm()) { ?>
<span id="el$rowindex$_fed_school_isheadquarter" class="form-group fed_school_isheadquarter">
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" class="custom-control-input<?= $Grid->isheadquarter->isInvalidClass() ?>" data-table="fed_school" data-field="x_isheadquarter" name="x<?= $Grid->RowIndex ?>_isheadquarter[]" id="x<?= $Grid->RowIndex ?>_isheadquarter_755028" value="1"<?= ConvertToBool($Grid->isheadquarter->CurrentValue) ? " checked" : "" ?><?= $Grid->isheadquarter->editAttributes() ?>>
    <label class="custom-control-label" for="x<?= $Grid->RowIndex ?>_isheadquarter_755028"></label>
</div>
<div class="invalid-feedback"><?= $Grid->isheadquarter->getErrorMessage() ?></div>
</span>
<?php } else { ?>
<span id="el$rowindex$_fed_school_isheadquarter" class="form-group fed_school_isheadquarter">
<span<?= $Grid->isheadquarter->viewAttributes() ?>>
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" id="x_isheadquarter_<?= $Grid->RowCount ?>" class="custom-control-input" value="<?= $Grid->isheadquarter->ViewValue ?>" disabled<?php if (ConvertToBool($Grid->isheadquarter->CurrentValue)) { ?> checked<?php } ?>>
    <label class="custom-control-label" for="x_isheadquarter_<?= $Grid->RowCount ?>"></label>
</div></span>
</span>
<input type="hidden" data-table="fed_school" data-field="x_isheadquarter" data-hidden="1" name="x<?= $Grid->RowIndex ?>_isheadquarter" id="x<?= $Grid->RowIndex ?>_isheadquarter" value="<?= HtmlEncode($Grid->isheadquarter->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="fed_school" data-field="x_isheadquarter" data-hidden="1" name="o<?= $Grid->RowIndex ?>_isheadquarter[]" id="o<?= $Grid->RowIndex ?>_isheadquarter[]" value="<?= HtmlEncode($Grid->isheadquarter->OldValue) ?>">
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowIndex);
?>
<script>
loadjs.ready(["ffed_schoolgrid","load"], function() {
    ffed_schoolgrid.updateLists(<?= $Grid->RowIndex ?>);
});
</script>
    </tr>
<?php
    }
?>
</tbody>
</table><!-- /.ew-table -->
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="ffed_schoolgrid">
</div><!-- /.ew-list-form -->
<?php
// Close recordset
if ($Grid->Recordset) {
    $Grid->Recordset->close();
}
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($Grid->TotalRecords == 0 && !$Grid->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("fed_school");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
