<?php

namespace PHPMaker2021\school;

// Set up and run Grid object
$Grid = Container("TesCandidateGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var currentForm, currentPageID;
var ftes_candidategrid;
loadjs.ready("head", function () {
    var $ = jQuery;
    // Form object
    ftes_candidategrid = new ew.Form("ftes_candidategrid", "grid");
    ftes_candidategrid.formKeyCountName = '<?= $Grid->FormKeyCountName ?>';

    // Add fields
    var currentTable = <?= JsonEncode(GetClientVar("tables", "tes_candidate")) ?>,
        fields = currentTable.fields;
    if (!ew.vars.tables.tes_candidate)
        ew.vars.tables.tes_candidate = currentTable;
    ftes_candidategrid.addFields([
        ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
        ["memberId", [fields.memberId.visible && fields.memberId.required ? ew.Validators.required(fields.memberId.caption) : null, ew.Validators.integer], fields.memberId.isInvalid],
        ["rankId", [fields.rankId.visible && fields.rankId.required ? ew.Validators.required(fields.rankId.caption) : null], fields.rankId.isInvalid],
        ["nextRankId", [fields.nextRankId.visible && fields.nextRankId.required ? ew.Validators.required(fields.nextRankId.caption) : null], fields.nextRankId.isInvalid],
        ["testPaid", [fields.testPaid.visible && fields.testPaid.required ? ew.Validators.required(fields.testPaid.caption) : null], fields.testPaid.isInvalid],
        ["memberAge", [fields.memberAge.visible && fields.memberAge.required ? ew.Validators.required(fields.memberAge.caption) : null, ew.Validators.integer], fields.memberAge.isInvalid],
        ["renew", [fields.renew.visible && fields.renew.required ? ew.Validators.required(fields.renew.caption) : null], fields.renew.isInvalid],
        ["schoolId", [fields.schoolId.visible && fields.schoolId.required ? ew.Validators.required(fields.schoolId.caption) : null], fields.schoolId.isInvalid],
        ["result", [fields.result.visible && fields.result.required ? ew.Validators.required(fields.result.caption) : null], fields.result.isInvalid],
        ["createUseriD", [fields.createUseriD.visible && fields.createUseriD.required ? ew.Validators.required(fields.createUseriD.caption) : null], fields.createUseriD.isInvalid],
        ["createDate", [fields.createDate.visible && fields.createDate.required ? ew.Validators.required(fields.createDate.caption) : null], fields.createDate.isInvalid],
        ["testNominated", [fields.testNominated.visible && fields.testNominated.required ? ew.Validators.required(fields.testNominated.caption) : null], fields.testNominated.isInvalid]
    ]);

    // Set invalid fields
    $(function() {
        var f = ftes_candidategrid,
            fobj = f.getForm(),
            $fobj = $(fobj),
            $k = $fobj.find("#" + f.formKeyCountName), // Get key_count
            rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1,
            startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
        for (var i = startcnt; i <= rowcnt; i++) {
            var rowIndex = ($k[0]) ? String(i) : "";
            f.setInvalid(rowIndex);
        }
    });

    // Validate form
    ftes_candidategrid.validate = function () {
        if (!this.validateRequired)
            return true; // Ignore validation
        var fobj = this.getForm(),
            $fobj = $(fobj);
        if ($fobj.find("#confirm").val() == "confirm")
            return true;
        var addcnt = 0,
            $k = $fobj.find("#" + this.formKeyCountName), // Get key_count
            rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1,
            startcnt = (rowcnt == 0) ? 0 : 1, // Check rowcnt == 0 => Inline-Add
            gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
        for (var i = startcnt; i <= rowcnt; i++) {
            var rowIndex = ($k[0]) ? String(i) : "";
            $fobj.data("rowindex", rowIndex);
            var checkrow = (gridinsert) ? !this.emptyRow(rowIndex) : true;
            if (checkrow) {
                addcnt++;

            // Validate fields
            if (!this.validateFields(rowIndex))
                return false;

            // Call Form_CustomValidate event
            if (!this.customValidate(fobj)) {
                this.focus();
                return false;
            }
            } // End Grid Add checking
        }
        return true;
    }

    // Check empty row
    ftes_candidategrid.emptyRow = function (rowIndex) {
        var fobj = this.getForm();
        if (ew.valueChanged(fobj, rowIndex, "memberId", false))
            return false;
        if (ew.valueChanged(fobj, rowIndex, "rankId", false))
            return false;
        if (ew.valueChanged(fobj, rowIndex, "nextRankId", false))
            return false;
        if (ew.valueChanged(fobj, rowIndex, "testPaid[]", true))
            return false;
        if (ew.valueChanged(fobj, rowIndex, "memberAge", false))
            return false;
        if (ew.valueChanged(fobj, rowIndex, "renew[]", true))
            return false;
        if (ew.valueChanged(fobj, rowIndex, "result[]", true))
            return false;
        if (ew.valueChanged(fobj, rowIndex, "testNominated[]", true))
            return false;
        return true;
    }

    // Form_CustomValidate
    ftes_candidategrid.customValidate = function(fobj) { // DO NOT CHANGE THIS LINE!
        // Your custom validation code here, return false if invalid.
        return true;
    }

    // Use JavaScript validation or not
    ftes_candidategrid.validateRequired = <?= Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

    // Dynamic selection lists
    ftes_candidategrid.lists.memberId = <?= $Grid->memberId->toClientList($Grid) ?>;
    ftes_candidategrid.lists.rankId = <?= $Grid->rankId->toClientList($Grid) ?>;
    ftes_candidategrid.lists.nextRankId = <?= $Grid->nextRankId->toClientList($Grid) ?>;
    ftes_candidategrid.lists.testPaid = <?= $Grid->testPaid->toClientList($Grid) ?>;
    ftes_candidategrid.lists.renew = <?= $Grid->renew->toClientList($Grid) ?>;
    ftes_candidategrid.lists.result = <?= $Grid->result->toClientList($Grid) ?>;
    ftes_candidategrid.lists.createUseriD = <?= $Grid->createUseriD->toClientList($Grid) ?>;
    ftes_candidategrid.lists.testNominated = <?= $Grid->testNominated->toClientList($Grid) ?>;
    loadjs.done("ftes_candidategrid");
});
</script>
<?php } ?>
<?php
$Grid->renderOtherOptions();
?>
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($Grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> tes_candidate">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="ftes_candidategrid" class="ew-form ew-list-form form-inline">
<div id="gmp_tes_candidate" class="<?= ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<table id="tbl_tes_candidategrid" class="table ew-table"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = ROWTYPE_HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Grid->id->headerCellClass() ?>"><div id="elh_tes_candidate_id" class="tes_candidate_id"><?= $Grid->renderSort($Grid->id) ?></div></th>
<?php } ?>
<?php if ($Grid->memberId->Visible) { // memberId ?>
        <th data-name="memberId" class="<?= $Grid->memberId->headerCellClass() ?>"><div id="elh_tes_candidate_memberId" class="tes_candidate_memberId"><?= $Grid->renderSort($Grid->memberId) ?></div></th>
<?php } ?>
<?php if ($Grid->rankId->Visible) { // rankId ?>
        <th data-name="rankId" class="<?= $Grid->rankId->headerCellClass() ?>"><div id="elh_tes_candidate_rankId" class="tes_candidate_rankId"><?= $Grid->renderSort($Grid->rankId) ?></div></th>
<?php } ?>
<?php if ($Grid->nextRankId->Visible) { // nextRankId ?>
        <th data-name="nextRankId" class="<?= $Grid->nextRankId->headerCellClass() ?>"><div id="elh_tes_candidate_nextRankId" class="tes_candidate_nextRankId"><?= $Grid->renderSort($Grid->nextRankId) ?></div></th>
<?php } ?>
<?php if ($Grid->testPaid->Visible) { // testPaid ?>
        <th data-name="testPaid" class="<?= $Grid->testPaid->headerCellClass() ?>"><div id="elh_tes_candidate_testPaid" class="tes_candidate_testPaid"><?= $Grid->renderSort($Grid->testPaid) ?></div></th>
<?php } ?>
<?php if ($Grid->memberAge->Visible) { // memberAge ?>
        <th data-name="memberAge" class="<?= $Grid->memberAge->headerCellClass() ?>"><div id="elh_tes_candidate_memberAge" class="tes_candidate_memberAge"><?= $Grid->renderSort($Grid->memberAge) ?></div></th>
<?php } ?>
<?php if ($Grid->renew->Visible) { // renew ?>
        <th data-name="renew" class="<?= $Grid->renew->headerCellClass() ?>"><div id="elh_tes_candidate_renew" class="tes_candidate_renew"><?= $Grid->renderSort($Grid->renew) ?></div></th>
<?php } ?>
<?php if ($Grid->schoolId->Visible) { // schoolId ?>
        <th data-name="schoolId" class="<?= $Grid->schoolId->headerCellClass() ?>"><div id="elh_tes_candidate_schoolId" class="tes_candidate_schoolId"><?= $Grid->renderSort($Grid->schoolId) ?></div></th>
<?php } ?>
<?php if ($Grid->result->Visible) { // result ?>
        <th data-name="result" class="<?= $Grid->result->headerCellClass() ?>"><div id="elh_tes_candidate_result" class="tes_candidate_result"><?= $Grid->renderSort($Grid->result) ?></div></th>
<?php } ?>
<?php if ($Grid->createUseriD->Visible) { // createUseriD ?>
        <th data-name="createUseriD" class="<?= $Grid->createUseriD->headerCellClass() ?>"><div id="elh_tes_candidate_createUseriD" class="tes_candidate_createUseriD"><?= $Grid->renderSort($Grid->createUseriD) ?></div></th>
<?php } ?>
<?php if ($Grid->createDate->Visible) { // createDate ?>
        <th data-name="createDate" class="<?= $Grid->createDate->headerCellClass() ?>"><div id="elh_tes_candidate_createDate" class="tes_candidate_createDate"><?= $Grid->renderSort($Grid->createDate) ?></div></th>
<?php } ?>
<?php if ($Grid->testNominated->Visible) { // testNominated ?>
        <th data-name="testNominated" class="<?= $Grid->testNominated->headerCellClass() ?>"><div id="elh_tes_candidate_testNominated" class="tes_candidate_testNominated"><?= $Grid->renderSort($Grid->testNominated) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody>
<?php
$Grid->StartRecord = 1;
$Grid->StopRecord = $Grid->TotalRecords; // Show all records

// Restore number of post back records
if ($CurrentForm && ($Grid->isConfirm() || $Grid->EventCancelled)) {
    $CurrentForm->Index = -1;
    if ($CurrentForm->hasValue($Grid->FormKeyCountName) && ($Grid->isGridAdd() || $Grid->isGridEdit() || $Grid->isConfirm())) {
        $Grid->KeyCount = $CurrentForm->getValue($Grid->FormKeyCountName);
        $Grid->StopRecord = $Grid->StartRecord + $Grid->KeyCount - 1;
    }
}
$Grid->RecordCount = $Grid->StartRecord - 1;
if ($Grid->Recordset && !$Grid->Recordset->EOF) {
    // Nothing to do
} elseif (!$Grid->AllowAddDeleteRow && $Grid->StopRecord == 0) {
    $Grid->StopRecord = $Grid->GridAddRowCount;
}

// Initialize aggregate
$Grid->RowType = ROWTYPE_AGGREGATEINIT;
$Grid->resetAttributes();
$Grid->renderRow();
if ($Grid->isGridAdd())
    $Grid->RowIndex = 0;
if ($Grid->isGridEdit())
    $Grid->RowIndex = 0;
while ($Grid->RecordCount < $Grid->StopRecord) {
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->RowCount++;
        if ($Grid->isGridAdd() || $Grid->isGridEdit() || $Grid->isConfirm()) {
            $Grid->RowIndex++;
            $CurrentForm->Index = $Grid->RowIndex;
            if ($CurrentForm->hasValue($Grid->FormActionName) && ($Grid->isConfirm() || $Grid->EventCancelled)) {
                $Grid->RowAction = strval($CurrentForm->getValue($Grid->FormActionName));
            } elseif ($Grid->isGridAdd()) {
                $Grid->RowAction = "insert";
            } else {
                $Grid->RowAction = "";
            }
        }

        // Set up key count
        $Grid->KeyCount = $Grid->RowIndex;

        // Init row class and style
        $Grid->resetAttributes();
        $Grid->CssClass = "";
        if ($Grid->isGridAdd()) {
            if ($Grid->CurrentMode == "copy") {
                $Grid->loadRowValues($Grid->Recordset); // Load row values
                $Grid->OldKey = $Grid->getKey(true); // Get from CurrentValue
            } else {
                $Grid->loadRowValues(); // Load default values
                $Grid->OldKey = "";
            }
        } else {
            $Grid->loadRowValues($Grid->Recordset); // Load row values
            $Grid->OldKey = $Grid->getKey(true); // Get from CurrentValue
        }
        $Grid->setKey($Grid->OldKey);
        $Grid->RowType = ROWTYPE_VIEW; // Render view
        if ($Grid->isGridAdd()) { // Grid add
            $Grid->RowType = ROWTYPE_ADD; // Render add
        }
        if ($Grid->isGridAdd() && $Grid->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) { // Insert failed
            $Grid->restoreCurrentRowFormValues($Grid->RowIndex); // Restore form values
        }
        if ($Grid->isGridEdit()) { // Grid edit
            if ($Grid->EventCancelled) {
                $Grid->restoreCurrentRowFormValues($Grid->RowIndex); // Restore form values
            }
            if ($Grid->RowAction == "insert") {
                $Grid->RowType = ROWTYPE_ADD; // Render add
            } else {
                $Grid->RowType = ROWTYPE_EDIT; // Render edit
            }
        }
        if ($Grid->isGridEdit() && ($Grid->RowType == ROWTYPE_EDIT || $Grid->RowType == ROWTYPE_ADD) && $Grid->EventCancelled) { // Update failed
            $Grid->restoreCurrentRowFormValues($Grid->RowIndex); // Restore form values
        }
        if ($Grid->RowType == ROWTYPE_EDIT) { // Edit row
            $Grid->EditRowCount++;
        }
        if ($Grid->isConfirm()) { // Confirm row
            $Grid->restoreCurrentRowFormValues($Grid->RowIndex); // Restore form values
        }

        // Set up row id / data-rowindex
        $Grid->RowAttrs->merge(["data-rowindex" => $Grid->RowCount, "id" => "r" . $Grid->RowCount . "_tes_candidate", "data-rowtype" => $Grid->RowType]);

        // Render row
        $Grid->renderRow();

        // Render list options
        $Grid->renderListOptions();

        // Skip delete row / empty row for confirm page
        if ($Grid->RowAction != "delete" && $Grid->RowAction != "insertdelete" && !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow())) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id" <?= $Grid->id->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_id" class="form-group"></span>
<input type="hidden" data-table="tes_candidate" data-field="x_id" data-hidden="1" name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_id" class="form-group">
<span<?= $Grid->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->id->getDisplayValue($Grid->id->EditValue))) ?>"></span>
</span>
<input type="hidden" data-table="tes_candidate" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_id">
<span<?= $Grid->id->viewAttributes() ?>>
<?= $Grid->id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="tes_candidate" data-field="x_id" data-hidden="1" name="ftes_candidategrid$x<?= $Grid->RowIndex ?>_id" id="ftes_candidategrid$x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->FormValue) ?>">
<input type="hidden" data-table="tes_candidate" data-field="x_id" data-hidden="1" name="ftes_candidategrid$o<?= $Grid->RowIndex ?>_id" id="ftes_candidategrid$o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="tes_candidate" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->memberId->Visible) { // memberId ?>
        <td data-name="memberId" <?= $Grid->memberId->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_memberId" class="form-group">
<?php
$onchange = $Grid->memberId->EditAttrs->prepend("onchange", "ew.autoFill(this);");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$Grid->memberId->EditAttrs["onchange"] = "";
?>
<span id="as_x<?= $Grid->RowIndex ?>_memberId" class="ew-auto-suggest">
    <input type="<?= $Grid->memberId->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_memberId" id="sv_x<?= $Grid->RowIndex ?>_memberId" value="<?= RemoveHtml($Grid->memberId->EditValue) ?>" size="30" placeholder="<?= HtmlEncode($Grid->memberId->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->memberId->getPlaceHolder()) ?>"<?= $Grid->memberId->editAttributes() ?>>
</span>
<input type="hidden" is="selection-list" class="form-control" data-table="tes_candidate" data-field="x_memberId" data-input="sv_x<?= $Grid->RowIndex ?>_memberId" data-value-separator="<?= $Grid->memberId->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_memberId" id="x<?= $Grid->RowIndex ?>_memberId" value="<?= HtmlEncode($Grid->memberId->CurrentValue) ?>"<?= $onchange ?>>
<div class="invalid-feedback"><?= $Grid->memberId->getErrorMessage() ?></div>
<script>
loadjs.ready(["ftes_candidategrid"], function() {
    ftes_candidategrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_memberId","forceSelect":true}, ew.vars.tables.tes_candidate.fields.memberId.autoSuggestOptions));
});
</script>
<?= $Grid->memberId->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_memberId") ?>
</span>
<input type="hidden" data-table="tes_candidate" data-field="x_memberId" data-hidden="1" name="o<?= $Grid->RowIndex ?>_memberId" id="o<?= $Grid->RowIndex ?>_memberId" value="<?= HtmlEncode($Grid->memberId->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_memberId" class="form-group">
<?php
$onchange = $Grid->memberId->EditAttrs->prepend("onchange", "ew.autoFill(this);");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$Grid->memberId->EditAttrs["onchange"] = "";
?>
<span id="as_x<?= $Grid->RowIndex ?>_memberId" class="ew-auto-suggest">
    <input type="<?= $Grid->memberId->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_memberId" id="sv_x<?= $Grid->RowIndex ?>_memberId" value="<?= RemoveHtml($Grid->memberId->EditValue) ?>" size="30" placeholder="<?= HtmlEncode($Grid->memberId->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->memberId->getPlaceHolder()) ?>"<?= $Grid->memberId->editAttributes() ?>>
</span>
<input type="hidden" is="selection-list" class="form-control" data-table="tes_candidate" data-field="x_memberId" data-input="sv_x<?= $Grid->RowIndex ?>_memberId" data-value-separator="<?= $Grid->memberId->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_memberId" id="x<?= $Grid->RowIndex ?>_memberId" value="<?= HtmlEncode($Grid->memberId->CurrentValue) ?>"<?= $onchange ?>>
<div class="invalid-feedback"><?= $Grid->memberId->getErrorMessage() ?></div>
<script>
loadjs.ready(["ftes_candidategrid"], function() {
    ftes_candidategrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_memberId","forceSelect":true}, ew.vars.tables.tes_candidate.fields.memberId.autoSuggestOptions));
});
</script>
<?= $Grid->memberId->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_memberId") ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_memberId">
<span<?= $Grid->memberId->viewAttributes() ?>>
<?= $Grid->memberId->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="tes_candidate" data-field="x_memberId" data-hidden="1" name="ftes_candidategrid$x<?= $Grid->RowIndex ?>_memberId" id="ftes_candidategrid$x<?= $Grid->RowIndex ?>_memberId" value="<?= HtmlEncode($Grid->memberId->FormValue) ?>">
<input type="hidden" data-table="tes_candidate" data-field="x_memberId" data-hidden="1" name="ftes_candidategrid$o<?= $Grid->RowIndex ?>_memberId" id="ftes_candidategrid$o<?= $Grid->RowIndex ?>_memberId" value="<?= HtmlEncode($Grid->memberId->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->rankId->Visible) { // rankId ?>
        <td data-name="rankId" <?= $Grid->rankId->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_rankId" class="form-group">
<?php $Grid->rankId->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
    <select
        id="x<?= $Grid->RowIndex ?>_rankId"
        name="x<?= $Grid->RowIndex ?>_rankId"
        class="form-control ew-select<?= $Grid->rankId->isInvalidClass() ?>"
        data-select2-id="tes_candidate_x<?= $Grid->RowIndex ?>_rankId"
        data-table="tes_candidate"
        data-field="x_rankId"
        data-value-separator="<?= $Grid->rankId->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->rankId->getPlaceHolder()) ?>"
        <?= $Grid->rankId->editAttributes() ?>>
        <?= $Grid->rankId->selectOptionListHtml("x{$Grid->RowIndex}_rankId") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->rankId->getErrorMessage() ?></div>
<?= $Grid->rankId->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_rankId") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='tes_candidate_x<?= $Grid->RowIndex ?>_rankId']"),
        options = { name: "x<?= $Grid->RowIndex ?>_rankId", selectId: "tes_candidate_x<?= $Grid->RowIndex ?>_rankId", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.tes_candidate.fields.rankId.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
<input type="hidden" data-table="tes_candidate" data-field="x_rankId" data-hidden="1" name="o<?= $Grid->RowIndex ?>_rankId" id="o<?= $Grid->RowIndex ?>_rankId" value="<?= HtmlEncode($Grid->rankId->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_rankId" class="form-group">
<?php $Grid->rankId->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
    <select
        id="x<?= $Grid->RowIndex ?>_rankId"
        name="x<?= $Grid->RowIndex ?>_rankId"
        class="form-control ew-select<?= $Grid->rankId->isInvalidClass() ?>"
        data-select2-id="tes_candidate_x<?= $Grid->RowIndex ?>_rankId"
        data-table="tes_candidate"
        data-field="x_rankId"
        data-value-separator="<?= $Grid->rankId->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->rankId->getPlaceHolder()) ?>"
        <?= $Grid->rankId->editAttributes() ?>>
        <?= $Grid->rankId->selectOptionListHtml("x{$Grid->RowIndex}_rankId") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->rankId->getErrorMessage() ?></div>
<?= $Grid->rankId->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_rankId") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='tes_candidate_x<?= $Grid->RowIndex ?>_rankId']"),
        options = { name: "x<?= $Grid->RowIndex ?>_rankId", selectId: "tes_candidate_x<?= $Grid->RowIndex ?>_rankId", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.tes_candidate.fields.rankId.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_rankId">
<span<?= $Grid->rankId->viewAttributes() ?>>
<?= $Grid->rankId->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="tes_candidate" data-field="x_rankId" data-hidden="1" name="ftes_candidategrid$x<?= $Grid->RowIndex ?>_rankId" id="ftes_candidategrid$x<?= $Grid->RowIndex ?>_rankId" value="<?= HtmlEncode($Grid->rankId->FormValue) ?>">
<input type="hidden" data-table="tes_candidate" data-field="x_rankId" data-hidden="1" name="ftes_candidategrid$o<?= $Grid->RowIndex ?>_rankId" id="ftes_candidategrid$o<?= $Grid->RowIndex ?>_rankId" value="<?= HtmlEncode($Grid->rankId->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->nextRankId->Visible) { // nextRankId ?>
        <td data-name="nextRankId" <?= $Grid->nextRankId->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_nextRankId" class="form-group">
    <select
        id="x<?= $Grid->RowIndex ?>_nextRankId"
        name="x<?= $Grid->RowIndex ?>_nextRankId"
        class="form-control ew-select<?= $Grid->nextRankId->isInvalidClass() ?>"
        data-select2-id="tes_candidate_x<?= $Grid->RowIndex ?>_nextRankId"
        data-table="tes_candidate"
        data-field="x_nextRankId"
        data-value-separator="<?= $Grid->nextRankId->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->nextRankId->getPlaceHolder()) ?>"
        <?= $Grid->nextRankId->editAttributes() ?>>
        <?= $Grid->nextRankId->selectOptionListHtml("x{$Grid->RowIndex}_nextRankId") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->nextRankId->getErrorMessage() ?></div>
<?= $Grid->nextRankId->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_nextRankId") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='tes_candidate_x<?= $Grid->RowIndex ?>_nextRankId']"),
        options = { name: "x<?= $Grid->RowIndex ?>_nextRankId", selectId: "tes_candidate_x<?= $Grid->RowIndex ?>_nextRankId", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.tes_candidate.fields.nextRankId.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
<input type="hidden" data-table="tes_candidate" data-field="x_nextRankId" data-hidden="1" name="o<?= $Grid->RowIndex ?>_nextRankId" id="o<?= $Grid->RowIndex ?>_nextRankId" value="<?= HtmlEncode($Grid->nextRankId->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_nextRankId" class="form-group">
    <select
        id="x<?= $Grid->RowIndex ?>_nextRankId"
        name="x<?= $Grid->RowIndex ?>_nextRankId"
        class="form-control ew-select<?= $Grid->nextRankId->isInvalidClass() ?>"
        data-select2-id="tes_candidate_x<?= $Grid->RowIndex ?>_nextRankId"
        data-table="tes_candidate"
        data-field="x_nextRankId"
        data-value-separator="<?= $Grid->nextRankId->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->nextRankId->getPlaceHolder()) ?>"
        <?= $Grid->nextRankId->editAttributes() ?>>
        <?= $Grid->nextRankId->selectOptionListHtml("x{$Grid->RowIndex}_nextRankId") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->nextRankId->getErrorMessage() ?></div>
<?= $Grid->nextRankId->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_nextRankId") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='tes_candidate_x<?= $Grid->RowIndex ?>_nextRankId']"),
        options = { name: "x<?= $Grid->RowIndex ?>_nextRankId", selectId: "tes_candidate_x<?= $Grid->RowIndex ?>_nextRankId", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.tes_candidate.fields.nextRankId.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_nextRankId">
<span<?= $Grid->nextRankId->viewAttributes() ?>>
<?= $Grid->nextRankId->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="tes_candidate" data-field="x_nextRankId" data-hidden="1" name="ftes_candidategrid$x<?= $Grid->RowIndex ?>_nextRankId" id="ftes_candidategrid$x<?= $Grid->RowIndex ?>_nextRankId" value="<?= HtmlEncode($Grid->nextRankId->FormValue) ?>">
<input type="hidden" data-table="tes_candidate" data-field="x_nextRankId" data-hidden="1" name="ftes_candidategrid$o<?= $Grid->RowIndex ?>_nextRankId" id="ftes_candidategrid$o<?= $Grid->RowIndex ?>_nextRankId" value="<?= HtmlEncode($Grid->nextRankId->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->testPaid->Visible) { // testPaid ?>
        <td data-name="testPaid" <?= $Grid->testPaid->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_testPaid" class="form-group">
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" class="custom-control-input<?= $Grid->testPaid->isInvalidClass() ?>" data-table="tes_candidate" data-field="x_testPaid" name="x<?= $Grid->RowIndex ?>_testPaid[]" id="x<?= $Grid->RowIndex ?>_testPaid_917942" value="1"<?= ConvertToBool($Grid->testPaid->CurrentValue) ? " checked" : "" ?><?= $Grid->testPaid->editAttributes() ?>>
    <label class="custom-control-label" for="x<?= $Grid->RowIndex ?>_testPaid_917942"></label>
</div>
<div class="invalid-feedback"><?= $Grid->testPaid->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="tes_candidate" data-field="x_testPaid" data-hidden="1" name="o<?= $Grid->RowIndex ?>_testPaid[]" id="o<?= $Grid->RowIndex ?>_testPaid[]" value="<?= HtmlEncode($Grid->testPaid->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_testPaid" class="form-group">
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" class="custom-control-input<?= $Grid->testPaid->isInvalidClass() ?>" data-table="tes_candidate" data-field="x_testPaid" name="x<?= $Grid->RowIndex ?>_testPaid[]" id="x<?= $Grid->RowIndex ?>_testPaid_564366" value="1"<?= ConvertToBool($Grid->testPaid->CurrentValue) ? " checked" : "" ?><?= $Grid->testPaid->editAttributes() ?>>
    <label class="custom-control-label" for="x<?= $Grid->RowIndex ?>_testPaid_564366"></label>
</div>
<div class="invalid-feedback"><?= $Grid->testPaid->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_testPaid">
<span<?= $Grid->testPaid->viewAttributes() ?>>
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" id="x_testPaid_<?= $Grid->RowCount ?>" class="custom-control-input" value="<?= $Grid->testPaid->getViewValue() ?>" disabled<?php if (ConvertToBool($Grid->testPaid->CurrentValue)) { ?> checked<?php } ?>>
    <label class="custom-control-label" for="x_testPaid_<?= $Grid->RowCount ?>"></label>
</div></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="tes_candidate" data-field="x_testPaid" data-hidden="1" name="ftes_candidategrid$x<?= $Grid->RowIndex ?>_testPaid" id="ftes_candidategrid$x<?= $Grid->RowIndex ?>_testPaid" value="<?= HtmlEncode($Grid->testPaid->FormValue) ?>">
<input type="hidden" data-table="tes_candidate" data-field="x_testPaid" data-hidden="1" name="ftes_candidategrid$o<?= $Grid->RowIndex ?>_testPaid[]" id="ftes_candidategrid$o<?= $Grid->RowIndex ?>_testPaid[]" value="<?= HtmlEncode($Grid->testPaid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->memberAge->Visible) { // memberAge ?>
        <td data-name="memberAge" <?= $Grid->memberAge->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_memberAge" class="form-group">
<input type="<?= $Grid->memberAge->getInputTextType() ?>" data-table="tes_candidate" data-field="x_memberAge" name="x<?= $Grid->RowIndex ?>_memberAge" id="x<?= $Grid->RowIndex ?>_memberAge" size="4" placeholder="<?= HtmlEncode($Grid->memberAge->getPlaceHolder()) ?>" value="<?= $Grid->memberAge->EditValue ?>"<?= $Grid->memberAge->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->memberAge->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="tes_candidate" data-field="x_memberAge" data-hidden="1" name="o<?= $Grid->RowIndex ?>_memberAge" id="o<?= $Grid->RowIndex ?>_memberAge" value="<?= HtmlEncode($Grid->memberAge->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_memberAge" class="form-group">
<input type="<?= $Grid->memberAge->getInputTextType() ?>" data-table="tes_candidate" data-field="x_memberAge" name="x<?= $Grid->RowIndex ?>_memberAge" id="x<?= $Grid->RowIndex ?>_memberAge" size="4" placeholder="<?= HtmlEncode($Grid->memberAge->getPlaceHolder()) ?>" value="<?= $Grid->memberAge->EditValue ?>"<?= $Grid->memberAge->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->memberAge->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_memberAge">
<span<?= $Grid->memberAge->viewAttributes() ?>>
<?= $Grid->memberAge->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="tes_candidate" data-field="x_memberAge" data-hidden="1" name="ftes_candidategrid$x<?= $Grid->RowIndex ?>_memberAge" id="ftes_candidategrid$x<?= $Grid->RowIndex ?>_memberAge" value="<?= HtmlEncode($Grid->memberAge->FormValue) ?>">
<input type="hidden" data-table="tes_candidate" data-field="x_memberAge" data-hidden="1" name="ftes_candidategrid$o<?= $Grid->RowIndex ?>_memberAge" id="ftes_candidategrid$o<?= $Grid->RowIndex ?>_memberAge" value="<?= HtmlEncode($Grid->memberAge->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->renew->Visible) { // renew ?>
        <td data-name="renew" <?= $Grid->renew->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_renew" class="form-group">
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" class="custom-control-input<?= $Grid->renew->isInvalidClass() ?>" data-table="tes_candidate" data-field="x_renew" name="x<?= $Grid->RowIndex ?>_renew[]" id="x<?= $Grid->RowIndex ?>_renew_132074" value="1"<?= ConvertToBool($Grid->renew->CurrentValue) ? " checked" : "" ?><?= $Grid->renew->editAttributes() ?>>
    <label class="custom-control-label" for="x<?= $Grid->RowIndex ?>_renew_132074"></label>
</div>
<div class="invalid-feedback"><?= $Grid->renew->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="tes_candidate" data-field="x_renew" data-hidden="1" name="o<?= $Grid->RowIndex ?>_renew[]" id="o<?= $Grid->RowIndex ?>_renew[]" value="<?= HtmlEncode($Grid->renew->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_renew" class="form-group">
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" class="custom-control-input<?= $Grid->renew->isInvalidClass() ?>" data-table="tes_candidate" data-field="x_renew" name="x<?= $Grid->RowIndex ?>_renew[]" id="x<?= $Grid->RowIndex ?>_renew_712491" value="1"<?= ConvertToBool($Grid->renew->CurrentValue) ? " checked" : "" ?><?= $Grid->renew->editAttributes() ?>>
    <label class="custom-control-label" for="x<?= $Grid->RowIndex ?>_renew_712491"></label>
</div>
<div class="invalid-feedback"><?= $Grid->renew->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_renew">
<span<?= $Grid->renew->viewAttributes() ?>>
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" id="x_renew_<?= $Grid->RowCount ?>" class="custom-control-input" value="<?= $Grid->renew->getViewValue() ?>" disabled<?php if (ConvertToBool($Grid->renew->CurrentValue)) { ?> checked<?php } ?>>
    <label class="custom-control-label" for="x_renew_<?= $Grid->RowCount ?>"></label>
</div></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="tes_candidate" data-field="x_renew" data-hidden="1" name="ftes_candidategrid$x<?= $Grid->RowIndex ?>_renew" id="ftes_candidategrid$x<?= $Grid->RowIndex ?>_renew" value="<?= HtmlEncode($Grid->renew->FormValue) ?>">
<input type="hidden" data-table="tes_candidate" data-field="x_renew" data-hidden="1" name="ftes_candidategrid$o<?= $Grid->RowIndex ?>_renew[]" id="ftes_candidategrid$o<?= $Grid->RowIndex ?>_renew[]" value="<?= HtmlEncode($Grid->renew->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->schoolId->Visible) { // schoolId ?>
        <td data-name="schoolId" <?= $Grid->schoolId->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="tes_candidate" data-field="x_schoolId" data-hidden="1" name="o<?= $Grid->RowIndex ?>_schoolId" id="o<?= $Grid->RowIndex ?>_schoolId" value="<?= HtmlEncode($Grid->schoolId->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_schoolId">
<span<?= $Grid->schoolId->viewAttributes() ?>>
<?= $Grid->schoolId->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="tes_candidate" data-field="x_schoolId" data-hidden="1" name="ftes_candidategrid$x<?= $Grid->RowIndex ?>_schoolId" id="ftes_candidategrid$x<?= $Grid->RowIndex ?>_schoolId" value="<?= HtmlEncode($Grid->schoolId->FormValue) ?>">
<input type="hidden" data-table="tes_candidate" data-field="x_schoolId" data-hidden="1" name="ftes_candidategrid$o<?= $Grid->RowIndex ?>_schoolId" id="ftes_candidategrid$o<?= $Grid->RowIndex ?>_schoolId" value="<?= HtmlEncode($Grid->schoolId->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->result->Visible) { // result ?>
        <td data-name="result" <?= $Grid->result->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_result" class="form-group">
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" class="custom-control-input<?= $Grid->result->isInvalidClass() ?>" data-table="tes_candidate" data-field="x_result" name="x<?= $Grid->RowIndex ?>_result[]" id="x<?= $Grid->RowIndex ?>_result_636435" value="1"<?= ConvertToBool($Grid->result->CurrentValue) ? " checked" : "" ?><?= $Grid->result->editAttributes() ?>>
    <label class="custom-control-label" for="x<?= $Grid->RowIndex ?>_result_636435"></label>
</div>
<div class="invalid-feedback"><?= $Grid->result->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="tes_candidate" data-field="x_result" data-hidden="1" name="o<?= $Grid->RowIndex ?>_result[]" id="o<?= $Grid->RowIndex ?>_result[]" value="<?= HtmlEncode($Grid->result->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_result" class="form-group">
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" class="custom-control-input<?= $Grid->result->isInvalidClass() ?>" data-table="tes_candidate" data-field="x_result" name="x<?= $Grid->RowIndex ?>_result[]" id="x<?= $Grid->RowIndex ?>_result_970917" value="1"<?= ConvertToBool($Grid->result->CurrentValue) ? " checked" : "" ?><?= $Grid->result->editAttributes() ?>>
    <label class="custom-control-label" for="x<?= $Grid->RowIndex ?>_result_970917"></label>
</div>
<div class="invalid-feedback"><?= $Grid->result->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_result">
<span<?= $Grid->result->viewAttributes() ?>>
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" id="x_result_<?= $Grid->RowCount ?>" class="custom-control-input" value="<?= $Grid->result->getViewValue() ?>" disabled<?php if (ConvertToBool($Grid->result->CurrentValue)) { ?> checked<?php } ?>>
    <label class="custom-control-label" for="x_result_<?= $Grid->RowCount ?>"></label>
</div></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="tes_candidate" data-field="x_result" data-hidden="1" name="ftes_candidategrid$x<?= $Grid->RowIndex ?>_result" id="ftes_candidategrid$x<?= $Grid->RowIndex ?>_result" value="<?= HtmlEncode($Grid->result->FormValue) ?>">
<input type="hidden" data-table="tes_candidate" data-field="x_result" data-hidden="1" name="ftes_candidategrid$o<?= $Grid->RowIndex ?>_result[]" id="ftes_candidategrid$o<?= $Grid->RowIndex ?>_result[]" value="<?= HtmlEncode($Grid->result->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->createUseriD->Visible) { // createUseriD ?>
        <td data-name="createUseriD" <?= $Grid->createUseriD->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="tes_candidate" data-field="x_createUseriD" data-hidden="1" name="o<?= $Grid->RowIndex ?>_createUseriD" id="o<?= $Grid->RowIndex ?>_createUseriD" value="<?= HtmlEncode($Grid->createUseriD->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_createUseriD">
<span<?= $Grid->createUseriD->viewAttributes() ?>>
<?= $Grid->createUseriD->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="tes_candidate" data-field="x_createUseriD" data-hidden="1" name="ftes_candidategrid$x<?= $Grid->RowIndex ?>_createUseriD" id="ftes_candidategrid$x<?= $Grid->RowIndex ?>_createUseriD" value="<?= HtmlEncode($Grid->createUseriD->FormValue) ?>">
<input type="hidden" data-table="tes_candidate" data-field="x_createUseriD" data-hidden="1" name="ftes_candidategrid$o<?= $Grid->RowIndex ?>_createUseriD" id="ftes_candidategrid$o<?= $Grid->RowIndex ?>_createUseriD" value="<?= HtmlEncode($Grid->createUseriD->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->createDate->Visible) { // createDate ?>
        <td data-name="createDate" <?= $Grid->createDate->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="tes_candidate" data-field="x_createDate" data-hidden="1" name="o<?= $Grid->RowIndex ?>_createDate" id="o<?= $Grid->RowIndex ?>_createDate" value="<?= HtmlEncode($Grid->createDate->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_createDate">
<span<?= $Grid->createDate->viewAttributes() ?>>
<?= $Grid->createDate->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="tes_candidate" data-field="x_createDate" data-hidden="1" name="ftes_candidategrid$x<?= $Grid->RowIndex ?>_createDate" id="ftes_candidategrid$x<?= $Grid->RowIndex ?>_createDate" value="<?= HtmlEncode($Grid->createDate->FormValue) ?>">
<input type="hidden" data-table="tes_candidate" data-field="x_createDate" data-hidden="1" name="ftes_candidategrid$o<?= $Grid->RowIndex ?>_createDate" id="ftes_candidategrid$o<?= $Grid->RowIndex ?>_createDate" value="<?= HtmlEncode($Grid->createDate->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->testNominated->Visible) { // testNominated ?>
        <td data-name="testNominated" <?= $Grid->testNominated->cellAttributes() ?>>
<?php if ($Grid->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_testNominated" class="form-group">
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" class="custom-control-input<?= $Grid->testNominated->isInvalidClass() ?>" data-table="tes_candidate" data-field="x_testNominated" name="x<?= $Grid->RowIndex ?>_testNominated[]" id="x<?= $Grid->RowIndex ?>_testNominated_491202" value="1"<?= ConvertToBool($Grid->testNominated->CurrentValue) ? " checked" : "" ?><?= $Grid->testNominated->editAttributes() ?>>
    <label class="custom-control-label" for="x<?= $Grid->RowIndex ?>_testNominated_491202"></label>
</div>
<div class="invalid-feedback"><?= $Grid->testNominated->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="tes_candidate" data-field="x_testNominated" data-hidden="1" name="o<?= $Grid->RowIndex ?>_testNominated[]" id="o<?= $Grid->RowIndex ?>_testNominated[]" value="<?= HtmlEncode($Grid->testNominated->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_testNominated" class="form-group">
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" class="custom-control-input<?= $Grid->testNominated->isInvalidClass() ?>" data-table="tes_candidate" data-field="x_testNominated" name="x<?= $Grid->RowIndex ?>_testNominated[]" id="x<?= $Grid->RowIndex ?>_testNominated_240286" value="1"<?= ConvertToBool($Grid->testNominated->CurrentValue) ? " checked" : "" ?><?= $Grid->testNominated->editAttributes() ?>>
    <label class="custom-control-label" for="x<?= $Grid->RowIndex ?>_testNominated_240286"></label>
</div>
<div class="invalid-feedback"><?= $Grid->testNominated->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?= $Grid->RowCount ?>_tes_candidate_testNominated">
<span<?= $Grid->testNominated->viewAttributes() ?>>
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" id="x_testNominated_<?= $Grid->RowCount ?>" class="custom-control-input" value="<?= $Grid->testNominated->getViewValue() ?>" disabled<?php if (ConvertToBool($Grid->testNominated->CurrentValue)) { ?> checked<?php } ?>>
    <label class="custom-control-label" for="x_testNominated_<?= $Grid->RowCount ?>"></label>
</div></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="tes_candidate" data-field="x_testNominated" data-hidden="1" name="ftes_candidategrid$x<?= $Grid->RowIndex ?>_testNominated" id="ftes_candidategrid$x<?= $Grid->RowIndex ?>_testNominated" value="<?= HtmlEncode($Grid->testNominated->FormValue) ?>">
<input type="hidden" data-table="tes_candidate" data-field="x_testNominated" data-hidden="1" name="ftes_candidategrid$o<?= $Grid->RowIndex ?>_testNominated[]" id="ftes_candidategrid$o<?= $Grid->RowIndex ?>_testNominated[]" value="<?= HtmlEncode($Grid->testNominated->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == ROWTYPE_ADD || $Grid->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["ftes_candidategrid","load"], function () {
    ftes_candidategrid.updateLists(<?= $Grid->RowIndex ?>);
});
</script>
<?php } ?>
<?php
    }
    } // End delete row checking
    if (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy")
        if (!$Grid->Recordset->EOF) {
            $Grid->Recordset->moveNext();
        }
}
?>
<?php
    if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy" || $Grid->CurrentMode == "edit") {
        $Grid->RowIndex = '$rowindex$';
        $Grid->loadRowValues();

        // Set row properties
        $Grid->resetAttributes();
        $Grid->RowAttrs->merge(["data-rowindex" => $Grid->RowIndex, "id" => "r0_tes_candidate", "data-rowtype" => ROWTYPE_ADD]);
        $Grid->RowAttrs->appendClass("ew-template");
        $Grid->RowType = ROWTYPE_ADD;

        // Render row
        $Grid->renderRow();

        // Render list options
        $Grid->renderListOptions();
        $Grid->StartRowCount = 0;
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowIndex);
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id">
<?php if (!$Grid->isConfirm()) { ?>
<span id="el$rowindex$_tes_candidate_id" class="form-group tes_candidate_id"></span>
<?php } else { ?>
<span id="el$rowindex$_tes_candidate_id" class="form-group tes_candidate_id">
<span<?= $Grid->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->id->getDisplayValue($Grid->id->ViewValue))) ?>"></span>
</span>
<input type="hidden" data-table="tes_candidate" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="tes_candidate" data-field="x_id" data-hidden="1" name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
</td>
    <?php } ?>
    <?php if ($Grid->memberId->Visible) { // memberId ?>
        <td data-name="memberId">
<?php if (!$Grid->isConfirm()) { ?>
<span id="el$rowindex$_tes_candidate_memberId" class="form-group tes_candidate_memberId">
<?php
$onchange = $Grid->memberId->EditAttrs->prepend("onchange", "ew.autoFill(this);");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$Grid->memberId->EditAttrs["onchange"] = "";
?>
<span id="as_x<?= $Grid->RowIndex ?>_memberId" class="ew-auto-suggest">
    <input type="<?= $Grid->memberId->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_memberId" id="sv_x<?= $Grid->RowIndex ?>_memberId" value="<?= RemoveHtml($Grid->memberId->EditValue) ?>" size="30" placeholder="<?= HtmlEncode($Grid->memberId->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->memberId->getPlaceHolder()) ?>"<?= $Grid->memberId->editAttributes() ?>>
</span>
<input type="hidden" is="selection-list" class="form-control" data-table="tes_candidate" data-field="x_memberId" data-input="sv_x<?= $Grid->RowIndex ?>_memberId" data-value-separator="<?= $Grid->memberId->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_memberId" id="x<?= $Grid->RowIndex ?>_memberId" value="<?= HtmlEncode($Grid->memberId->CurrentValue) ?>"<?= $onchange ?>>
<div class="invalid-feedback"><?= $Grid->memberId->getErrorMessage() ?></div>
<script>
loadjs.ready(["ftes_candidategrid"], function() {
    ftes_candidategrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_memberId","forceSelect":true}, ew.vars.tables.tes_candidate.fields.memberId.autoSuggestOptions));
});
</script>
<?= $Grid->memberId->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_memberId") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_tes_candidate_memberId" class="form-group tes_candidate_memberId">
<span<?= $Grid->memberId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->memberId->getDisplayValue($Grid->memberId->ViewValue))) ?>"></span>
</span>
<input type="hidden" data-table="tes_candidate" data-field="x_memberId" data-hidden="1" name="x<?= $Grid->RowIndex ?>_memberId" id="x<?= $Grid->RowIndex ?>_memberId" value="<?= HtmlEncode($Grid->memberId->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="tes_candidate" data-field="x_memberId" data-hidden="1" name="o<?= $Grid->RowIndex ?>_memberId" id="o<?= $Grid->RowIndex ?>_memberId" value="<?= HtmlEncode($Grid->memberId->OldValue) ?>">
</td>
    <?php } ?>
    <?php if ($Grid->rankId->Visible) { // rankId ?>
        <td data-name="rankId">
<?php if (!$Grid->isConfirm()) { ?>
<span id="el$rowindex$_tes_candidate_rankId" class="form-group tes_candidate_rankId">
<?php $Grid->rankId->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
    <select
        id="x<?= $Grid->RowIndex ?>_rankId"
        name="x<?= $Grid->RowIndex ?>_rankId"
        class="form-control ew-select<?= $Grid->rankId->isInvalidClass() ?>"
        data-select2-id="tes_candidate_x<?= $Grid->RowIndex ?>_rankId"
        data-table="tes_candidate"
        data-field="x_rankId"
        data-value-separator="<?= $Grid->rankId->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->rankId->getPlaceHolder()) ?>"
        <?= $Grid->rankId->editAttributes() ?>>
        <?= $Grid->rankId->selectOptionListHtml("x{$Grid->RowIndex}_rankId") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->rankId->getErrorMessage() ?></div>
<?= $Grid->rankId->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_rankId") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='tes_candidate_x<?= $Grid->RowIndex ?>_rankId']"),
        options = { name: "x<?= $Grid->RowIndex ?>_rankId", selectId: "tes_candidate_x<?= $Grid->RowIndex ?>_rankId", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.tes_candidate.fields.rankId.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
<?php } else { ?>
<span id="el$rowindex$_tes_candidate_rankId" class="form-group tes_candidate_rankId">
<span<?= $Grid->rankId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->rankId->getDisplayValue($Grid->rankId->ViewValue))) ?>"></span>
</span>
<input type="hidden" data-table="tes_candidate" data-field="x_rankId" data-hidden="1" name="x<?= $Grid->RowIndex ?>_rankId" id="x<?= $Grid->RowIndex ?>_rankId" value="<?= HtmlEncode($Grid->rankId->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="tes_candidate" data-field="x_rankId" data-hidden="1" name="o<?= $Grid->RowIndex ?>_rankId" id="o<?= $Grid->RowIndex ?>_rankId" value="<?= HtmlEncode($Grid->rankId->OldValue) ?>">
</td>
    <?php } ?>
    <?php if ($Grid->nextRankId->Visible) { // nextRankId ?>
        <td data-name="nextRankId">
<?php if (!$Grid->isConfirm()) { ?>
<span id="el$rowindex$_tes_candidate_nextRankId" class="form-group tes_candidate_nextRankId">
    <select
        id="x<?= $Grid->RowIndex ?>_nextRankId"
        name="x<?= $Grid->RowIndex ?>_nextRankId"
        class="form-control ew-select<?= $Grid->nextRankId->isInvalidClass() ?>"
        data-select2-id="tes_candidate_x<?= $Grid->RowIndex ?>_nextRankId"
        data-table="tes_candidate"
        data-field="x_nextRankId"
        data-value-separator="<?= $Grid->nextRankId->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->nextRankId->getPlaceHolder()) ?>"
        <?= $Grid->nextRankId->editAttributes() ?>>
        <?= $Grid->nextRankId->selectOptionListHtml("x{$Grid->RowIndex}_nextRankId") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->nextRankId->getErrorMessage() ?></div>
<?= $Grid->nextRankId->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_nextRankId") ?>
<script>
loadjs.ready("head", function() {
    var el = document.querySelector("select[data-select2-id='tes_candidate_x<?= $Grid->RowIndex ?>_nextRankId']"),
        options = { name: "x<?= $Grid->RowIndex ?>_nextRankId", selectId: "tes_candidate_x<?= $Grid->RowIndex ?>_nextRankId", language: ew.LANGUAGE_ID, dir: ew.IS_RTL ? "rtl" : "ltr" };
    options.dropdownParent = $(el).closest("#ew-modal-dialog, #ew-add-opt-dialog")[0];
    Object.assign(options, ew.vars.tables.tes_candidate.fields.nextRankId.selectOptions);
    ew.createSelect(options);
});
</script>
</span>
<?php } else { ?>
<span id="el$rowindex$_tes_candidate_nextRankId" class="form-group tes_candidate_nextRankId">
<span<?= $Grid->nextRankId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->nextRankId->getDisplayValue($Grid->nextRankId->ViewValue))) ?>"></span>
</span>
<input type="hidden" data-table="tes_candidate" data-field="x_nextRankId" data-hidden="1" name="x<?= $Grid->RowIndex ?>_nextRankId" id="x<?= $Grid->RowIndex ?>_nextRankId" value="<?= HtmlEncode($Grid->nextRankId->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="tes_candidate" data-field="x_nextRankId" data-hidden="1" name="o<?= $Grid->RowIndex ?>_nextRankId" id="o<?= $Grid->RowIndex ?>_nextRankId" value="<?= HtmlEncode($Grid->nextRankId->OldValue) ?>">
</td>
    <?php } ?>
    <?php if ($Grid->testPaid->Visible) { // testPaid ?>
        <td data-name="testPaid">
<?php if (!$Grid->isConfirm()) { ?>
<span id="el$rowindex$_tes_candidate_testPaid" class="form-group tes_candidate_testPaid">
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" class="custom-control-input<?= $Grid->testPaid->isInvalidClass() ?>" data-table="tes_candidate" data-field="x_testPaid" name="x<?= $Grid->RowIndex ?>_testPaid[]" id="x<?= $Grid->RowIndex ?>_testPaid_299007" value="1"<?= ConvertToBool($Grid->testPaid->CurrentValue) ? " checked" : "" ?><?= $Grid->testPaid->editAttributes() ?>>
    <label class="custom-control-label" for="x<?= $Grid->RowIndex ?>_testPaid_299007"></label>
</div>
<div class="invalid-feedback"><?= $Grid->testPaid->getErrorMessage() ?></div>
</span>
<?php } else { ?>
<span id="el$rowindex$_tes_candidate_testPaid" class="form-group tes_candidate_testPaid">
<span<?= $Grid->testPaid->viewAttributes() ?>>
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" id="x_testPaid_<?= $Grid->RowCount ?>" class="custom-control-input" value="<?= $Grid->testPaid->ViewValue ?>" disabled<?php if (ConvertToBool($Grid->testPaid->CurrentValue)) { ?> checked<?php } ?>>
    <label class="custom-control-label" for="x_testPaid_<?= $Grid->RowCount ?>"></label>
</div></span>
</span>
<input type="hidden" data-table="tes_candidate" data-field="x_testPaid" data-hidden="1" name="x<?= $Grid->RowIndex ?>_testPaid" id="x<?= $Grid->RowIndex ?>_testPaid" value="<?= HtmlEncode($Grid->testPaid->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="tes_candidate" data-field="x_testPaid" data-hidden="1" name="o<?= $Grid->RowIndex ?>_testPaid[]" id="o<?= $Grid->RowIndex ?>_testPaid[]" value="<?= HtmlEncode($Grid->testPaid->OldValue) ?>">
</td>
    <?php } ?>
    <?php if ($Grid->memberAge->Visible) { // memberAge ?>
        <td data-name="memberAge">
<?php if (!$Grid->isConfirm()) { ?>
<span id="el$rowindex$_tes_candidate_memberAge" class="form-group tes_candidate_memberAge">
<input type="<?= $Grid->memberAge->getInputTextType() ?>" data-table="tes_candidate" data-field="x_memberAge" name="x<?= $Grid->RowIndex ?>_memberAge" id="x<?= $Grid->RowIndex ?>_memberAge" size="4" placeholder="<?= HtmlEncode($Grid->memberAge->getPlaceHolder()) ?>" value="<?= $Grid->memberAge->EditValue ?>"<?= $Grid->memberAge->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->memberAge->getErrorMessage() ?></div>
</span>
<?php } else { ?>
<span id="el$rowindex$_tes_candidate_memberAge" class="form-group tes_candidate_memberAge">
<span<?= $Grid->memberAge->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->memberAge->getDisplayValue($Grid->memberAge->ViewValue))) ?>"></span>
</span>
<input type="hidden" data-table="tes_candidate" data-field="x_memberAge" data-hidden="1" name="x<?= $Grid->RowIndex ?>_memberAge" id="x<?= $Grid->RowIndex ?>_memberAge" value="<?= HtmlEncode($Grid->memberAge->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="tes_candidate" data-field="x_memberAge" data-hidden="1" name="o<?= $Grid->RowIndex ?>_memberAge" id="o<?= $Grid->RowIndex ?>_memberAge" value="<?= HtmlEncode($Grid->memberAge->OldValue) ?>">
</td>
    <?php } ?>
    <?php if ($Grid->renew->Visible) { // renew ?>
        <td data-name="renew">
<?php if (!$Grid->isConfirm()) { ?>
<span id="el$rowindex$_tes_candidate_renew" class="form-group tes_candidate_renew">
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" class="custom-control-input<?= $Grid->renew->isInvalidClass() ?>" data-table="tes_candidate" data-field="x_renew" name="x<?= $Grid->RowIndex ?>_renew[]" id="x<?= $Grid->RowIndex ?>_renew_679752" value="1"<?= ConvertToBool($Grid->renew->CurrentValue) ? " checked" : "" ?><?= $Grid->renew->editAttributes() ?>>
    <label class="custom-control-label" for="x<?= $Grid->RowIndex ?>_renew_679752"></label>
</div>
<div class="invalid-feedback"><?= $Grid->renew->getErrorMessage() ?></div>
</span>
<?php } else { ?>
<span id="el$rowindex$_tes_candidate_renew" class="form-group tes_candidate_renew">
<span<?= $Grid->renew->viewAttributes() ?>>
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" id="x_renew_<?= $Grid->RowCount ?>" class="custom-control-input" value="<?= $Grid->renew->ViewValue ?>" disabled<?php if (ConvertToBool($Grid->renew->CurrentValue)) { ?> checked<?php } ?>>
    <label class="custom-control-label" for="x_renew_<?= $Grid->RowCount ?>"></label>
</div></span>
</span>
<input type="hidden" data-table="tes_candidate" data-field="x_renew" data-hidden="1" name="x<?= $Grid->RowIndex ?>_renew" id="x<?= $Grid->RowIndex ?>_renew" value="<?= HtmlEncode($Grid->renew->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="tes_candidate" data-field="x_renew" data-hidden="1" name="o<?= $Grid->RowIndex ?>_renew[]" id="o<?= $Grid->RowIndex ?>_renew[]" value="<?= HtmlEncode($Grid->renew->OldValue) ?>">
</td>
    <?php } ?>
    <?php if ($Grid->schoolId->Visible) { // schoolId ?>
        <td data-name="schoolId">
<?php if (!$Grid->isConfirm()) { ?>
<?php } else { ?>
<span id="el$rowindex$_tes_candidate_schoolId" class="form-group tes_candidate_schoolId">
<span<?= $Grid->schoolId->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->schoolId->getDisplayValue($Grid->schoolId->ViewValue))) ?>"></span>
</span>
<input type="hidden" data-table="tes_candidate" data-field="x_schoolId" data-hidden="1" name="x<?= $Grid->RowIndex ?>_schoolId" id="x<?= $Grid->RowIndex ?>_schoolId" value="<?= HtmlEncode($Grid->schoolId->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="tes_candidate" data-field="x_schoolId" data-hidden="1" name="o<?= $Grid->RowIndex ?>_schoolId" id="o<?= $Grid->RowIndex ?>_schoolId" value="<?= HtmlEncode($Grid->schoolId->OldValue) ?>">
</td>
    <?php } ?>
    <?php if ($Grid->result->Visible) { // result ?>
        <td data-name="result">
<?php if (!$Grid->isConfirm()) { ?>
<span id="el$rowindex$_tes_candidate_result" class="form-group tes_candidate_result">
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" class="custom-control-input<?= $Grid->result->isInvalidClass() ?>" data-table="tes_candidate" data-field="x_result" name="x<?= $Grid->RowIndex ?>_result[]" id="x<?= $Grid->RowIndex ?>_result_993991" value="1"<?= ConvertToBool($Grid->result->CurrentValue) ? " checked" : "" ?><?= $Grid->result->editAttributes() ?>>
    <label class="custom-control-label" for="x<?= $Grid->RowIndex ?>_result_993991"></label>
</div>
<div class="invalid-feedback"><?= $Grid->result->getErrorMessage() ?></div>
</span>
<?php } else { ?>
<span id="el$rowindex$_tes_candidate_result" class="form-group tes_candidate_result">
<span<?= $Grid->result->viewAttributes() ?>>
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" id="x_result_<?= $Grid->RowCount ?>" class="custom-control-input" value="<?= $Grid->result->ViewValue ?>" disabled<?php if (ConvertToBool($Grid->result->CurrentValue)) { ?> checked<?php } ?>>
    <label class="custom-control-label" for="x_result_<?= $Grid->RowCount ?>"></label>
</div></span>
</span>
<input type="hidden" data-table="tes_candidate" data-field="x_result" data-hidden="1" name="x<?= $Grid->RowIndex ?>_result" id="x<?= $Grid->RowIndex ?>_result" value="<?= HtmlEncode($Grid->result->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="tes_candidate" data-field="x_result" data-hidden="1" name="o<?= $Grid->RowIndex ?>_result[]" id="o<?= $Grid->RowIndex ?>_result[]" value="<?= HtmlEncode($Grid->result->OldValue) ?>">
</td>
    <?php } ?>
    <?php if ($Grid->createUseriD->Visible) { // createUseriD ?>
        <td data-name="createUseriD">
<?php if (!$Grid->isConfirm()) { ?>
<?php } else { ?>
<span id="el$rowindex$_tes_candidate_createUseriD" class="form-group tes_candidate_createUseriD">
<span<?= $Grid->createUseriD->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->createUseriD->getDisplayValue($Grid->createUseriD->ViewValue))) ?>"></span>
</span>
<input type="hidden" data-table="tes_candidate" data-field="x_createUseriD" data-hidden="1" name="x<?= $Grid->RowIndex ?>_createUseriD" id="x<?= $Grid->RowIndex ?>_createUseriD" value="<?= HtmlEncode($Grid->createUseriD->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="tes_candidate" data-field="x_createUseriD" data-hidden="1" name="o<?= $Grid->RowIndex ?>_createUseriD" id="o<?= $Grid->RowIndex ?>_createUseriD" value="<?= HtmlEncode($Grid->createUseriD->OldValue) ?>">
</td>
    <?php } ?>
    <?php if ($Grid->createDate->Visible) { // createDate ?>
        <td data-name="createDate">
<?php if (!$Grid->isConfirm()) { ?>
<?php } else { ?>
<span id="el$rowindex$_tes_candidate_createDate" class="form-group tes_candidate_createDate">
<span<?= $Grid->createDate->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->createDate->getDisplayValue($Grid->createDate->ViewValue))) ?>"></span>
</span>
<input type="hidden" data-table="tes_candidate" data-field="x_createDate" data-hidden="1" name="x<?= $Grid->RowIndex ?>_createDate" id="x<?= $Grid->RowIndex ?>_createDate" value="<?= HtmlEncode($Grid->createDate->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="tes_candidate" data-field="x_createDate" data-hidden="1" name="o<?= $Grid->RowIndex ?>_createDate" id="o<?= $Grid->RowIndex ?>_createDate" value="<?= HtmlEncode($Grid->createDate->OldValue) ?>">
</td>
    <?php } ?>
    <?php if ($Grid->testNominated->Visible) { // testNominated ?>
        <td data-name="testNominated">
<?php if (!$Grid->isConfirm()) { ?>
<span id="el$rowindex$_tes_candidate_testNominated" class="form-group tes_candidate_testNominated">
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" class="custom-control-input<?= $Grid->testNominated->isInvalidClass() ?>" data-table="tes_candidate" data-field="x_testNominated" name="x<?= $Grid->RowIndex ?>_testNominated[]" id="x<?= $Grid->RowIndex ?>_testNominated_368836" value="1"<?= ConvertToBool($Grid->testNominated->CurrentValue) ? " checked" : "" ?><?= $Grid->testNominated->editAttributes() ?>>
    <label class="custom-control-label" for="x<?= $Grid->RowIndex ?>_testNominated_368836"></label>
</div>
<div class="invalid-feedback"><?= $Grid->testNominated->getErrorMessage() ?></div>
</span>
<?php } else { ?>
<span id="el$rowindex$_tes_candidate_testNominated" class="form-group tes_candidate_testNominated">
<span<?= $Grid->testNominated->viewAttributes() ?>>
<div class="custom-control custom-checkbox d-inline-block">
    <input type="checkbox" id="x_testNominated_<?= $Grid->RowCount ?>" class="custom-control-input" value="<?= $Grid->testNominated->ViewValue ?>" disabled<?php if (ConvertToBool($Grid->testNominated->CurrentValue)) { ?> checked<?php } ?>>
    <label class="custom-control-label" for="x_testNominated_<?= $Grid->RowCount ?>"></label>
</div></span>
</span>
<input type="hidden" data-table="tes_candidate" data-field="x_testNominated" data-hidden="1" name="x<?= $Grid->RowIndex ?>_testNominated" id="x<?= $Grid->RowIndex ?>_testNominated" value="<?= HtmlEncode($Grid->testNominated->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="tes_candidate" data-field="x_testNominated" data-hidden="1" name="o<?= $Grid->RowIndex ?>_testNominated[]" id="o<?= $Grid->RowIndex ?>_testNominated[]" value="<?= HtmlEncode($Grid->testNominated->OldValue) ?>">
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowIndex);
?>
<script>
loadjs.ready(["ftes_candidategrid","load"], function() {
    ftes_candidategrid.updateLists(<?= $Grid->RowIndex ?>);
});
</script>
    </tr>
<?php
    }
?>
</tbody>
</table><!-- /.ew-table -->
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="ftes_candidategrid">
</div><!-- /.ew-list-form -->
<?php
// Close recordset
if ($Grid->Recordset) {
    $Grid->Recordset->close();
}
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($Grid->TotalRecords == 0 && !$Grid->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("tes_candidate");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
